/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.container.Appointment;
import java.util.List;

public class Bug12662Test
extends CalendarSqlTest {
    public void testParticipantRecurrenceDelete() {
        try {
            int cur;
            String uniqueTitle = "testBug12662-" + System.currentTimeMillis();
            CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.secondUser);
            appointment.setTitle(uniqueTitle);
            appointment.setRecurrenceType(1);
            appointment.setInterval(1);
            appointment.setOccurrence(4);
            this.appointments.save(appointment);
            this.clean.add(appointment);
            int objectId = appointment.getObjectID();
            CalendarDataObject changeException = this.appointments.createIdentifyingCopy(appointment);
            changeException.setTitle(uniqueTitle + " changed");
            changeException.setRecurrencePosition(2);
            this.appointments.save(changeException);
            this.clean.add(changeException);
            int changeId = changeException.getObjectID();
            this.appointments.switchUser(this.secondUser);
            appointment.setParentFolderID(this.appointments.getPrivateFolder());
            this.appointments.delete(appointment);
            List<Appointment> list = this.appointments.getAppointmentsInFolder(this.appointments.getPrivateFolder());
            int occurred = 0;
            for (Appointment cdao : list) {
                cur = cdao.getObjectID();
                if (cur <= 0 || cur != objectId && cur != changeId) continue;
                occurred = 1;
                break;
            }
            Bug12662Test.assertFalse((String)"Previously \"deleted\" daily appointment by second user still visible but shouldn't.", occurred != 0);
            this.appointments.switchUser(this.user);
            list = this.appointments.getAppointmentsInFolder(this.appointments.getPrivateFolder());
            occurred = 0;
            for (Appointment cdao : list) {
                cur = cdao.getObjectID();
                if (cur <= 0) continue;
                if (cur == objectId) {
                    occurred |= 1;
                } else if (cur == changeId) {
                    occurred |= 2;
                }
                if (occurred != 3) continue;
                break;
            }
            Bug12662Test.assertTrue((String)"Daily appointment not visible to first user but should.", (3 == occurred ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug12662Test.fail((String)e.getMessage());
        }
    }
}

