/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.dav.reports.SyncCollectionResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import java.util.List;
import java.util.Map;

public class DeleteTest
extends CardDAVTest {
    public DeleteTest(String name) {
        super(name);
    }

    public void testDeleteContactOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = DeleteTest.randomUID();
        String firstName = "test";
        String lastName = "banane";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        DeleteTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource contactCard = DeleteTest.assertContains(uid, addressData);
        DeleteTest.assertEquals((String)"N wrong", (String)firstName, (String)contactCard.getVCard().getName().getGivenName());
        DeleteTest.assertEquals((String)"N wrong", (String)lastName, (String)contactCard.getVCard().getName().getFamilyName());
        DeleteTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)contactCard.getVCard().getFormattedName().getFormattedName());
        super.delete(contact);
        SyncCollectionResponse syncCollectionResponse = super.syncCollection(syncToken);
        DeleteTest.assertTrue((String)"no resource deletions reported on sync collection", (0 < syncCollectionResponse.getHrefsStatusNotFound().size() ? 1 : 0) != 0);
        eTags = syncCollectionResponse.getETagsStatusOK();
    }

    public void testDeleteContactInSubfolderOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String folderName = "testfolder_" + DeleteTest.randomUID();
        FolderObject folder = super.createFolder(folderName);
        super.rememberForCleanUp(folder);
        String uid = DeleteTest.randomUID();
        String firstName = "test";
        String lastName = "otto";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact, folder.getObjectID()));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        DeleteTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource contactCard = DeleteTest.assertContains(uid, addressData);
        DeleteTest.assertEquals((String)"N wrong", (String)firstName, (String)contactCard.getVCard().getName().getGivenName());
        DeleteTest.assertEquals((String)"N wrong", (String)lastName, (String)contactCard.getVCard().getName().getFamilyName());
        DeleteTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)contactCard.getVCard().getFormattedName().getFormattedName());
        super.delete(contact);
        SyncCollectionResponse syncCollectionResponse = super.syncCollection(syncToken);
        DeleteTest.assertTrue((String)"no resource deletions reported on sync collection", (0 < syncCollectionResponse.getHrefsStatusNotFound().size() ? 1 : 0) != 0);
    }

    public void testDeleteContactOnClient() throws Throwable {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = DeleteTest.randomUID();
        String firstName = "test";
        String lastName = "manfred";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        DeleteTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = DeleteTest.assertContains(uid, addressData);
        DeleteTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getVCard().getName().getGivenName());
        DeleteTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getVCard().getName().getFamilyName());
        DeleteTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getVCard().getFormattedName().getFormattedName());
        DeleteTest.assertEquals((String)"response code wrong", (int)200, (int)this.delete(uid));
        DeleteTest.assertNull((String)"contact not deleted on server", (Object)super.getContact(uid));
        SyncCollectionResponse syncCollectionResponse = super.syncCollection(syncToken);
        DeleteTest.assertTrue((String)"no resource deletions reported on sync collection", (0 < syncCollectionResponse.getHrefsStatusNotFound().size() ? 1 : 0) != 0);
        eTags = syncCollectionResponse.getETagsStatusOK();
    }
}

