/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.cardme.engine.VCardEngine;
import net.sourceforge.cardme.io.CompatibilityMode;
import net.sourceforge.cardme.io.VCardWriter;
import net.sourceforge.cardme.vcard.VCard;
import net.sourceforge.cardme.vcard.VCardVersion;
import net.sourceforge.cardme.vcard.features.ExtendedFeature;
import net.sourceforge.cardme.vcard.features.FormattedNameFeature;
import net.sourceforge.cardme.vcard.features.UIDFeature;

public class VCardResource {
    private static final VCardEngine PARSER = new VCardEngine(CompatibilityMode.MAC_ADDRESS_BOOK);
    private static final VCardWriter WRITER = new VCardWriter(VCardVersion.V3_0, CompatibilityMode.MAC_ADDRESS_BOOK);
    private final String eTag;
    private final String href;
    private final VCard vCard;

    public VCardResource(String vCardString, String href, String eTag) throws IOException {
        this.vCard = PARSER.parse(vCardString);
        this.href = href;
        this.eTag = eTag;
    }

    public String getUID() {
        UIDFeature uidFeature = this.vCard.getUID();
        return null != uidFeature ? uidFeature.getUID() : null;
    }

    public String getFN() {
        FormattedNameFeature formattedName = this.vCard.getFormattedName();
        return null != formattedName ? formattedName.getFormattedName() : null;
    }

    public List<ExtendedFeature> getExtendedFeatures(String extensionName) {
        ArrayList<ExtendedFeature> xFeatures = new ArrayList<ExtendedFeature>();
        Iterator iter = this.vCard.getExtendedTypes();
        while (iter.hasNext()) {
            ExtendedFeature extension = (ExtendedFeature)iter.next();
            if (!extensionName.equals(extension.getExtensionName())) continue;
            xFeatures.add(extension);
        }
        return xFeatures;
    }

    public String getETag() {
        return this.eTag;
    }

    public String getHref() {
        return this.href;
    }

    public VCard getVCard() {
        return this.vCard;
    }

    public boolean isGroup() {
        List<ExtendedFeature> xFeatures = this.getExtendedFeatures("X-ADDRESSBOOKSERVER-KIND");
        return null != xFeatures && 0 < xFeatures.size() && "group".equals(xFeatures.get(0).getExtensionData());
    }

    public List<String> getMemberUIDs() {
        List<ExtendedFeature> members = this.getExtendedFeatures("X-ADDRESSBOOKSERVER-MEMBER");
        if (null == members) {
            return null;
        }
        ArrayList<String> uids = new ArrayList<String>();
        for (ExtendedFeature memberFeature : members) {
            uids.add(memberFeature.getExtensionData().substring(9));
        }
        return uids;
    }

    public ExtendedFeature getMemberXFeature(String uid) {
        List<ExtendedFeature> members = this.getExtendedFeatures("X-ADDRESSBOOKSERVER-MEMBER");
        if (null == members) {
            return null;
        }
        for (ExtendedFeature memberFeature : members) {
            if (!uid.equals(memberFeature.getExtensionData().substring(9))) continue;
            return memberFeature;
        }
        return null;
    }

    public String toString() {
        WRITER.setVCard(this.vCard);
        return WRITER.buildVCardString();
    }
}

