/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav;

import com.openexchange.configuration.ConfigurationException;
import com.openexchange.dav.Config;
import com.openexchange.dav.reports.SyncCollectionReportInfo;
import com.openexchange.dav.reports.SyncCollectionReportMethod;
import com.openexchange.dav.reports.SyncCollectionResponse;
import com.openexchange.exception.OXException;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.apache.jackrabbit.webdav.client.methods.ReportMethod;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;

public class WebDAVClient {
    private final HttpClient httpClient = new HttpClient();
    private String baseURI = null;

    public WebDAVClient(String userAgent) throws OXException {
        this.httpClient.getParams().setAuthenticationPreemptive(true);
        this.setCredentials(Config.getLogin(), Config.getPassword());
        this.setBaseURI(Config.getBaseUri());
        this.setUserAgent(userAgent);
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public void setUserAgent(String userAgent) {
        this.httpClient.getParams().setParameter("http.useragent", (Object)userAgent);
    }

    public void setCredentials(Credentials credentials) {
        this.httpClient.getState().setCredentials(AuthScope.ANY, credentials);
    }

    public void setCredentials(String login, String password) {
        this.setCredentials((Credentials)new UsernamePasswordCredentials(login, password));
    }

    public int executeMethod(HttpMethod method) throws HttpException, IOException {
        return this.httpClient.executeMethod(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPut(PutMethod put, int expectedStatus) throws HttpException, IOException {
        try {
            Assert.assertEquals((String)"unexpected http status", (int)expectedStatus, (int)this.httpClient.executeMethod((HttpMethod)put));
        }
        finally {
            WebDAVClient.release((HttpMethod)put);
        }
    }

    public void doPut(PutMethod put) throws HttpException, IOException {
        this.doPut(put, 201);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiStatusResponse[] doReport(ReportMethod report, int expectedStatus) throws HttpException, IOException, DavException {
        try {
            Assert.assertEquals((String)"unexpected http status", (int)expectedStatus, (int)this.httpClient.executeMethod((HttpMethod)report));
            MultiStatusResponse[] multiStatusResponseArray = report.getResponseBodyAsMultiStatus().getResponses();
            return multiStatusResponseArray;
        }
        catch (DavException e) {
            Assert.assertEquals((String)"unexpected http status", (int)expectedStatus, (int)e.getErrorCode());
            MultiStatusResponse[] multiStatusResponseArray = null;
            return multiStatusResponseArray;
        }
        finally {
            WebDAVClient.release((HttpMethod)report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncCollectionResponse doReport(SyncCollectionReportMethod report, int expectedStatus) throws HttpException, IOException, DavException {
        try {
            Assert.assertEquals((String)"unexpected http status", (int)expectedStatus, (int)this.httpClient.executeMethod((HttpMethod)report));
            SyncCollectionResponse syncCollectionResponse = report.getResponseBodyAsSyncCollection();
            return syncCollectionResponse;
        }
        catch (DavException e) {
            Assert.assertEquals((String)"unexpected http status", (int)expectedStatus, (int)e.getErrorCode());
            SyncCollectionResponse syncCollectionResponse = null;
            return syncCollectionResponse;
        }
        finally {
            WebDAVClient.release((HttpMethod)report);
        }
    }

    public MultiStatusResponse[] doReport(ReportMethod report) throws HttpException, IOException, DavException {
        return this.doReport(report, 207);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiStatusResponse[] doReport(ReportInfo reportInfo, String uri) throws ConfigurationException, IOException, DavException {
        ReportMethod report = null;
        MultiStatusResponse[] responses = null;
        try {
            report = new ReportMethod(uri, reportInfo);
            responses = this.doReport(report, 207);
        }
        catch (Throwable throwable) {
            WebDAVClient.release(report);
            throw throwable;
        }
        WebDAVClient.release((HttpMethod)report);
        Assert.assertNotNull((String)"got no response", (Object)responses);
        return responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncCollectionResponse doReport(SyncCollectionReportInfo reportInfo, String uri) throws ConfigurationException, IOException, DavException {
        SyncCollectionReportMethod report = null;
        SyncCollectionResponse response = null;
        try {
            report = new SyncCollectionReportMethod(uri, reportInfo);
            response = this.doReport(report, 207);
        }
        catch (Throwable throwable) {
            WebDAVClient.release(report);
            throw throwable;
        }
        WebDAVClient.release((HttpMethod)report);
        Assert.assertNotNull((String)"got no response", (Object)response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiStatusResponse[] doPropFind(PropFindMethod propFind, int expectedStatus) throws HttpException, IOException, DavException {
        try {
            Assert.assertEquals((String)"unexpected http status", (int)expectedStatus, (int)this.httpClient.executeMethod((HttpMethod)propFind));
            MultiStatusResponse[] multiStatusResponseArray = propFind.getResponseBodyAsMultiStatus().getResponses();
            return multiStatusResponseArray;
        }
        catch (DavException e) {
            Assert.assertEquals((String)"unexpected http status", (int)expectedStatus, (int)e.getErrorCode());
            MultiStatusResponse[] multiStatusResponseArray = null;
            return multiStatusResponseArray;
        }
        finally {
            WebDAVClient.release((HttpMethod)propFind);
        }
    }

    public MultiStatusResponse[] doPropFind(PropFindMethod propFind) throws HttpException, IOException, DavException {
        return this.doPropFind(propFind, 207);
    }

    public String doPost(PostMethod post) throws HttpException, IOException {
        return this.doPost(post, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPost(PostMethod post, int expectedStatus) throws HttpException, IOException {
        try {
            Assert.assertEquals((String)"unexpected http status", (int)expectedStatus, (int)this.httpClient.executeMethod((HttpMethod)post));
            String string = post.getResponseBodyAsString();
            return string;
        }
        finally {
            WebDAVClient.release((HttpMethod)post);
        }
    }

    private static void release(HttpMethod method) {
        if (null != method) {
            method.releaseConnection();
        }
    }
}

