/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cache.impl;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheElement;
import com.openexchange.caching.CacheExceptionCode;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.caching.CacheStatistics;
import com.openexchange.caching.ElementAttributes;
import com.openexchange.caching.dynamic.OXObjectFactory;
import com.openexchange.caching.dynamic.Refresher;
import com.openexchange.exception.OXException;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.Assert;
import junit.framework.TestCase;

public class RefresherTest
extends TestCase {
    private static final String KEY = "RefresherTest";
    private Consumer consumer1;
    private Consumer consumer2;
    private Remover remover;
    private Thread thread1;
    private Thread thread2;
    private Thread thread3;
    static final OXObjectFactory<Integer> factory = new OXObjectFactory<Integer>(){
        private final Lock lock = new ReentrantLock();

        public Lock getCacheLock() {
            return this.lock;
        }

        public Serializable getKey() {
            return RefresherTest.KEY;
        }

        public Integer load() throws OXException {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new OXException((Throwable)e);
            }
            return 1;
        }
    };

    public RefresherTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ServerServiceRegistry.getInstance().clearRegistry();
        ServerServiceRegistry.getInstance().addService(CacheService.class, (Object)new CacheService(){
            private final Cache cache = new Cache(){
                private Serializable value;

                public void clear() {
                    throw new UnsupportedOperationException();
                }

                public void dispose() {
                    throw new UnsupportedOperationException();
                }

                public Object get(Serializable key) {
                    Serializable retval = null;
                    if (RefresherTest.KEY.equals(key)) {
                        retval = this.value;
                    }
                    return retval;
                }

                public CacheElement getCacheElement(Serializable key) {
                    throw new UnsupportedOperationException();
                }

                public ElementAttributes getDefaultElementAttributes() {
                    throw new UnsupportedOperationException();
                }

                public Object getFromGroup(Serializable key, String group) {
                    throw new UnsupportedOperationException();
                }

                public CacheStatistics getStatistics() {
                    throw new UnsupportedOperationException();
                }

                public void invalidateGroup(String group) {
                    throw new UnsupportedOperationException();
                }

                public CacheKey newCacheKey(int contextId, int objectId) {
                    throw new UnsupportedOperationException();
                }

                public CacheKey newCacheKey(int contextId, Serializable ... obj) {
                    throw new UnsupportedOperationException();
                }

                public Collection<Serializable> values() {
                    throw new UnsupportedOperationException();
                }

                public void put(Serializable key, Serializable obj) throws OXException {
                    if (!RefresherTest.KEY.equals(key)) {
                        throw CacheExceptionCode.CACHE_ERROR.create(new Object[]{key});
                    }
                    if (!(obj instanceof Condition) && !(obj instanceof Integer)) {
                        Assert.fail((String)("Wrong value: " + obj.getClass().getName()));
                    }
                    this.value = obj;
                }

                public void put(Serializable key, Serializable val, ElementAttributes attr) {
                    throw new UnsupportedOperationException();
                }

                public void putInGroup(Serializable key, String groupName, Object value, ElementAttributes attr) {
                    throw new UnsupportedOperationException();
                }

                public void putInGroup(Serializable key, String groupName, Serializable value) {
                    throw new UnsupportedOperationException();
                }

                public void putSafe(Serializable key, Serializable obj) throws OXException {
                    if (!RefresherTest.KEY.equals(key)) {
                        throw CacheExceptionCode.CACHE_ERROR.create(new Object[]{key});
                    }
                    if (null != this.value) {
                        throw CacheExceptionCode.FAILED_SAFE_PUT.create();
                    }
                    if (!(obj instanceof Condition) && !(obj instanceof Integer)) {
                        Assert.fail((String)("Wrong value: " + obj.getClass().getName()));
                    }
                    this.value = obj;
                }

                public void remove(Serializable key) throws OXException {
                    if (!RefresherTest.KEY.equals(key)) {
                        throw CacheExceptionCode.CACHE_ERROR.create(new Object[]{key});
                    }
                    if (!(this.value instanceof Condition)) {
                        this.value = null;
                    }
                }

                public void removeFromGroup(Serializable key, String group) {
                    throw new UnsupportedOperationException();
                }

                public void setDefaultElementAttributes(ElementAttributes attr) {
                    throw new UnsupportedOperationException();
                }

                public void localRemove(Serializable key) {
                    throw new UnsupportedOperationException();
                }

                public void localRemoveFromGroup(Serializable key, String group) {
                    throw new UnsupportedOperationException();
                }

                public void localPut(Serializable key, Serializable value2) {
                    throw new UnsupportedOperationException();
                }

                public boolean isDistributed() {
                    throw new UnsupportedOperationException();
                }

                public boolean isReplicated() {
                    throw new UnsupportedOperationException();
                }

                public boolean isLocal() {
                    return false;
                }

                public Set<?> getGroupKeys(String group) {
                    throw new UnsupportedOperationException();
                }

                public Set<String> getGroupNames() {
                    throw new UnsupportedOperationException();
                }

                public Set<?> getAllKeys() throws OXException {
                    throw new UnsupportedOperationException();
                }

                public Set<?> getKeysInRange(int start, int end) throws OXException {
                    throw new UnsupportedOperationException();
                }

                public void put(Serializable key, Serializable obj, boolean invalidate) throws OXException {
                    this.put(key, obj);
                }

                public void put(Serializable key, Serializable val, ElementAttributes attr, boolean invalidate) throws OXException {
                    this.put(key, val, attr);
                }

                public void putInGroup(Serializable key, String groupName, Object value, ElementAttributes attr, boolean invalidate) throws OXException {
                    this.putInGroup(key, groupName, value, attr);
                }

                public void putInGroup(Serializable key, String groupName, Serializable value, boolean invalidate) throws OXException {
                    this.putInGroup(key, groupName, value);
                }
            };

            public void freeCache(String name) {
                throw new UnsupportedOperationException();
            }

            public Cache getCache(String name) {
                Cache retval = null;
                if (RefresherTest.KEY.equals(name)) {
                    retval = this.cache;
                }
                return retval;
            }

            public void loadConfiguration(String cacheConfigFile) {
                throw new UnsupportedOperationException();
            }

            public void loadConfiguration(InputStream inputStream) throws OXException {
                throw new UnsupportedOperationException();
            }

            public void loadConfiguration(Properties properties) throws OXException {
                throw new UnsupportedOperationException();
            }

            public void loadDefaultConfiguration() {
                throw new UnsupportedOperationException();
            }

            public CacheKey newCacheKey(int contextId, int objectId) {
                throw new UnsupportedOperationException();
            }

            public CacheKey newCacheKey(int contextId, Serializable obj) {
                throw new UnsupportedOperationException();
            }

            public CacheKey newCacheKey(int contextId, Serializable ... objs) {
                throw new UnsupportedOperationException();
            }

            public boolean isDistributed() {
                return false;
            }

            public boolean isReplicated() {
                return false;
            }
        });
        Refreshed refreshed = new Refreshed();
        this.consumer1 = new Consumer(refreshed);
        this.consumer2 = new Consumer(refreshed);
        this.remover = new Remover();
        this.thread1 = new Thread(this.consumer1);
        this.thread2 = new Thread(this.consumer2);
        this.thread3 = new Thread(this.remover);
    }

    public void testRefresher() throws InterruptedException {
        this.thread3.start();
        this.thread1.start();
        this.thread2.start();
        Thread.sleep(100000L);
        this.remover.stop();
        this.consumer1.stop();
        this.consumer2.stop();
        this.thread3.join();
        this.thread1.join();
        this.thread2.join();
        if (null != this.remover.getE()) {
            this.remover.getE().printStackTrace();
            RefresherTest.fail((String)this.remover.getE().toString());
        }
        if (null != this.consumer1.getE()) {
            this.consumer1.getE().printStackTrace();
            RefresherTest.fail((String)this.consumer1.getE().toString());
        }
        if (null != this.consumer2.getE()) {
            this.consumer2.getE().printStackTrace();
            RefresherTest.fail((String)this.consumer2.getE().toString());
        }
    }

    private static class Remover
    implements Runnable {
        private final AtomicBoolean run = new AtomicBoolean(true);
        private Exception e;

        public void stop() {
            this.run.set(false);
        }

        @Override
        public void run() {
            try {
                Cache cache = ((CacheService)ServerServiceRegistry.getInstance().getService(CacheService.class)).getCache(RefresherTest.KEY);
                while (this.run.get()) {
                    cache.remove((Serializable)((Object)RefresherTest.KEY));
                    Thread.sleep(15L);
                }
            }
            catch (Exception e) {
                this.e = e;
            }
        }

        public Exception getE() {
            return this.e;
        }
    }

    private static class Consumer
    implements Runnable {
        private final Refreshed refreshed;
        private final AtomicBoolean run = new AtomicBoolean(true);
        private Exception e;

        public Consumer(Refreshed refreshed) {
            this.refreshed = refreshed;
        }

        public void stop() {
            this.run.set(false);
        }

        @Override
        public void run() {
            try {
                while (this.run.get()) {
                    this.refreshed.getValue();
                    Thread.sleep(10L);
                }
            }
            catch (Exception e) {
                this.e = e;
            }
        }

        public Exception getE() {
            return this.e;
        }
    }

    private static class Refreshed
    extends Refresher<Integer> {
        private Integer delegate = (Integer)this.refresh();

        Refreshed() throws OXException {
            super(factory, RefresherTest.KEY, false);
        }

        private int getValue() {
            try {
                Serializable tmp = this.refresh();
                if (!(tmp instanceof Integer)) {
                    throw new ClassCastException("tmp is an " + tmp.getClass().getName());
                }
                this.delegate = (Integer)tmp;
            }
            catch (OXException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return this.delegate;
        }
    }
}

