/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.groupware.tasks.Task;
import java.util.Date;
import java.util.TimeZone;
import org.junit.Test;

public class DeleteMultipleTaskTest
extends AbstractAJAXSession {
    private AJAXClient client;
    private Task task1;
    private Task task2;
    private TimeZone timeZone;

    public DeleteMultipleTaskTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = new AJAXClient(AJAXClient.User.User1);
        this.timeZone = this.client.getValues().getTimeZone();
        this.task1 = new Task();
        this.task1.setTitle("Test 1");
        this.task1.setStartDate(new Date());
        this.task1.setEndDate(new Date(System.currentTimeMillis() + 0x6DDD00L));
        this.task1.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        InsertRequest insReq1 = new InsertRequest(this.task1, this.timeZone);
        InsertResponse insRes1 = this.client.execute(insReq1);
        insRes1.fillTask(this.task1);
        this.task2 = new Task();
        this.task2.setTitle("Test 2");
        this.task2.setStartDate(new Date());
        this.task2.setEndDate(new Date(System.currentTimeMillis() + 0x6DDD00L));
        this.task2.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        InsertRequest insReq2 = new InsertRequest(this.task2, this.timeZone);
        InsertResponse insRes2 = this.client.execute(insReq2);
        insRes2.fillTask(this.task2);
    }

    @Override
    public void tearDown() throws Exception {
        GetRequest getReq2;
        GetResponse getRes2;
        GetRequest getReq1 = new GetRequest(this.task1.getParentFolderID(), this.task1.getObjectID(), false);
        GetResponse getRes1 = this.client.execute(getReq1);
        if (!getRes1.hasError()) {
            DeleteRequest delReq = new DeleteRequest(this.task1, false);
            this.client.execute(delReq);
        }
        if (!(getRes2 = this.client.execute(getReq2 = new GetRequest(this.task2.getParentFolderID(), this.task2.getObjectID(), false))).hasError()) {
            DeleteRequest delReq = new DeleteRequest(this.task2, false);
            this.client.execute(delReq);
        }
        super.tearDown();
    }

    @Test
    public void testDeleteMultiple() throws Exception {
        int[] ids = new int[]{this.task1.getObjectID(), this.task2.getObjectID()};
        DeleteRequest delReq = new DeleteRequest(this.client.getValues().getPrivateTaskFolder(), ids, new Date(System.currentTimeMillis() + 300000L), true);
        CommonDeleteResponse delRes = this.client.execute(delReq);
        DeleteMultipleTaskTest.assertFalse((String)("Multiple delete failed: " + delRes.getErrorMessage()), (boolean)delRes.hasError());
    }
}

