/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.reminder.ReminderTools;
import com.openexchange.ajax.reminder.actions.RangeRequest;
import com.openexchange.ajax.reminder.actions.RangeResponse;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.TaskTools;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.tasks.Task;
import java.util.Date;
import java.util.TimeZone;

public class Bug7377Test
extends AbstractTaskTest {
    private AJAXClient client1;
    private AJAXClient client2;

    public Bug7377Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLostFolderInfo() throws Throwable {
        TimeZone tz1 = this.client1.getValues().getTimeZone();
        Task task = new Task();
        task.setTitle("Test bug #7377");
        int folderId = this.getPrivateFolder();
        task.setParentFolderID(folderId);
        InsertResponse iResponse = this.client1.execute(new InsertRequest(task, tz1));
        task.setObjectID(iResponse.getId());
        try {
            GetResponse gResponse = TaskTools.get(this.client1, new GetRequest(this.getPrivateFolder(), task.getObjectID()));
            task.setLastModified(gResponse.getTimestamp());
            task.setNote("Updated with reminder");
            Date remindDate = new Date();
            task.setAlarm(remindDate);
            UpdateResponse uResponse = TaskTools.update(this.client1, new UpdateRequest(task, tz1));
            task.setLastModified(uResponse.getTimestamp());
            RangeResponse rResponse = ReminderTools.get(this.client1, new RangeRequest(remindDate));
            ReminderObject reminder = rResponse.getReminderByTarget(tz1, task.getObjectID());
            Bug7377Test.assertNotNull((String)"Can't find reminder for task.", (Object)reminder);
            Bug7377Test.assertNotSame((String)"Found folder 0 for task reminder.", (Object)0, (Object)reminder.getFolder());
        }
        catch (Throwable throwable) {
            Date lastModified = task.containsLastModified() ? task.getLastModified() : new Date();
            this.client1.execute(new DeleteRequest(folderId, task.getObjectID(), lastModified));
            throw throwable;
        }
        Date lastModified = task.containsLastModified() ? task.getLastModified() : new Date();
        this.client1.execute(new DeleteRequest(folderId, task.getObjectID(), lastModified));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPublicFolderMove() throws Throwable {
        TimeZone tz1 = this.client1.getValues().getTimeZone();
        TimeZone tz2 = this.client2.getValues().getTimeZone();
        int folder1 = this.client1.getValues().getPrivateTaskFolder();
        Task task = new Task();
        task.setParentFolderID(folder1);
        task.setTitle("Test bug #7377");
        Date remindDate = new Date();
        task.setAlarm(remindDate);
        Participant[] parts = new Participant[]{new UserParticipant(this.client1.getValues().getUserId()), new UserParticipant(this.client2.getValues().getUserId())};
        task.setParticipants(parts);
        FolderObject folder = null;
        try {
            InsertResponse response = this.client1.execute(new InsertRequest(task, tz1));
            response.fillTask(task);
            int folder2 = this.client2.getValues().getPrivateTaskFolder();
            AbstractAJAXResponse response2 = TaskTools.get(this.client2, new GetRequest(folder2, task.getObjectID()));
            Task task2 = ((GetResponse)response2).getTask(tz2);
            task2.setNote("Updated with reminder");
            task2.setAlarm(remindDate);
            response2 = TaskTools.update(this.client2, new UpdateRequest(task2, tz2));
            task.setLastModified(response2.getTimestamp());
            FolderObject tmp = Create.setupPublicFolder("Bug7377TaskFolder1", 1, this.client1.getValues().getUserId());
            tmp.setParentFolderID(2);
            CommonInsertResponse response3 = this.client1.execute(new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_OLD, tmp));
            tmp.setObjectID(response3.getId());
            tmp.setLastModified(response3.getTimestamp());
            folder = tmp;
            task.setNote("Moved to public");
            task.removeAlarm();
            task.setParentFolderID(folder.getObjectID());
            response2 = TaskTools.update(this.client1, new UpdateRequest(folder1, task, tz1));
            task.setLastModified(response2.getTimestamp());
            TaskTools.get(this.client2, new GetRequest(folder.getObjectID(), task.getObjectID()));
            response2 = ReminderTools.get(this.client1, new RangeRequest(remindDate));
            ReminderObject reminder = ((RangeResponse)response2).getReminderByTarget(tz1, task.getObjectID());
            Bug7377Test.assertNotNull((String)"Can't find reminder for task.", (Object)reminder);
            Bug7377Test.assertNotSame((String)"Found folder 0 for task reminder.", (Object)0, (Object)reminder.getFolder());
            response2 = ReminderTools.get(this.client2, new RangeRequest(remindDate));
            reminder = ((RangeResponse)response2).getReminderByTarget(tz2, task.getObjectID());
            Bug7377Test.assertNotNull((String)"Can't find reminder for task.", (Object)reminder);
            Bug7377Test.assertNotSame((String)"Found folder 0 for task reminder.", (Object)0, (Object)reminder.getFolder());
        }
        finally {
            if (null != task.getLastModified()) {
                this.client1.execute(new DeleteRequest(task));
            }
            if (null != folder) {
                this.client1.execute(new com.openexchange.ajax.folder.actions.DeleteRequest((API)EnumAPI.OX_OLD, folder.getObjectID(), folder.getLastModified()));
            }
        }
    }
}

