/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.TaskTools;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;

public class Bug7276Test
extends AbstractTaskTest {
    private AJAXClient client2;
    private OXException.Generic expected;

    public Bug7276Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client2.logout();
        super.tearDown();
    }

    public void testBug() throws Throwable {
        AJAXClient client1 = this.getClient();
        int folder2 = this.client2.getValues().getPrivateTaskFolder();
        Task task = Create.createWithDefaults();
        task.setTitle("Test bug #7276");
        task.setParentFolderID(client1.getValues().getPrivateTaskFolder());
        task.setParticipants(ParticipantTools.createParticipants(client1.getValues().getUserId(), this.client2.getValues().getUserId()));
        AbstractAJAXResponse response = client1.execute(new InsertRequest(task, client1.getValues().getTimeZone()));
        ((InsertResponse)response).fillTask(task);
        TaskTools.get(this.client2, new GetRequest(folder2, task.getObjectID()));
        response = TaskTools.get(client1, new GetRequest(task.getParentFolderID(), task.getObjectID()));
        task = ((GetResponse)response).getTask(client1.getValues().getTimeZone());
        task.setParticipants(ParticipantTools.createParticipants(client1.getValues().getUserId()));
        response = TaskTools.update(client1, new UpdateRequest(task, client1.getValues().getTimeZone()));
        task.setLastModified(response.getTimestamp());
        response = TaskTools.get(this.client2, new GetRequest(folder2, task.getObjectID(), false));
        Bug7276Test.assertTrue((String)"Server does not give exception although it has to.", (boolean)response.hasError());
        OXException expectedErr = OXExceptionFactory.getInstance().create((OXExceptionCode)TaskExceptionCode.NO_PERMISSION);
        OXException actual = response.getException();
        Bug7276Test.assertTrue((String)"Wrong exception", (boolean)actual.similarTo(expectedErr));
        client1.execute(new DeleteRequest(task));
    }
}

