/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.resource;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.resource.AbstractResourceTest;
import com.openexchange.ajax.resource.actions.ResourceDeleteRequest;
import com.openexchange.ajax.resource.actions.ResourceNewRequest;
import com.openexchange.ajax.resource.actions.ResourceNewResponse;
import com.openexchange.ajax.resource.actions.ResourceUpdatesRequest;
import com.openexchange.ajax.resource.actions.ResourceUpdatesResponse;
import com.openexchange.group.Group;
import com.openexchange.resource.Resource;
import java.util.Date;
import java.util.List;

public class ResourceUpdatesAJAXTest
extends AbstractResourceTest {
    private Resource resource;

    public ResourceUpdatesAJAXTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.resource = new Resource();
        this.resource.setAvailable(true);
        this.resource.setMail("my.resource@domain.tdl");
        this.resource.setSimpleName("SimpleName");
        this.resource.setDisplayName("DisplayName");
        this.resource.setDescription("Description");
        ResourceNewResponse newResponse = Executor.execute(this.getSession(), new ResourceNewRequest(this.resource, true));
        this.resource.setIdentifier(newResponse.getID());
        this.resource.setLastModified(newResponse.getTimestamp());
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.resource != null) {
            Executor.execute(this.getSession(), new ResourceDeleteRequest(this.resource));
        }
        super.tearDown();
    }

    public void testUpdatesSinceBeginning() throws Exception {
        ResourceUpdatesResponse response = Executor.execute(this.getSession(), new ResourceUpdatesRequest(new Date(0L), true));
        ResourceUpdatesAJAXTest.assertTrue((String)"Should find more than 0 new elements", (response.getNew().size() > 0 ? 1 : 0) != 0);
        ResourceUpdatesAJAXTest.assertTrue((String)"Should find more than 0 updated elements", (response.getModified().size() > 0 ? 1 : 0) != 0);
    }

    public void testUpdates() throws Exception {
        Date since = new Date(this.resource.getLastModified().getTime() - 1L);
        ResourceUpdatesResponse response = Executor.execute(this.getSession(), new ResourceUpdatesRequest(since, true));
        List<Group> modified = response.getModified();
        ResourceUpdatesAJAXTest.assertEquals((String)"Should find one updated element", (int)1, (int)modified.size());
        ResourceUpdatesAJAXTest.assertEquals((String)"Should have matching ID", (int)this.resource.getIdentifier(), (int)modified.get(0).getIdentifier());
    }

    public void testUpdatesShouldContainDeletes() throws Exception {
        Date since = new Date(this.resource.getLastModified().getTime() - 1L);
        ResourceUpdatesResponse response = Executor.execute(this.getSession(), new ResourceUpdatesRequest(since, true));
        int deletedBefore = response.getDeleted().size();
        Executor.execute(this.getSession(), new ResourceDeleteRequest(this.resource));
        response = Executor.execute(this.getSession(), new ResourceUpdatesRequest(since, true));
        int deletedAfter = response.getDeleted().size();
        this.resource = null;
        ResourceUpdatesAJAXTest.assertEquals((String)"Should have one more element in deleted list after deletion", (int)(deletedAfter - 1), (int)deletedBefore);
    }
}

