/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.reminder.ReminderTools;
import com.openexchange.ajax.reminder.actions.DeleteRequest;
import com.openexchange.ajax.reminder.actions.RangeRequest;
import com.openexchange.ajax.reminder.actions.RangeResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.reminder.ReminderObject;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class Bug15776Test
extends AbstractAJAXSession {
    AJAXClient client;
    Appointment appointment;
    Appointment pastAppointment;
    TimeZone timezone;
    Calendar calendar;

    public Bug15776Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = super.getClient();
        this.timezone = this.client.getValues().getTimeZone();
        this.calendar = Calendar.getInstance(this.timezone);
        this.appointment = this.createAppointment();
        this.pastAppointment = this.createSeriesInThePast();
    }

    public void testReminder() throws Exception {
        Appointment toUpdate = this.appointment.clone();
        toUpdate.setAlarm(15);
        UpdateRequest updateReq = new UpdateRequest(toUpdate, this.timezone, true);
        UpdateResponse updateResp = this.client.execute(updateReq);
        updateResp.fillObject((DataObject)this.appointment);
        Calendar cal = (Calendar)this.calendar.clone();
        int diff = 24 - cal.get(11);
        cal.add(11, diff);
        RangeRequest rangeReq = new RangeRequest(cal.getTime());
        RangeResponse rangeResp = this.client.execute(rangeReq);
        ReminderObject reminder = ReminderTools.searchByTarget(rangeResp.getReminder(this.timezone), this.appointment.getObjectID());
        Bug15776Test.assertNotNull((String)"No reminder was found.", (Object)reminder);
        Calendar checkCal = (Calendar)this.calendar.clone();
        checkCal.setTime(reminder.getDate());
        Bug15776Test.assertEquals((String)"Reminder is set to the wrong appointment.", (int)cal.get(1), (int)this.calendar.get(1));
        cal.add(1, 1);
        DeleteRequest delReminderReq = new DeleteRequest(reminder, false);
        this.client.execute(delReminderReq);
        rangeReq = new RangeRequest(cal.getTime());
        rangeResp = this.client.execute(rangeReq);
        reminder = ReminderTools.searchByTarget(rangeResp.getReminder(this.timezone), this.appointment.getObjectID());
        Bug15776Test.assertNotNull((String)"No reminder was found.", (Object)reminder);
    }

    public void testAlarmForReminderInThePast() throws Exception {
        this.pastAppointment.setAlarm(15);
        UpdateRequest updateReq = new UpdateRequest(this.pastAppointment, this.timezone, false);
        UpdateResponse updateResp = this.client.execute(updateReq);
        updateResp.fillObject((DataObject)this.pastAppointment);
        GetRequest getApp = new GetRequest(this.pastAppointment);
        GetResponse getAppResp = this.client.execute(getApp);
        Appointment app = getAppResp.getAppointment(this.timezone);
        Bug15776Test.assertFalse((String)"Series in the past contains alarm.", (boolean)app.containsAlarm());
    }

    @Override
    public void tearDown() throws Exception {
        Appointment toDelete = this.client.execute(new GetRequest(this.appointment, false)).getAppointment(this.timezone);
        this.client.execute(new com.openexchange.ajax.appointment.action.DeleteRequest(toDelete, false));
        toDelete = this.client.execute(new GetRequest(this.pastAppointment, false)).getAppointment(this.timezone);
        this.client.execute(new com.openexchange.ajax.appointment.action.DeleteRequest(toDelete, false));
        super.tearDown();
    }

    private Appointment createSeriesInThePast() throws Exception {
        Calendar cal = TimeTools.createCalendar(this.timezone);
        Appointment appointment = new Appointment();
        appointment.setTitle("testBug15776SeriesInThePast");
        cal.add(1, -5);
        cal.add(12, 10);
        appointment.setStartDate(cal.getTime());
        cal.add(10, 1);
        appointment.setEndDate(cal.getTime());
        appointment.setShownAs(3);
        appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        appointment.setIgnoreConflicts(true);
        appointment.setNote("");
        appointment.setNotification(true);
        appointment.setPrivateFlag(false);
        appointment.setFullTime(false);
        appointment.setRecurrenceType(4);
        appointment.setMonth(cal.get(2));
        appointment.setDayInMonth(cal.get(5));
        appointment.setInterval(1);
        appointment.setOccurrence(4);
        UserParticipant newParticipant = new UserParticipant(this.client.getValues().getUserId());
        appointment.addParticipant((Participant)newParticipant);
        InsertRequest insReq = new InsertRequest(appointment, this.timezone, true);
        AppointmentInsertResponse insResp = this.client.execute(insReq);
        insResp.fillAppointment(appointment);
        return appointment;
    }

    private Appointment createAppointment() throws OXException, IOException, SAXException, JSONException {
        Calendar cal = TimeTools.createCalendar(this.timezone);
        cal.add(1, -5);
        cal.add(11, 2);
        Appointment appointment = new Appointment();
        appointment.setTitle("testBug15776");
        appointment.setStartDate(cal.getTime());
        cal.add(10, 1);
        appointment.setEndDate(cal.getTime());
        appointment.setShownAs(3);
        appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        appointment.setIgnoreConflicts(true);
        appointment.setNote("");
        appointment.setNotification(true);
        appointment.setPrivateFlag(false);
        appointment.setFullTime(false);
        appointment.setRecurrenceType(4);
        appointment.setMonth(cal.get(2));
        appointment.setDayInMonth(cal.get(5));
        appointment.setInterval(1);
        appointment.setOccurrence(25);
        UserParticipant newParticipant = new UserParticipant(this.client.getValues().getUserId());
        appointment.addParticipant((Participant)newParticipant);
        InsertRequest insReq = new InsertRequest(appointment, this.timezone, true);
        AppointmentInsertResponse insResp = this.client.execute(insReq);
        insResp.fillAppointment(appointment);
        return appointment;
    }
}

