/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.mail.TestMails;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.ajax.mail.actions.ListRequest;
import com.openexchange.java.Charsets;
import com.openexchange.mail.MailListField;

public class Bug16087Test
extends AbstractAJAXSession {
    private static final int[] ATTRIBUTES = new int[]{MailListField.ID.getField(), MailListField.FLAGS.getField()};
    private AJAXClient client;
    private String folder;
    private String address;
    private String[] ids;

    public Bug16087Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.folder = this.client.getValues().getInboxFolder();
        this.address = this.client.getValues().getSendAddress();
        String mail = TestMails.replaceAddresses("From: #ADDR#\nTo: #ADDR#\nSubject: Test for bug 15608\nMime-Version: 1.0\nContent-Type: text/plain; charset=\"UTF-8\"\nContent-Transfer-Encoding: 8bit\n\nTest for bug 15608\n\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df\n", this.address);
        ImportMailRequest request = new ImportMailRequest(this.folder, 0, Charsets.UTF_8, mail);
        ImportMailResponse response = this.client.execute(request);
        this.ids = response.getIds()[0];
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.ids, true));
        super.tearDown();
    }

    public void testGetRawWithUnseen() throws Throwable {
        AJAXRequest<GetResponse> request = new GetRequest(this.folder, this.ids[1]);
        request.setUnseen(true);
        request.setSource(true);
        request.setSave(true);
        this.client.execute(request);
        request = new ListRequest((String[][])new String[][]{this.ids}, ATTRIBUTES);
        CommonListResponse response = (CommonListResponse)((Object)this.client.execute(request));
        int flagsPos = response.getColumnPos(MailListField.FLAGS.getField());
        for (Object[] mail : response) {
            int testFlags = (Integer)mail[flagsPos];
            Bug16087Test.assertEquals((String)"Wanted flags are not set.", (int)0, (int)testFlags);
        }
    }
}

