/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.infostore.actions.AbstractInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreParser;
import com.openexchange.ajax.infostore.actions.NewInfostoreResponse;
import com.openexchange.groupware.infostore.DocumentMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NewInfostoreRequest
extends AbstractInfostoreRequest<NewInfostoreResponse> {
    private DocumentMetadata metadata;
    private final File upload;

    public NewInfostoreRequest() {
        this(null, null);
    }

    public NewInfostoreRequest(DocumentMetadata data) {
        this(data, null);
    }

    public NewInfostoreRequest(DocumentMetadata data, File upload) {
        this.metadata = data;
        this.upload = upload;
    }

    public void setMetadata(DocumentMetadata metadata) {
        this.metadata = metadata;
    }

    public DocumentMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String getBody() throws JSONException {
        JSONObject originalObject = new JSONObject(this.writeJSON(this.getMetadata()));
        JSONObject retVal = new JSONObject();
        Set set = originalObject.keySet();
        for (String string : set) {
            Object test = originalObject.get(string);
            if (test == JSONObject.NULL) continue;
            if (test instanceof JSONArray) {
                if (((JSONArray)test).length() <= 0) continue;
                retVal.put(string, test);
                continue;
            }
            retVal.put(string, test);
        }
        return retVal.toString();
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return null == this.upload ? AJAXRequest.Method.PUT : AJAXRequest.Method.UPLOAD;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        ArrayList<AJAXRequest.Parameter> tmp = new ArrayList<AJAXRequest.Parameter>(3);
        tmp.add(new AJAXRequest.Parameter("action", "new"));
        if (null != this.upload) {
            tmp.add(new AJAXRequest.FieldParameter("json", this.getBody()));
            tmp.add(new AJAXRequest.FileParameter("file", this.upload.getName(), new FileInputStream(this.upload), this.metadata.getFileMIMEType()));
        }
        return tmp.toArray(new AJAXRequest.Parameter[tmp.size()]);
    }

    public NewInfostoreParser getParser() {
        return new NewInfostoreParser(this.getFailOnError(), null != this.upload);
    }
}

