/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.importexport.AbstractICalTest;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.java.Charsets;
import com.openexchange.webdav.xml.AppointmentTest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class ICalImportTest
extends AbstractICalTest {
    public ICalImportTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWarnings() throws JSONException, OXException, IOException, SAXException {
        StringBuilder icalText = new StringBuilder(1500);
        icalText.append("BEGIN:VCALENDAR\n");
        icalText.append("VERSION:2.0").append('\n');
        icalText.append("PRODID:OPEN-XCHANGE").append('\n');
        icalText.append("BEGIN:VEVENT").append('\n');
        icalText.append("CLASS:SUPERCALIFRAGILISTICEXPLIALIDOCIOUS").append('\n');
        icalText.append("DTSTART:20070101T080000Z").append('\n');
        icalText.append("DTEND:20070101T100000Z").append('\n');
        icalText.append("SUMMARY: appointmentWithWarnings ICalImportTest#testWarnings " + System.currentTimeMillis()).append('\n');
        icalText.append("TRANSP:OPAQUE").append('\n');
        icalText.append("END:VEVENT").append('\n');
        icalText.append("END:VCALENDAR");
        AJAXSession aSession = new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId());
        AJAXClient client = new AJAXClient(aSession);
        ICalImportRequest request = new ICalImportRequest(this.appointmentFolderId, new ByteArrayInputStream(icalText.toString().getBytes(Charsets.UTF_8)), false);
        ICalImportResponse iResponse = client.execute(request);
        ImportResult[] importResult = iResponse.getImports();
        ImportResult resultWithWarnings = null;
        try {
            ICalImportTest.assertEquals((int)1, (int)importResult.length);
            resultWithWarnings = importResult[0];
            ICalImportTest.assertNotNull((Object)((Object)resultWithWarnings.getException()));
            List warnings = resultWithWarnings.getWarnings();
            ICalImportTest.assertNotNull((Object)warnings);
            ICalImportTest.assertEquals((int)1, (int)warnings.size());
        }
        finally {
            DeleteRequest delete = new DeleteRequest((int)Integer.valueOf(resultWithWarnings.getObjectId()), this.appointmentFolderId, new Date(Long.MAX_VALUE), true);
            client.execute(delete);
        }
    }

    public void _notestImportICalWithBrokenAppointment() throws Exception {
        String title1 = "testImportICalWithBrokenAppointment1_" + System.currentTimeMillis();
        String title2 = "testImportICalWithBrokenAppointment2_" + System.currentTimeMillis();
        String title3 = "testImportICalWithBrokenAppointment3_" + System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BEGIN:VCALENDAR").append('\n');
        stringBuffer.append("VERSION:2.0").append('\n');
        stringBuffer.append("PRODID:OPEN-XCHANGE").append('\n');
        stringBuffer.append("BEGIN:VEVENT").append('\n');
        stringBuffer.append("CLASS:PUBLIC").append('\n');
        stringBuffer.append("DTSTART:20070101T080000Z").append('\n');
        stringBuffer.append("DTEND:20070101T100000Z").append('\n');
        stringBuffer.append("SUMMARY:" + title1).append('\n');
        stringBuffer.append("TRANSP:OPAQUE").append('\n');
        stringBuffer.append("END:VEVENT").append('\n');
        stringBuffer.append("BEGIN:VEVENT").append('\n');
        stringBuffer.append("CLASS:PUBLIC").append('\n');
        stringBuffer.append("DTSTART:INVALID_DATE").append('\n');
        stringBuffer.append("DTEND:20070101T100000Z").append('\n');
        stringBuffer.append("SUMMARY:" + title2).append('\n');
        stringBuffer.append("TRANSP:OPAQUE").append('\n');
        stringBuffer.append("END:VEVENT").append('\n');
        stringBuffer.append("BEGIN:VEVENT").append('\n');
        stringBuffer.append("CLASS:PUBLIC").append('\n');
        stringBuffer.append("DTSTART:20070101T080000Z").append('\n');
        stringBuffer.append("DTEND:20070101T100000Z").append('\n');
        stringBuffer.append("SUMMARY:" + title3).append('\n');
        stringBuffer.append("TRANSP:OPAQUE").append('\n');
        stringBuffer.append("END:VEVENT").append('\n');
        stringBuffer.append("END:VCALENDAR").append('\n');
        ImportResult[] importResult = ICalImportTest.importICal(this.getWebConversation(), new ByteArrayInputStream(stringBuffer.toString().getBytes()), this.appointmentFolderId, this.getHostName(), this.getSessionId());
        ICalImportTest.assertEquals((String)"invalid import result array size", (int)3, (int)importResult.length);
        ICalImportTest.assertTrue((String)"server errors of server", (boolean)importResult[0].isCorrect());
        ICalImportTest.assertTrue((String)"server errors of server", (boolean)importResult[1].hasError());
        ICalImportTest.assertTrue((String)"server errors of server", (boolean)importResult[2].isCorrect());
        this.exportAppointment(this.getWebConversation(), this.appointmentFolderId, this.timeZone, this.getHostName(), this.getSessionId(), null);
        AppointmentTest.deleteAppointment(this.getWebConversation(), Integer.parseInt(importResult[0].getObjectId()), this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), "");
        AppointmentTest.deleteAppointment(this.getWebConversation(), Integer.parseInt(importResult[2].getObjectId()), this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), "");
    }
}

