/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.importexport.actions.CSVExportRequest;
import com.openexchange.ajax.importexport.actions.CSVExportResponse;
import com.openexchange.ajax.importexport.actions.CSVImportRequest;
import com.openexchange.ajax.importexport.actions.CSVImportResponse;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.importexport.csv.CSVParser;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CSVImportExportServletTest
extends AbstractManagedContactTest {
    String CSV = "Given name,Email 1, Display name\n Prinz, tobias.prinz@open-xchange.com, Tobias Prinz\nLaguna, francisco.laguna@open-xchange.com, Francisco Laguna\n";
    private ContactField field;

    public CSVImportExportServletTest(String name) {
        super(name);
    }

    public Map<ContactField, Integer> getPositions(List<List<String>> csv) {
        HashMap<ContactField, Integer> result = new HashMap<ContactField, Integer>();
        List<String> headers = csv.get(0);
        for (int i = 0; i < headers.size(); ++i) {
            this.field = ContactField.getByDisplayName((String)headers.get(i));
            if (this.field == null) continue;
            result.put(this.field, i);
        }
        return result;
    }

    public void notestCSVRoundtrip() throws Exception {
        this.client.execute(new CSVImportRequest(this.folderID, new ByteArrayInputStream(this.CSV.getBytes())));
        CSVExportResponse exportResponse = this.client.execute(new CSVExportRequest(this.folderID));
        CSVParser parser = new CSVParser();
        List expected = parser.parse(this.CSV);
        List actual = parser.parse((String)exportResponse.getData());
        Map<ContactField, Integer> positions = this.getPositions(actual);
        for (int i = 1; i <= 2; ++i) {
            CSVImportExportServletTest.assertEquals((String)("Mismatch of given name in row #" + i), (String)((String)((List)expected.get(i)).get(0)), (String)((String)((List)actual.get(i)).get(positions.get(ContactField.GIVEN_NAME))));
            CSVImportExportServletTest.assertEquals((String)("Mismatch of email 1 in row #" + i), (String)((String)((List)expected.get(i)).get(1)), (String)((String)((List)actual.get(i)).get(positions.get(ContactField.EMAIL1))));
            CSVImportExportServletTest.assertEquals((String)("Mismatch of display name in row #" + i), (String)((String)((List)expected.get(i)).get(2)), (String)((String)((List)actual.get(i)).get(positions.get(ContactField.DISPLAY_NAME))));
        }
    }

    public void testUnknownFile() throws Exception {
        String insertedCSV = "bla1\nbla2,bla3";
        CSVImportResponse importResponse = this.client.execute(new CSVImportRequest(this.folderID, new ByteArrayInputStream("bla1\nbla2,bla3".getBytes()), false));
        CSVImportExportServletTest.assertEquals((String)("Unexpected error code: " + (Object)((Object)importResponse.getException())), (String)"I_E-0804", (String)importResponse.getException().getErrorCode());
    }

    public void testEmptyFileUploaded() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream("Given name,Email 1, Display name".getBytes());
        CSVImportResponse importResponse = this.client.execute(new CSVImportRequest(this.folderID, is, false));
        CSVImportExportServletTest.assertEquals((String)("Unexpected error code: " + (Object)((Object)importResponse.getException())), (String)"I_E-1314", (String)importResponse.getException().getErrorCode());
    }

    public void notestDoubleImport() throws Exception {
        this.client.execute(new CSVImportRequest(this.folderID, new ByteArrayInputStream(this.CSV.getBytes())));
        this.client.execute(new CSVImportRequest(this.folderID, new ByteArrayInputStream(this.CSV.getBytes())));
        CSVExportResponse exportResponse = this.client.execute(new CSVExportRequest(this.folderID));
        CSVParser parser = new CSVParser();
        List expected = parser.parse(this.CSV);
        CSVImportExportServletTest.assertEquals((int)3, (int)expected.size());
    }
}

