/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public final class Create {
    private Create() {
    }

    public static FolderObject setupPublicFolder(String name, int type, int admin) {
        FolderObject folder = new FolderObject();
        folder.setFolderName(name);
        folder.setModule(type);
        folder.setType(2);
        OCLPermission perm1 = new OCLPermission();
        perm1.setEntity(admin);
        perm1.setGroupPermission(false);
        perm1.setFolderAdmin(true);
        perm1.setAllPermission(128, 128, 128, 128);
        OCLPermission perm2 = new OCLPermission();
        perm2.setEntity(0);
        perm2.setGroupPermission(true);
        perm2.setFolderAdmin(false);
        perm2.setAllPermission(4, 4, 4, 4);
        folder.setPermissionsAsArray(new OCLPermission[]{perm1, perm2});
        return folder;
    }

    public static FolderObject createPublicFolder(AJAXClient client, String name, int module) throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = Create.setupPublicFolder(name, module, client.getValues().getUserId());
        folder.setParentFolderID(2);
        InsertRequest request = new InsertRequest(EnumAPI.OX_OLD, folder);
        InsertResponse response = client.execute(request);
        response.fillObject((DataObject)folder);
        return folder;
    }

    public static FolderObject createPrivateFolder(String name, int type, int admin) {
        FolderObject folder = new FolderObject();
        folder.setFolderName(name);
        folder.setModule(type);
        folder.setType(1);
        OCLPermission perm = Create.ocl(admin, false, true, 128, 128, 128, 128);
        folder.setPermissionsAsArray(new OCLPermission[]{perm});
        return folder;
    }

    public static OCLPermission ocl(int entity, boolean isGroup, boolean isAdmin, int fp, int opr, int opw, int opd) {
        OCLPermission retval = new OCLPermission();
        retval.setEntity(entity);
        retval.setGroupPermission(isGroup);
        retval.setFolderAdmin(isAdmin);
        retval.setAllPermission(fp, opr, opw, opd);
        return retval;
    }

    public static FolderObject folder(int parent, String name, int module, int type, OCLPermission ... permissions) {
        FolderObject retval = new FolderObject();
        retval.setParentFolderID(parent);
        retval.setFolderName(name);
        retval.setModule(module);
        retval.setType(type);
        retval.setPermissionsAsArray(permissions);
        return retval;
    }
}

