/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.conversion;

import com.openexchange.ajax.conversion.AbstractConversionTest;
import com.openexchange.ajax.conversion.actions.ConvertRequest;
import com.openexchange.ajax.conversion.actions.ConvertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.contenttypes.MailContentType;
import com.openexchange.ajax.mail.netsol.FolderAndID;
import com.openexchange.ajax.mail.netsol.actions.NetsolGetRequest;
import com.openexchange.ajax.mail.netsol.actions.NetsolGetResponse;
import com.openexchange.ajax.mail.netsol.actions.NetsolSendRequest;
import com.openexchange.ajax.mail.netsol.actions.NetsolSendResponse;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.InputStream;
import java.util.TimeZone;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug20758Test
extends AbstractConversionTest {
    private String uuid;
    private String[] mailFolderAndMailID1;
    private String[] mailFolderAndMailID2;
    private AJAXClient client1;
    private AJAXClient client2;
    private Object sequenceId1;
    private Object sequenceId2;
    private String ical1;
    private String ical2;

    public Bug20758Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User1);
        this.client1.getValues().setTimeZone(TimeZone.getTimeZone("Europe/Berlin"));
        this.uuid = UUID.randomUUID().toString();
        this.ical1 = "BEGIN:VCALENDAR\n" + "VERSION:2.0\n" + "METHOD:REQUEST\n" + "BEGIN:VEVENT\n" + "ORGANIZER:" + this.client1.getValues().getSendAddress() + '\n' + "ATTENDEE;PARTSTAT=ACCEPTED;CN=Da Organiza:Mailto:" + this.client1.getValues().getSendAddress() + '\n' + "ATTENDEE;RSVP=TRUE;TYPE=INDIVIDUAL;CN=First User:Mailto:" + this.client1.getValues().getSendAddress() + '\n' + "ATTENDEE;RSVP=TRUE;TYPE=INDIVIDUAL;CN=Second User:Mailto:" + this.client2.getValues().getSendAddress() + '\n' + "DTSTART:20111115T133000Z\n" + "DTEND:20111115T143000Z\n" + "SUMMARY:Weihnachtsferien\n" + "UID:ls0h48paommdkntd8ekdfquqbs@google.com\n" + "SEQUENCE:0\n" + "DTSTAMP:20111115T110530Z\n" + "END:VEVENT\n" + "END:VCALENDAR";
        this.ical2 = "BEGIN:VCALENDAR\nPRODID:Open-Xchange\nVERSION:2.0\nCALSCALE:GREGORIAN\nMETHOD:REQUEST\nBEGIN:VEVENT\nDTSTAMP:20111201T082524Z\nSUMMARY:Test 20829\nDTSTART;TZID=Europe/Berlin:20111202T123000\nDTEND;TZID=Europe/Berlin:20111202T133000\nCLASS:PUBLIC\nLOCATION:12:30\nTRANSP:OPAQUE\nUID:6f7d7ef0-8def-4997-8427-2612b7095865\nCREATED:20111201T082524Z\nLAST-MODIFIED:20111201T082524Z\nORGANIZER:" + this.client1.getValues().getSendAddress() + "\n" + "ATTENDEE;ROLE=REQ-PARTICIPANT;CUTYPE=INDIVIDUAL:mailto:" + this.client1.getValues().getSendAddress() + "\n" + "ATTENDEE;CUTYPE=INDIVIDUAL;PARTSTAT=NEEDS-ACTION;ROLE=REQ-PARTICIPANT;RSVP=TRUE:mailto:" + this.client2.getValues().getSendAddress() + "\n" + "END:VEVENT\n" + "BEGIN:VTIMEZONE\n" + "TZID:Europe/Berlin\n" + "TZURL:http://tzurl.org/zoneinfo-outlook/Europe/Berlin\n" + "X-LIC-LOCATION:Europe/Berlin\n" + "BEGIN:DAYLIGHT\n" + "TZOFFSETFROM:+0100\n" + "TZOFFSETTO:+0200\n" + "TZNAME:CEST\n" + "DTSTART:19700329T020000\n" + "RRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\n" + "END:DAYLIGHT\n" + "BEGIN:STANDARD\n" + "TZOFFSETFROM:+0200\n" + "TZOFFSETTO:+0100\n" + "TZNAME:CET\n" + "DTSTART:19701025T030000\n" + "RRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\n" + "END:STANDARD\n" + "END:VTIMEZONE\n" + "END:VCALENDAR";
        this.mailFolderAndMailID1 = this.createMail(this.ical1);
        this.sequenceId1 = this.getSequenceIdForMail(this.client1, this.mailFolderAndMailID1);
        this.mailFolderAndMailID2 = this.createMail(this.ical2);
        this.sequenceId2 = this.getSequenceIdForMail(this.client1, this.mailFolderAndMailID2);
    }

    public void testWithoutTimeZone() throws Exception {
        JSONObject jsonObject = this.internal(this.mailFolderAndMailID1, this.sequenceId1, new JSONArray());
        Bug20758Test.assertEquals((String)"Wrong timezone", (Object)"Europe/Berlin", (Object)jsonObject.get("timezone"));
        Bug20758Test.assertEquals((String)"Wrong start date", (Object)1321367400000L, (Object)jsonObject.get("start_date"));
        jsonObject = this.internal(this.mailFolderAndMailID2, this.sequenceId2, new JSONArray());
        Bug20758Test.assertEquals((String)"Wrong timezone", (Object)"Europe/Berlin", (Object)jsonObject.get("timezone"));
        Bug20758Test.assertEquals((String)"Wrong start date", (Object)1322829000000L, (Object)jsonObject.get("start_date"));
    }

    public void testWithTimeZone() throws Exception {
        JSONObject jsonObject = this.internal(this.mailFolderAndMailID2, this.sequenceId2, new JSONArray().put((Object)new JSONObject().put("com.openexchange.groupware.calendar.timezone", (Object)"UTC")));
        Bug20758Test.assertEquals((String)"Wrong timezone", (Object)"America/New_York", (Object)jsonObject.get("timezone"));
        Bug20758Test.assertEquals((String)"Wrong start date", (Object)1321345800000L, (Object)jsonObject.get("start_date"));
        jsonObject = this.internal(this.mailFolderAndMailID2, this.sequenceId2, new JSONArray());
        Bug20758Test.assertEquals((String)"Wrong timezone", (Object)"Europe/Berlin", (Object)jsonObject.get("timezone"));
        Bug20758Test.assertEquals((String)"Wrong start date", (Object)1322807400000L, (Object)jsonObject.get("start_date"));
    }

    private JSONObject internal(String[] mail, Object sequenceId, JSONArray args) throws Exception {
        JSONObject jsonBody = new JSONObject();
        JSONObject jsonSource = new JSONObject().put("identifier", (Object)"com.openexchange.mail.ical");
        jsonSource.put("args", (Object)new JSONArray().put((Object)new JSONObject().put("com.openexchange.mail.conversion.fullname", (Object)mail[0])).put((Object)new JSONObject().put("com.openexchange.mail.conversion.mailid", (Object)mail[1])).put((Object)new JSONObject().put("com.openexchange.mail.conversion.sequenceid", sequenceId)));
        jsonBody.put("datasource", (Object)jsonSource);
        JSONObject jsonHandler = new JSONObject().put("identifier", (Object)"com.openexchange.ical.json");
        jsonHandler.put("args", (Object)args);
        jsonBody.put("datahandler", (Object)jsonHandler);
        ConvertResponse convertResponse = (ConvertResponse)((Object)Executor.execute(this.client1.getSession(), new ConvertRequest(jsonBody, true)));
        return ((JSONArray)convertResponse.getData()).getJSONObject(0);
    }

    protected String[] createMail(String ical) throws Exception {
        byte[] ICAL_BYTES = ical.getBytes();
        JSONObject mail = new JSONObject();
        mail.put(MailJSONField.FROM.getKey(), (Object)this.client1.getValues().getSendAddress());
        mail.put(MailJSONField.RECIPIENT_TO.getKey(), (Object)(this.client2.getValues().getSendAddress() + "," + this.client2.getValues().getSendAddress()));
        mail.put(MailJSONField.RECIPIENT_CC.getKey(), (Object)"");
        mail.put(MailJSONField.RECIPIENT_BCC.getKey(), (Object)"");
        mail.put(MailJSONField.SUBJECT.getKey(), (Object)"New Event");
        mail.put(MailJSONField.PRIORITY.getKey(), (Object)"3");
        JSONObject bodyObject = new JSONObject();
        bodyObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)MailContentType.ALTERNATIVE.toString());
        bodyObject.put(MailJSONField.CONTENT.getKey(), (Object)"Mail text.<br /><br />People have been asking for support for the IMAP IDLE command for quite<br />a few years and I think I've finally figured out how to provide such<br />support safely.  The difficulty isn't in executing the command, which<br />is quite straightforward, the difficulty is in deciding how to expose<br />it to applications, and inhandling the multithreading issues that<br />arise.<br /><br />After three attempts, I've got a version that seems to work.  It passes<br />all my tests, including a multithreading test I wrote just for this<br />purpose.  So now it's time for others to try it out as well.  Below is<br />my writeup on how to use the IDLE command.  You can find the test<br />version of JavaMail (essentially an early version of JavaMail 1.4.1)<br />in the java.net Maven repository (you want the 1.4.1ea version):<br /><br />https://maven-repository.dev.java.net/nonav/repository/javax.mail/<br /><br />Note that this version is built with JDK 1.5 and thus requires JDK 1.5.<br /><br />Oh,and here's the entire list of what's fixed in this version so far:<br /><br />4107594 IMAP implementation should use the IDLE extension if available<br />6423701 Problem with using OrTerm when the protocol is IMAP<br />6431207 SMTP is adding extra CRLF to message content<br />6447295 IMAPMessage fails to return Content-Language from bodystructure<br />6447799 encoded text not decoded even when mail.mime.decodetext.strict is false<br />6447801 MimeBodyPart.writeTo reencodes data unnecessarily<br />6456422 NullPointerException in smtptransport when sending MimeMessages<br />        with no encoding<br />6456444 MimeMessages created from stream are not correctly handled<br />        with allow8bitmime<br />&lt;no id&gt; fix performance bug in base64 encoder; now even faster!");
        JSONArray attachments = new JSONArray();
        attachments.put((Object)bodyObject);
        mail.put(MailJSONField.ATTACHMENTS.getKey(), (Object)attachments);
        UnsynchronizedByteArrayInputStream in = new UnsynchronizedByteArrayInputStream(ICAL_BYTES);
        NetsolSendResponse response = Executor.execute(this.client1.getSession(), new NetsolSendRequest(mail.toString(), (InputStream)in, "text/calendar; charset=US-ASCII", "ical.ics"));
        Bug20758Test.assertTrue((String)"Send failed", (response.getFolderAndID() != null ? 1 : 0) != 0);
        Bug20758Test.assertTrue((String)"Duration corrupt", (response.getRequestDuration() > 0L ? 1 : 0) != 0);
        String[] mailFolderAndMailID = response.getFolderAndID();
        mailFolderAndMailID[1] = this.parseMailId(mailFolderAndMailID[1]);
        return mailFolderAndMailID;
    }

    protected String getSequenceIdForMail(AJAXClient c, String[] mailFolderAndMailID) throws Exception {
        FolderAndID fai = new FolderAndID(mailFolderAndMailID[0], mailFolderAndMailID[1]);
        NetsolGetResponse resp = Executor.execute(c.getSession(), new NetsolGetRequest(fai, true));
        JSONObject mailObject = (JSONObject)resp.getData();
        JSONArray att = mailObject.getJSONArray(MailJSONField.ATTACHMENTS.getKey());
        int len = att.length();
        String sequenceId = null;
        for (int i = 0; i < len && sequenceId == null; ++i) {
            JSONObject attachObj = att.getJSONObject(i);
            if (!attachObj.getString(MailJSONField.CONTENT_TYPE.getKey()).startsWith("text/calendar")) continue;
            sequenceId = attachObj.getString(MailListField.ID.getKey());
        }
        return sequenceId;
    }
}

