/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractContactTest;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;

public class MoveTest
extends AbstractContactTest {
    private FolderObject folder;
    private int targetFolder;
    private int objectId;

    public MoveTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testMove2PrivateFolder() throws Exception {
        Contact contactObj = new Contact();
        contactObj.setSurName("testMove2PrivateFolder");
        contactObj.setParentFolderID(this.contactFolderId);
        this.objectId = this.insertContact(contactObj);
        this.folder = Create.createPrivateFolder("testCopy" + System.currentTimeMillis(), 3, this.userId);
        this.folder.setParentFolderID(this.client.getValues().getPrivateContactFolder());
        InsertResponse folderCreateResponse = this.client.execute(new InsertRequest(EnumAPI.OUTLOOK, this.folder));
        folderCreateResponse.fillObject((DataObject)this.folder);
        this.targetFolder = this.folder.getObjectID();
        contactObj.setParentFolderID(this.targetFolder);
        this.updateContact(contactObj, this.contactFolderId);
        Contact loadContact = this.loadContact(this.objectId, this.targetFolder);
        contactObj.setObjectID(this.objectId);
        this.compareObject(contactObj, loadContact);
    }

    public void testMove2PublicFolder() throws Exception {
        Contact contactObj = new Contact();
        contactObj.setSurName("testMove2PublicFolder");
        contactObj.setParentFolderID(this.contactFolderId);
        this.objectId = this.insertContact(contactObj);
        this.folder = Create.createPrivateFolder("testCopy" + System.currentTimeMillis(), 3, this.userId);
        this.folder.setParentFolderID(this.client.getValues().getPrivateContactFolder());
        InsertResponse folderCreateResponse = this.client.execute(new InsertRequest(EnumAPI.OUTLOOK, this.folder));
        folderCreateResponse.fillObject((DataObject)this.folder);
        this.targetFolder = this.folder.getObjectID();
        contactObj.setParentFolderID(this.targetFolder);
        this.updateContact(contactObj, this.contactFolderId);
        Contact loadContact = this.loadContact(this.objectId, this.targetFolder);
        contactObj.setObjectID(this.objectId);
        this.compareObject(contactObj, loadContact);
    }

    @Override
    protected void tearDown() throws Exception {
        this.deleteContact(this.objectId, this.targetFolder, true);
        this.client.execute(new DeleteRequest((API)EnumAPI.OUTLOOK, this.folder));
        super.tearDown();
    }
}

