/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.ContactTest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.groupware.container.Contact;
import org.json.JSONObject;

public class GetTest
extends ContactTest {
    public GetTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testGet() throws Exception {
        Contact contactObj = this.createContactObject("testGet");
        int objectId = GetTest.insertContact(this.getWebConversation(), contactObj, "http://" + this.getHostName(), this.getSessionId());
        GetTest.loadContact(this.getWebConversation(), objectId, contactFolderId, "http://", this.getHostName(), this.getSessionId());
    }

    public void testGetWithAllFields() throws Exception {
        Contact contactObject = this.createCompleteContactObject();
        int objectId = GetTest.insertContact(this.getWebConversation(), contactObject, "http://" + this.getHostName(), this.getSessionId());
        Contact loadContact = GetTest.loadContact(this.getWebConversation(), objectId, contactFolderId, "http://", this.getHostName(), this.getSessionId());
        contactObject.setObjectID(objectId);
        this.compareObject(contactObject, loadContact);
    }

    public void testGetWithAllFieldsOnUpdate() throws Exception {
        Contact contactObject = new Contact();
        contactObject.setSurName("testGetWithAllFieldsOnUpdate");
        contactObject.setParentFolderID(contactFolderId);
        int objectId = GetTest.insertContact(this.getWebConversation(), contactObject, "http://" + this.getHostName(), this.getSessionId());
        contactObject = this.createCompleteContactObject();
        GetTest.updateContact(this.getWebConversation(), contactObject, objectId, contactFolderId, "http://" + this.getHostName(), this.getSessionId());
        Contact loadContact = GetTest.loadContact(this.getWebConversation(), objectId, contactFolderId, "http://", this.getHostName(), this.getSessionId());
        contactObject.setObjectID(objectId);
        this.compareObject(contactObject, loadContact);
    }

    public void testGetUser() throws Exception {
        Contact loadContact = GetTest.loadUser(this.getWebConversation(), this.userId, this.getHostName(), this.getSessionId());
        GetTest.assertNotNull((String)"contact object is null", (Object)loadContact);
        GetTest.assertEquals((String)"user id is not equals", (int)this.userId, (int)loadContact.getInternalUserId());
        GetTest.assertTrue((String)"object id not set", (loadContact.getObjectID() > 0 ? 1 : 0) != 0);
        AJAXClient client = new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId()));
        com.openexchange.ajax.user.actions.GetResponse response = client.execute(new com.openexchange.ajax.user.actions.GetRequest(this.userId, client.getValues().getTimeZone()));
        loadContact = response.getContact();
        GetTest.assertNotNull((String)"contact object is null", (Object)loadContact);
        GetTest.assertEquals((String)"user id is not equals", (int)this.userId, (int)loadContact.getInternalUserId());
        GetTest.assertTrue((String)"object id not set", (loadContact.getObjectID() > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLastModifiedUTC() throws Exception {
        AJAXClient client = new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId()));
        Contact contactObj = this.createContactObject("testNew");
        int objectId = GetTest.insertContact(this.getWebConversation(), contactObj, "http://" + this.getHostName(), this.getSessionId());
        try {
            GetRequest req = new GetRequest(contactFolderId, objectId, client.getValues().getTimeZone());
            GetResponse response = Executor.execute(client, req);
            JSONObject contact = (JSONObject)response.getResponse().getData();
            GetTest.assertTrue((boolean)contact.has("last_modified_utc"));
        }
        finally {
            GetTest.deleteContact(this.getWebConversation(), objectId, contactFolderId, this.getHostName(), this.getSessionId());
        }
    }
}

