/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import java.util.TimeZone;

public class Bug16515Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private TimeZone tz;
    private Contact contact;
    private final String FILE_AS_VALUE = "I'm the file_as field of Herbert Meier";

    public Bug16515Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.tz = this.client.getValues().getTimeZone();
        this.contact = this.createContact();
    }

    public void testFileAs() throws Exception {
        GetRequest getContactReq = new GetRequest(this.contact.getParentFolderID(), this.contact.getObjectID(), this.tz);
        GetResponse getContactResp = this.client.execute(getContactReq);
        Contact toCompare = getContactResp.getContact();
        Bug16515Test.assertEquals((String)"File as has changed after creating contact.", (String)this.contact.getFileAs(), (String)toCompare.getFileAs());
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest deleteContactReq = new DeleteRequest(this.contact, false);
        this.client.execute(deleteContactReq);
    }

    public Contact createContact() throws Exception {
        Contact contact = new Contact();
        contact.setTitle("Herr");
        contact.setSurName("Meier");
        contact.setGivenName("Herbert");
        contact.setDisplayName("Herbert Meier");
        contact.setStreetBusiness("Franz-Meier Weg 17");
        contact.setCityBusiness("Test Stadt");
        contact.setStateBusiness("NRW");
        contact.setCountryBusiness("Deutschland");
        contact.setTelephoneBusiness1("+49112233445566");
        contact.setCompany("Internal Test AG");
        contact.setEmail1("hebert.meier@open-xchange.com");
        contact.setParentFolderID(this.client.getValues().getPrivateContactFolder());
        contact.setFileAs("I'm the file_as field of Herbert Meier");
        InsertRequest insertContactReq = new InsertRequest(contact);
        InsertResponse insertContactResp = this.client.execute(insertContactReq);
        insertContactResp.fillObject((DataObject)contact);
        return contact;
    }
}

