/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.Order;
import com.openexchange.test.ContactTestManager;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class BasicManagedContactTests
extends AbstractManagedContactTest {
    public BasicManagedContactTests(String name) {
        super(name);
    }

    public void testCreateAndGetContact() {
        Contact expected = this.generateContact();
        this.manager.newAction(expected);
        Contact actual = this.manager.getAction(this.folderID, expected.getObjectID());
        BasicManagedContactTests.assertEquals((String)"Surname should match", (String)expected.getSurName(), (String)actual.getSurName());
        BasicManagedContactTests.assertEquals((String)"Given name should match", (String)expected.getGivenName(), (String)actual.getGivenName());
    }

    public void testDeleteContact() {
        Contact expected = this.generateContact();
        this.manager.newAction(expected);
        this.manager.deleteAction(expected);
        Contact found = this.manager.getAction(this.folderID, expected.getObjectID());
        BasicManagedContactTests.assertNull((String)"Should not find a contact after deletion", (Object)found);
    }

    public void testGetAllContacts() {
        int numberBefore = this.manager.allAction(this.folderID).length;
        Contact expected = this.generateContact();
        this.manager.newAction(expected);
        Contact[] allContactsOnServer = this.manager.allAction(this.folderID);
        BasicManagedContactTests.assertEquals((String)"Should find exactly one more contact", (int)(numberBefore + 1), (int)allContactsOnServer.length);
    }

    public void testGetAllContactsWithColumns() {
        int numberBefore = this.manager.allAction(this.folderID).length;
        Contact expected = this.generateContact();
        this.manager.newAction(expected);
        Contact[] allContactsOnServer = this.manager.allAction(this.folderID, new int[]{1, 4, 5, 20});
        BasicManagedContactTests.assertEquals((String)"Should find exactly one more contact", (int)(numberBefore + 1), (int)allContactsOnServer.length);
        Contact actual = null;
        for (Contact temp : allContactsOnServer) {
            if (temp.getObjectID() != expected.getObjectID()) continue;
            actual = temp;
        }
        BasicManagedContactTests.assertNotNull((String)"Should find new contact in response of AllRequest", actual);
        BasicManagedContactTests.assertTrue((String)"Should contain field #1", (boolean)actual.contains(1));
        BasicManagedContactTests.assertTrue((String)"Should contain field #4", (boolean)actual.contains(4));
        BasicManagedContactTests.assertTrue((String)"Should contain field #5", (boolean)actual.contains(5));
        BasicManagedContactTests.assertTrue((String)"Should contain field #20", (boolean)actual.contains(20));
    }

    public void testGetAllContactsOrderedByCollationAscending() {
        List<String> sinograph = Arrays.asList("\u963f", "\u6ce2", "\u6b21", "\u7684", "\u9e45", "\u5bcc", "\u54e5", "\u6cb3", "\u6d01", "\u79d1", "\u4e86", "\u4e48", "\u5462", "\u54e6", "\u6279", "\u4e03", "\u5982", "\u56db", "\u8e22", "\u5c4b", "\u897f", "\u8863", "\u5b50");
        for (String graphem : sinograph) {
            this.manager.newAction(ContactTestManager.generateContact(this.folderID, graphem));
        }
        int fieldNum = ContactField.SUR_NAME.getNumber();
        Contact[] allContacts = this.manager.allAction(this.folderID, new int[]{1, 4, 5, 20, fieldNum}, fieldNum, Order.ASCENDING, "gb2312");
        int len = sinograph.size();
        for (int i = 0; i < len; ++i) {
            String expected = sinograph.get(i);
            BasicManagedContactTests.assertEquals((String)("Element #" + i), (String)expected, (String)allContacts[i].getSurName());
        }
    }

    public void testGetAllContactsOrderedByCollationDescending() {
        List<String> sinograph = Arrays.asList("\u963f", "\u6ce2", "\u6b21", "\u7684", "\u9e45", "\u5bcc", "\u54e5", "\u6cb3", "\u6d01", "\u79d1", "\u4e86", "\u4e48", "\u5462", "\u54e6", "\u6279", "\u4e03", "\u5982", "\u56db", "\u8e22", "\u5c4b", "\u897f", "\u8863", "\u5b50");
        for (String graphem : sinograph) {
            this.manager.newAction(ContactTestManager.generateContact(this.folderID, graphem));
        }
        int fieldNum = ContactField.SUR_NAME.getNumber();
        Contact[] allContacts = this.manager.allAction(this.folderID, new int[]{1, 4, 5, 20, fieldNum}, fieldNum, Order.DESCENDING, "gb2312");
        int len = sinograph.size();
        for (int i = 0; i < len; ++i) {
            String expected = sinograph.get(len - i - 1);
            BasicManagedContactTests.assertEquals((String)("Element #" + i), (String)expected, (String)allContacts[i].getSurName());
        }
    }

    public void testGetAllContactsOrderedByCollationOrderedByWonderField() {
        List<String> sinograph = Arrays.asList("\u963f", "\u6ce2", "\u6b21", "\u7684", "\u9e45", "\u5bcc", "\u54e5", "\u6cb3", "\u6d01");
        List<String> lastNames = Arrays.asList("\u963f", "\u6ce2", "\u6b21", "\u7684");
        List<String> displayNames = Arrays.asList("\u9e45", "\u5bcc");
        List<String> companyNames = Arrays.asList("\u54e5", "\u6cb3", "\u6d01");
        List<List> values = Arrays.asList(lastNames, displayNames, companyNames);
        List<ContactField> fields = Arrays.asList(ContactField.SUR_NAME, ContactField.DISPLAY_NAME, ContactField.COMPANY);
        int valPos = 0;
        for (ContactField field : fields) {
            List values2 = values.get(valPos++);
            for (String value : values2) {
                Contact tmp = new Contact();
                tmp.setParentFolderID(this.folderID);
                tmp.set(field.getNumber(), (Object)value);
                tmp.setInfo(value);
                this.manager.newAction(tmp);
            }
        }
        int fieldNum = ContactField.SUR_NAME.getNumber();
        Contact[] allContacts = this.manager.allAction(this.folderID, new int[]{1, 4, 5, 20, fieldNum, ContactField.INFO.getNumber()}, -1, Order.ASCENDING, "gb2312");
        int len = sinograph.size();
        for (int i = 0; i < len; ++i) {
            String expected = sinograph.get(i);
            BasicManagedContactTests.assertEquals((String)("Element #" + i), (String)expected, (String)allContacts[i].getInfo());
        }
    }

    public void testUpdateContactAndGetUpdates() {
        Contact expected = this.generateContact();
        this.manager.newAction(expected);
        expected.setDisplayName("Display name");
        Contact update = this.manager.updateAction(expected);
        Contact[] updated = this.manager.updatesAction(this.folderID, new Date(update.getLastModified().getTime() - 1L));
        BasicManagedContactTests.assertEquals((String)"Only one contact should have been updated", (int)1, (int)updated.length);
        Contact actual = updated[0];
        BasicManagedContactTests.assertEquals((String)"Display name should have been updated", (String)expected.getDisplayName(), (String)actual.getDisplayName());
    }

    public void testAllWithGBK() throws Exception {
        Contact[] allAction = this.manager.allAction(this.getClient().getValues().getPrivateContactFolder(), new int[]{20, 1, 5, 2, 602}, 502, Order.ASCENDING, "gbk");
        BasicManagedContactTests.assertTrue((String)"Should find more than 0 contacts in the private contact folder", (allAction.length > 0 ? 1 : 0) != 0);
    }
}

