/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.webdav.xml.FolderTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Bug4541Test
extends AppointmentTest {
    private static final Log LOG = LogFactory.getLog(Bug4541Test.class);

    public Bug4541Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBug4541() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testBug4541" + System.currentTimeMillis());
        folderObj.setParentFolderID(1);
        folderObj.setModule(2);
        folderObj.setType(1);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 128, 128, 128, 128)};
        folderObj.setPermissionsAsArray(permission);
        int newFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, this.getHostName(), this.getLogin(), this.getPassword(), "");
        Appointment appointmentObj = this.createAppointmentObject("testBug4541");
        appointmentObj.setParentFolderID(newFolderId);
        appointmentObj.setIgnoreConflicts(true);
        Participant[] participants = new Participant[]{new UserParticipant()};
        participants[0].setIdentifier(this.userId);
        appointmentObj.setParticipants(participants);
        int objectId = Bug4541Test.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = Bug4541Test.loadAppointment(this.getWebConversation(), objectId, newFolderId, this.timeZone, this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, appointmentObj.getStartDate().getTime(), appointmentObj.getEndDate().getTime());
        appointmentObj.setTitle("testBug4541 - update");
        appointmentObj.removeParentFolderID();
        Bug4541Test.updateAppointment(this.getWebConversation(), appointmentObj, objectId, newFolderId, this.timeZone, this.getHostName(), this.getSessionId());
        appointmentObj.setParentFolderID(newFolderId);
        loadAppointment = Bug4541Test.loadAppointment(this.getWebConversation(), objectId, newFolderId, this.timeZone, this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, appointmentObj.getStartDate().getTime(), appointmentObj.getEndDate().getTime());
        Bug4541Test.deleteAppointment(this.getWebConversation(), objectId, newFolderId, this.getHostName(), this.getSessionId(), false);
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{newFolderId}, this.getHostName(), this.getLogin(), this.getPassword(), "");
    }
}

