/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.SearchRequest;
import com.openexchange.ajax.appointment.action.SearchResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import org.json.JSONArray;

public class Bug18455Test
extends AbstractAJAXSession {
    private AJAXClient clientA;
    private AJAXClient clientB;
    private FolderObject folder;
    private Appointment appointment;
    private AJAXClient clientC;

    public Bug18455Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clientA = this.getClient();
        this.clientB = new AJAXClient(AJAXClient.User.User2);
        this.clientC = new AJAXClient(AJAXClient.User.User3);
        this.folder = Create.folder(1, "Folder to test bug 18455", 2, 1, Create.ocl(this.clientA.getValues().getUserId(), false, true, 128, 128, 128, 128), Create.ocl(this.clientB.getValues().getUserId(), false, false, 128, 128, 128, 128));
        CommonInsertResponse response = this.clientA.execute(new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_OLD, this.folder));
        response.fillObject((DataObject)this.folder);
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 18455 Test");
        this.appointment.setStartDate(TimeTools.D("01.03.2011 08:00"));
        this.appointment.setEndDate(TimeTools.D("01.03.2011 09:00"));
        this.appointment.setParentFolderID(this.folder.getObjectID());
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setUsers(new UserParticipant[]{new UserParticipant(this.clientA.getValues().getUserId()), new UserParticipant(this.clientC.getValues().getUserId())});
        this.appointment.setParticipants(new Participant[]{new UserParticipant(this.clientA.getValues().getUserId()), new UserParticipant(this.clientC.getValues().getUserId())});
        InsertRequest insertRequest = new InsertRequest(this.appointment, this.clientA.getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.clientA.execute(insertRequest);
        insertResponse.fillObject((DataObject)this.appointment);
    }

    public void testBug18455() throws Exception {
        SearchRequest search = new SearchRequest("Bug 18455 Test", -1, new int[]{1, 20, 200});
        SearchResponse searchResponse = this.clientB.execute(search);
        JSONArray jsonArray = (JSONArray)searchResponse.getResponse().getData();
        boolean found = false;
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONArray result = jsonArray.getJSONArray(i);
            if (result.getInt(0) != this.appointment.getObjectID()) continue;
            Bug18455Test.assertEquals((String)"Wrong folder.", (int)this.folder.getObjectID(), (int)result.getInt(1));
            found = true;
        }
        Bug18455Test.assertTrue((String)"Test broken, unable to find appointment.", (boolean)found);
    }

    @Override
    public void tearDown() throws Exception {
        this.clientA.execute(new DeleteRequest((API)EnumAPI.OX_OLD, this.folder));
        super.tearDown();
    }
}

