/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.SearchRequest;
import com.openexchange.ajax.appointment.action.SearchResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import java.util.Date;
import org.json.JSONArray;

public class Bug13625Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private int userId;
    private final int[] columns = new int[]{1};

    public Bug13625Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.userId = this.getClient().getValues().getUserId();
        this.appointment = new Appointment();
        this.appointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.appointment.setTitle("Test Bug 13625");
        this.appointment.setStartDate(new Date(TimeTools.getHour(0, this.getClient().getValues().getTimeZone())));
        this.appointment.setEndDate(new Date(TimeTools.getHour(1, this.getClient().getValues().getTimeZone())));
        this.appointment.setParticipants(ParticipantTools.createParticipants(this.userId));
        this.appointment.setCategories("eins, zwei");
        this.appointment.setIgnoreConflicts(true);
        InsertRequest request = new InsertRequest(this.appointment, this.getClient().getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.getClient().execute(request);
        insertResponse.fillObject((DataObject)this.appointment);
    }

    public void testBug13625() throws Exception {
        SearchRequest searchRequest = new SearchRequest("eins", this.getClient().getValues().getPrivateAppointmentFolder(), this.columns, true);
        SearchResponse searchResponse = this.getClient().execute(searchRequest);
        JSONArray jsonArray = (JSONArray)searchResponse.getResponse().getData();
        Bug13625Test.assertTrue((String)"No results", (jsonArray.length() > 0 ? 1 : 0) != 0);
        boolean found = false;
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONArray object = jsonArray.optJSONArray(i);
            if (object == null || object.getInt(0) != this.appointment.getObjectID()) continue;
            found = true;
        }
        Bug13625Test.assertTrue((String)"Appointment not found", (boolean)found);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.appointment != null && this.appointment.getObjectID() != 0) {
            this.getClient().execute(new DeleteRequest(this.appointment.getObjectID(), this.appointment.getParentFolderID(), this.appointment.getLastModified()));
        }
        super.tearDown();
    }
}

