/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HttpInternalErrorException;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class TestServletTest {
    private final String URL = "http://localhost/servlet/TestServlet";
    private final String PUTSTRING = "A P\u00dcT String with Umlaut";
    private final String QUERYSTRING = "?";

    @Test
    public void testGetMethod() throws Exception {
        WebConversation conversation = new WebConversation();
        GetMethodWebRequest request = new GetMethodWebRequest("http://localhost/servlet/TestServlet");
        WebResponse response = conversation.getResponse((WebRequest)request);
        HTMLElement[] paragraphs = response.getElementsByTagName("p");
    }

    @Test
    public void testPutMethod() throws IOException, SAXException {
        WebConversation conversation = new WebConversation();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("A P\u00dcT String with Umlaut".getBytes("UTF-8"));
        PutMethodWebRequest request = new PutMethodWebRequest("http://localhost/servlet/TestServlet", (InputStream)byteArrayInputStream, "text/xml");
        WebResponse response = conversation.getResponse((WebRequest)request);
        HTMLElement[] paragraphs = response.getElementsByTagName("p");
        Assert.assertEquals((String)"The transfered content differs", (Object)"The content: A P\u00dcT String with Umlaut", (Object)paragraphs[4].getText());
    }

    @Test(expected=HttpInternalErrorException.class)
    public void testMaxParam() throws Exception {
        WebConversation conversation = new WebConversation();
        GetMethodWebRequest request = new GetMethodWebRequest("http://localhost/servlet/TestServlet");
        for (int i = 0; i < 31; ++i) {
            request.setParameter("param" + i, "value" + i);
        }
        WebResponse response = conversation.getResponse((WebRequest)request);
        int responseCode = response.getResponseCode();
        System.out.println(responseCode);
    }
}

