/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.mapping;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tools.mappings.json.ArrayMapping;
import com.openexchange.groupware.tools.mappings.json.DefaultJsonMapper;
import com.openexchange.groupware.tools.mappings.json.DefaultJsonMapping;
import com.openexchange.groupware.tools.mappings.json.IntegerMapping;
import com.openexchange.groupware.tools.mappings.json.JsonMapping;
import com.openexchange.groupware.tools.mappings.json.StringMapping;
import com.openexchange.session.Session;
import com.openexchange.user.json.field.UserField;
import com.openexchange.user.json.parser.ParsedUser;
import java.util.EnumMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserMapper
extends DefaultJsonMapper<User, UserField> {
    private static final UserMapper INSTANCE = new UserMapper();
    private UserField[] allFields = null;
    private static final Pattern identifierPattern = Pattern.compile("(\\p{Lower}{2})(?:_(\\p{Upper}{2}))?(?:_([a-zA-Z]{2}))?");

    public static UserMapper getInstance() {
        return INSTANCE;
    }

    private UserMapper() {
    }

    public User newInstance() {
        return new ParsedUser();
    }

    public UserField[] newArray(int size) {
        return new UserField[size];
    }

    public JsonMapping<? extends Object, User> get(UserField field) throws OXException {
        if (null == field) {
            throw new IllegalArgumentException("field");
        }
        JsonMapping mapping = (JsonMapping)this.getMappings().get((Object)field);
        if (null == mapping) {
            throw OXException.notFound((String)field.toString());
        }
        return mapping;
    }

    public UserField[] getAllFields() {
        if (null == this.allFields) {
            this.allFields = this.mappings.keySet().toArray(this.newArray(this.mappings.keySet().size()));
        }
        return this.allFields;
    }

    protected EnumMap<UserField, JsonMapping<? extends Object, User>> createMappings() {
        EnumMap<UserField, JsonMapping<? extends Object, User>> mappings = new EnumMap<UserField, JsonMapping<? extends Object, User>>(UserField.class);
        mappings.put(UserField.ID, (JsonMapping<? extends Object, User>)new IntegerMapping<User>("id", 1){

            public boolean isSet(User object) {
                return -1 != object.getId();
            }

            public void set(User object, Integer value) throws OXException {
                if (!ParsedUser.class.isInstance(object)) {
                    throw new UnsupportedOperationException();
                }
                ((ParsedUser)object).setId(null != value ? value : -1);
            }

            public Integer get(User object) {
                return object.getId();
            }

            public void remove(User object) {
                if (!ParsedUser.class.isInstance(object)) {
                    throw new UnsupportedOperationException();
                }
                ((ParsedUser)object).setId(-1);
            }
        });
        mappings.put(UserField.ALIASES, (JsonMapping<? extends Object, User>)new ArrayMapping<String, User>("aliases", 610){

            public boolean isSet(User object) {
                return null != object.getAliases();
            }

            public void set(User object, String[] value) throws OXException {
                throw new UnsupportedOperationException();
            }

            public String[] get(User object) {
                return object.getAliases();
            }

            public void remove(User object) {
                throw new UnsupportedOperationException();
            }

            public String[] newArray(int size) {
                return new String[size];
            }

            protected String deserialize(JSONArray array, int index) throws JSONException, OXException {
                throw new UnsupportedOperationException();
            }
        });
        mappings.put(UserField.TIME_ZONE, (JsonMapping<? extends Object, User>)new StringMapping<User>("timezone", 611){

            public boolean isSet(User object) {
                return null != object.getTimeZone();
            }

            public void set(User object, String value) throws OXException {
                if (!ParsedUser.class.isInstance(object)) {
                    throw new UnsupportedOperationException();
                }
                ((ParsedUser)object).setTimeZone(value);
            }

            public String get(User object) {
                return object.getTimeZone();
            }

            public void remove(User object) {
                if (!ParsedUser.class.isInstance(object)) {
                    throw new UnsupportedOperationException();
                }
                ((ParsedUser)object).setTimeZone(null);
            }
        });
        mappings.put(UserField.LOCALE, (JsonMapping<? extends Object, User>)new DefaultJsonMapping<Locale, User>("locale", 612){

            public void deserialize(JSONObject from, User to) throws JSONException, OXException {
                if (from.hasAndNotNull(this.getAjaxName())) {
                    if (ParsedUser.class.isInstance(to)) {
                        ((ParsedUser)to).setLocale(UserMapper.parseLocaleString(from.getString(this.getAjaxName())));
                    } else {
                        throw new UnsupportedOperationException();
                    }
                }
            }

            public boolean isSet(User object) {
                return null != object.getLocale();
            }

            public void set(User object, Locale value) throws OXException {
                if (!ParsedUser.class.isInstance(object)) {
                    throw new UnsupportedOperationException();
                }
                ((ParsedUser)object).setLocale(value);
            }

            public Locale get(User object) {
                return object.getLocale();
            }

            public void remove(User object) {
                if (!ParsedUser.class.isInstance(object)) {
                    throw new UnsupportedOperationException();
                }
                ((ParsedUser)object).setLocale(null);
            }
        });
        mappings.put(UserField.GROUPS, (JsonMapping<? extends Object, User>)new DefaultJsonMapping<int[], User>("groups", 613){

            public void deserialize(JSONObject from, User to) throws JSONException, OXException {
                throw new UnsupportedOperationException();
            }

            public Object serialize(User from, TimeZone timeZone, Session session) throws JSONException {
                int[] value = this.get(from);
                if (null == value) {
                    return JSONObject.NULL;
                }
                JSONArray jsonArray = new JSONArray(value.length);
                for (int group : value) {
                    jsonArray.put(group);
                }
                return jsonArray;
            }

            public boolean isSet(User object) {
                return null != object.getGroups();
            }

            public void set(User object, int[] value) throws OXException {
                throw new UnsupportedOperationException();
            }

            public int[] get(User object) {
                return object.getGroups();
            }

            public void remove(User object) {
                throw new UnsupportedOperationException();
            }
        });
        mappings.put(UserField.CONTACT_ID, (JsonMapping<? extends Object, User>)new IntegerMapping<User>("contact_id", 614){

            public boolean isSet(User object) {
                return -1 != object.getContactId();
            }

            public void set(User object, Integer value) throws OXException {
                throw new UnsupportedOperationException();
            }

            public Integer get(User object) {
                return object.getContactId();
            }

            public void remove(User object) {
                throw new UnsupportedOperationException();
            }
        });
        mappings.put(UserField.LOGIN_INFO, (JsonMapping<? extends Object, User>)new StringMapping<User>("login_info", 615){

            public boolean isSet(User object) {
                return null != object.getLoginInfo();
            }

            public void set(User object, String value) throws OXException {
                throw new UnsupportedOperationException();
            }

            public String get(User object) {
                return object.getLoginInfo();
            }

            public void remove(User object) {
                throw new UnsupportedOperationException();
            }
        });
        return mappings;
    }

    private static Locale parseLocaleString(String localeStr) throws OXException {
        Matcher match = identifierPattern.matcher(localeStr);
        Locale retval = null;
        if (match.matches()) {
            String country = match.group(2);
            String variant = match.group(3);
            retval = new Locale(match.group(1), country == null ? "" : country, variant == null ? "" : variant);
        }
        return retval;
    }
}

