/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.documentation.annotations.Module;
import com.openexchange.exception.OXException;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.user.json.actions.AbstractUserAction;
import com.openexchange.user.json.actions.AllAction;
import com.openexchange.user.json.actions.GetAction;
import com.openexchange.user.json.actions.GetAttributeAction;
import com.openexchange.user.json.actions.ListAction;
import com.openexchange.user.json.actions.SearchAction;
import com.openexchange.user.json.actions.SetAttributeAction;
import com.openexchange.user.json.actions.UpdateAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Module(name="user", description="Provides access to user information.")
public final class UserActionFactory
implements AJAXActionServiceFactory {
    private static final UserActionFactory SINGLETON = new UserActionFactory();
    private final Map<String, AJAXActionService> actions = this.initActions();

    public static final UserActionFactory getInstance() {
        return SINGLETON;
    }

    private UserActionFactory() {
    }

    public AJAXActionService createActionService(String action) throws OXException {
        if (null == action) {
            throw AjaxExceptionCodes.UNKNOWN_ACTION.create(new Object[]{action});
        }
        AJAXActionService retval = this.actions.get(action);
        if (null == retval) {
            throw AjaxExceptionCodes.UNKNOWN_ACTION.create(new Object[]{action});
        }
        return retval;
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }

    private Map<String, AJAXActionService> initActions() {
        HashMap<String, AbstractUserAction> tmp = new HashMap<String, AbstractUserAction>(12);
        tmp.put("get", new GetAction());
        tmp.put("list", new ListAction());
        tmp.put("all", new AllAction());
        tmp.put("search", new SearchAction());
        tmp.put("update", new UpdateAction());
        tmp.put("getAttribute", new GetAttributeAction());
        tmp.put("setAttribute", new SetAttributeAction());
        return Collections.unmodifiableMap(tmp);
    }
}

