/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.subscribe.SubscribeService;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionSourceCollector;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OSGiSubscriptionSourceCollector
extends SubscriptionSourceCollector
implements ServiceTrackerCustomizer {
    private final ServiceTracker tracker;
    private final BundleContext context;
    private boolean grabbedAll;

    public OSGiSubscriptionSourceCollector(BundleContext context) throws InvalidSyntaxException {
        this.context = context;
        this.tracker = new ServiceTracker(context, SubscribeService.class.getName(), (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    private void grabAll() {
        if (this.grabbedAll) {
            return;
        }
        try {
            ServiceReference[] serviceReferences = this.context.getAllServiceReferences(SubscribeService.class.getName(), null);
            if (serviceReferences != null) {
                for (ServiceReference reference : serviceReferences) {
                    this.addingService(reference);
                }
            }
            this.grabbedAll = true;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void close() {
        this.tracker.close();
    }

    public Object addingService(ServiceReference reference) {
        SubscribeService subscribeService = (SubscribeService)this.context.getService(reference);
        this.addSubscribeService(subscribeService);
        return subscribeService;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.removeSubscribeService(((SubscribeService)service).getSubscriptionSource().getId());
    }

    @Override
    public SubscriptionSource getSource(Context context, int subscriptionId) throws OXException {
        this.grabAll();
        return super.getSource(context, subscriptionId);
    }

    @Override
    public SubscriptionSource getSource(String identifier) {
        this.grabAll();
        return super.getSource(identifier);
    }

    @Override
    public List<SubscriptionSource> getSources(int folderModule) {
        this.grabAll();
        return super.getSources(folderModule);
    }

    @Override
    public boolean knowsSource(String identifier) {
        this.grabAll();
        return super.knowsSource(identifier);
    }
}

