/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.helpers;

import com.openexchange.config.cascade.ComposedConfigProperty;
import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class FilteredSubscriptionSourceDiscoveryService
implements SubscriptionSourceDiscoveryService {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FilteredSubscriptionSourceDiscoveryService.class));
    public static final AtomicReference<ConfigViewFactory> CONFIG_VIEW_FACTORY = new AtomicReference();
    public SubscriptionSourceDiscoveryService delegate = null;
    private final ConfigView config;

    public FilteredSubscriptionSourceDiscoveryService(int user, int context, SubscriptionSourceDiscoveryService delegate) throws OXException {
        this.config = CONFIG_VIEW_FACTORY.get().getView(user, context);
        this.delegate = delegate;
    }

    @Override
    public SubscriptionSource getSource(String identifier) {
        if (this.accepts(identifier)) {
            return this.delegate.getSource(identifier);
        }
        return null;
    }

    @Override
    public SubscriptionSource getSource(Context context, int subscriptionId) throws OXException {
        SubscriptionSource source = this.delegate.getSource(context, subscriptionId);
        return this.filter(source);
    }

    @Override
    public List<SubscriptionSource> getSources() {
        return this.filter(this.delegate.getSources());
    }

    @Override
    public List<SubscriptionSource> getSources(int folderModule) {
        return this.filter(this.delegate.getSources(folderModule));
    }

    @Override
    public boolean knowsSource(String identifier) {
        return this.accepts(identifier) ? this.delegate.knowsSource(identifier) : false;
    }

    @Override
    public SubscriptionSourceDiscoveryService filter(int user, int context) throws OXException {
        return this.delegate.filter(user, context);
    }

    protected boolean accepts(String identifier) {
        try {
            ComposedConfigProperty property = this.config.property(identifier, Boolean.TYPE);
            if (property.isDefined()) {
                return (Boolean)property.get();
            }
            return true;
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected SubscriptionSource filter(SubscriptionSource source) {
        if (source == null) {
            return null;
        }
        return this.accepts(source.getId()) ? source : null;
    }

    protected List<SubscriptionSource> filter(List<SubscriptionSource> sources) {
        ArrayList<SubscriptionSource> filtered = new ArrayList<SubscriptionSource>(sources.size());
        for (SubscriptionSource subscriptionSource : sources) {
            if (!this.accepts(subscriptionSource.getId())) continue;
            filtered.add(subscriptionSource);
        }
        return filtered;
    }
}

