/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.osgi.RegistryCustomizer;
import com.openexchange.osgi.ServiceRegistry;
import com.openexchange.smtp.SMTPProvider;
import com.openexchange.smtp.services.SMTPServiceRegistry;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class SMTPActivator
extends HousekeepingActivator {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(SMTPActivator.class));

    protected Class<?>[] getNeededServices() {
        return new Class[]{ConfigurationService.class, MailAccountStorageService.class};
    }

    protected void handleUnavailability(Class<?> clazz) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Absent service: " + clazz.getName()));
        }
        SMTPServiceRegistry.getServiceRegistry().removeService(clazz);
    }

    protected void handleAvailability(Class<?> clazz) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Re-available service: " + clazz.getName()));
        }
        SMTPServiceRegistry.getServiceRegistry().addService(clazz, this.getService(clazz));
    }

    public void startBundle() throws Exception {
        try {
            Class<?>[] classes;
            ServiceRegistry registry = SMTPServiceRegistry.getServiceRegistry();
            registry.clearRegistry();
            for (Class<?> classe : classes = this.getNeededServices()) {
                Object service = this.getService(classe);
                if (null == service) continue;
                registry.addService(classe, service);
            }
            this.track(HostnameService.class, (ServiceTrackerCustomizer)new RegistryCustomizer(this.context, HostnameService.class, SMTPServiceRegistry.getServiceRegistry()));
            this.openTrackers();
            Hashtable<String, String> dictionary = new Hashtable<String, String>(1);
            ((Dictionary)dictionary).put("protocol", SMTPProvider.PROTOCOL_SMTP.toString());
            this.registerService(TransportProvider.class, (Object)SMTPProvider.getInstance(), dictionary);
        }
        catch (Throwable t) {
            LOG.error((Object)t.getMessage(), t);
            throw t instanceof Exception ? (Exception)t : new Exception(t);
        }
    }

    public void stopBundle() throws Exception {
        try {
            this.cleanUp();
            SMTPServiceRegistry.getServiceRegistry().clearRegistry();
        }
        catch (Throwable t) {
            LOG.error((Object)t.getMessage(), t);
            throw t instanceof Exception ? (Exception)t : new Exception(t);
        }
    }
}

