/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp.filler;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.session.Session;
import com.openexchange.smtp.config.ISMTPProperties;
import com.openexchange.smtp.dataobjects.SMTPMailMessage;
import com.sun.mail.smtp.SMTPMessage;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.idn.IDNA;

public final class SMTPMessageFiller
extends MimeMessageFiller {
    private final ISMTPProperties smtpProperties;

    public SMTPMessageFiller(ISMTPProperties smtpProperties, Session session, Context ctx) {
        super(session, ctx);
        this.smtpProperties = smtpProperties;
    }

    public SMTPMessageFiller(ISMTPProperties smtpProperties, Session session, Context ctx, UserSettingMail usm) {
        super(session, ctx, usm);
        this.smtpProperties = smtpProperties;
    }

    public void fillMail(SMTPMailMessage mail, SMTPMessage smtpMessage) throws MessagingException, OXException, IOException {
        this.fillMail(mail, smtpMessage, ComposeType.NEW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillMail(ComposedMailMessage mail, SMTPMessage smtpMessage, ComposeType type) throws MessagingException, OXException, IOException {
        MailPath msgref;
        if (null != type) {
            mail.setSendType(type);
        }
        if (ComposeType.REPLY.equals((Object)type) && (msgref = mail.getMsgref()) != null) {
            MailAccess access = null;
            try {
                access = MailAccess.getInstance((Session)this.session, (int)msgref.getAccountId());
                access.connect();
                SMTPMessageFiller.setReplyHeaders((MailMessage)access.getMessageStorage().getMessage(msgref.getFolder(), msgref.getMailID(), false), (MimeMessage)smtpMessage);
            }
            finally {
                if (null != access) {
                    access.close(true);
                }
            }
        }
        this.setMessageHeaders(mail, (MimeMessage)smtpMessage);
        this.setCommonHeaders((MimeMessage)smtpMessage);
        this.fillMailBody(mail, (MimeMessage)smtpMessage, type);
    }

    public void setCommonHeaders(MimeMessage mimeMessage) throws MessagingException {
        super.setCommonHeaders(mimeMessage);
        if (this.smtpProperties.isSmtpEnvelopeFrom() && mimeMessage instanceof SMTPMessage) {
            ((SMTPMessage)mimeMessage).setEnvelopeFrom(IDNA.toACE((String)UserStorage.getStorageUser((int)this.session.getUserId(), (Context)this.ctx).getMail()));
        }
    }
}

