/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.resources;

import com.openexchange.log.LogFactory;
import com.openexchange.webdav.action.behaviour.BehaviourLookup;
import com.openexchange.webdav.protocol.Multistatus;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.WebdavStatus;
import com.openexchange.webdav.protocol.util.Utils;
import com.openexchange.webdav.xml.resources.PropfindResponseUrlEncoder;
import com.openexchange.webdav.xml.resources.ResourceMarshaller;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class PropertiesMarshaller
implements ResourceMarshaller {
    protected static final Namespace DAV_NS = Protocol.DAV_NS;
    protected static final Namespace DATE_NS = Namespace.getNamespace((String)"b", (String)"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/");
    private String uriPrefix;
    private final String charset;
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(PropertiesMarshaller.class));

    protected Multistatus<Iterable<WebdavProperty>> getProps(WebdavResource resource) {
        return new Multistatus<Iterable<WebdavProperty>>();
    }

    public PropertiesMarshaller(String charset) {
        this.charset = charset;
    }

    public PropertiesMarshaller(String uriPrefix, String charset) {
        this.uriPrefix = uriPrefix;
        if (!this.uriPrefix.endsWith("/")) {
            this.uriPrefix = this.uriPrefix + "/";
        }
        this.charset = charset;
    }

    @Override
    public List<Element> marshal(WebdavResource resource) throws WebdavProtocolException {
        Element response = new Element("response", DAV_NS);
        response.addContent((Content)this.marshalHREF(resource.getUrl(), resource.getResourceType() != null));
        if (resource.exists()) {
            Multistatus<Iterable<WebdavProperty>> multistatus = this.getProps(resource);
            for (int statusCode : multistatus.getStatusCodes()) {
                for (WebdavStatus<Iterable<WebdavProperty>> status : multistatus.toIterable(statusCode)) {
                    Element propstat = new Element("propstat", DAV_NS);
                    Element prop = new Element("prop", DAV_NS);
                    for (WebdavProperty p : status.getAdditional()) {
                        if (p == null) continue;
                        prop.addContent((Content)this.marshalProperty(p, resource.getProtocol()));
                    }
                    propstat.addContent((Content)prop);
                    propstat.addContent((Content)this.marshalStatus(statusCode));
                    response.addContent((Content)propstat);
                }
            }
        } else {
            response.addContent((Content)this.marshalStatus(404));
        }
        return Arrays.asList(response);
    }

    public Element marshalHREF(WebdavPath uri, boolean trailingSlash) {
        Element href = new Element("href", DAV_NS);
        StringBuilder builder = new StringBuilder(this.uriPrefix);
        if (builder.charAt(builder.length() - 1) != '/') {
            builder.append('/');
        }
        for (String component : uri) {
            builder.append(this.escape(component)).append('/');
        }
        if (!trailingSlash) {
            builder.setLength(builder.length() - 1);
        }
        href.setText(builder.toString());
        return href;
    }

    private String escape(String string) {
        PropfindResponseUrlEncoder encoder = BehaviourLookup.getInstance().get(PropfindResponseUrlEncoder.class);
        if (null != encoder) {
            return encoder.encode(string);
        }
        try {
            return URLEncoder.encode(string, this.charset).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            LOG.fatal((Object)e);
            return string;
        }
    }

    public Element marshalStatus(int s) {
        Element status = new Element("status", DAV_NS);
        StringBuilder content = new StringBuilder("HTTP/1.1 ");
        content.append(s);
        content.append(' ');
        content.append(Utils.getStatusString(s));
        status.setText(content.toString());
        return status;
    }

    public Element marshalProperty(WebdavProperty property, Protocol protocol) {
        Element propertyElement = new Element(property.getName(), this.getNamespace(property));
        if (property.getValue() == null) {
            return propertyElement;
        }
        if (property.isXML()) {
            try {
                StringBuilder xmlBuilder;
                String asXML = null;
                if ("DAV:".equals(property.getNamespace())) {
                    xmlBuilder = new StringBuilder("<FKR:fakeroot xmlns:FKR=\"http://www.open-xchange.com/webdav/fakeroot\" xmlns:D=\"DAV:\"");
                    List<Namespace> namespaces = protocol.getAdditionalNamespaces();
                    for (Namespace namespace : namespaces) {
                        xmlBuilder.append(" xmlns:").append(namespace.getPrefix()).append("=\"").append(namespace.getURI()).append('\"');
                    }
                    xmlBuilder.append('>').append(property.getValue()).append("</FKR:fakeroot>");
                    asXML = xmlBuilder.toString();
                } else {
                    xmlBuilder = new StringBuilder("<FKR:fakeroot xmlns:FKR=\"http://www.open-xchange.com/webdav/fakeroot\" xmlns:D=\"DAV:\" xmlns=\"").append(property.getNamespace()).append('\"');
                    List<Namespace> namespaces = protocol.getAdditionalNamespaces();
                    for (Namespace namespace : namespaces) {
                        xmlBuilder.append(" xmlns:").append(namespace.getPrefix()).append("=\"").append(namespace.getURI()).append('\"');
                    }
                    xmlBuilder.append('>').append(property.getValue()).append("</FKR:fakeroot>");
                    asXML = xmlBuilder.toString();
                }
                Document doc = new SAXBuilder().build((Reader)new StringReader(asXML));
                propertyElement.setContent((Collection)doc.getRootElement().cloneContent());
            }
            catch (JDOMException e) {
                LOG.error((Object)e);
                propertyElement.setText(property.getValue());
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        } else {
            if (property.isDate()) {
                propertyElement.setAttribute("dt", "dateTime.tz", DATE_NS);
            }
            propertyElement.setText(property.getValue());
        }
        return propertyElement;
    }

    private Namespace getNamespace(WebdavProperty property) {
        String namespace = property.getNamespace();
        if (namespace.equals("DAV:")) {
            return DAV_NS;
        }
        return Namespace.getNamespace((String)namespace);
    }
}

