/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionConstants;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.Attachments;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.version.Version;
import com.openexchange.webdav.LastModifiedCache;
import com.openexchange.webdav.PendingInvocations;
import com.openexchange.webdav.PermissionServlet;
import com.openexchange.webdav.WebdavExceptionCode;
import com.openexchange.webdav.xml.DataParser;
import com.openexchange.webdav.xml.DataWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class XmlServlet<I>
extends PermissionServlet {
    private static final long serialVersionUID = -2484534357141516623L;
    public static final AttachmentBase attachmentBase = Attachments.getInstance();
    public static final int MODIFICATION_STATUS = 1000;
    public static final int OBJECT_NOT_FOUND_STATUS = 1001;
    public static final int PERMISSION_STATUS = 1002;
    public static final int CONFLICT_STATUS = 1003;
    public static final int MANDATORY_FIELD_STATUS = 1004;
    public static final int APPOINTMENT_CONFLICT_STATUS = 1006;
    public static final int BAD_REQUEST_STATUS = 1400;
    public static final int SERVER_ERROR_STATUS = 1500;
    public static final int OK_STATUS = 1200;
    public static final String MODIFICATION_EXCEPTION = "[1000] This object was modified on the server";
    public static final String OBJECT_NOT_FOUND_EXCEPTION = "[1001] Object not found";
    public static final String PERMISSION_EXCEPTION = "[%s] No permission";
    public static final String CONFLICT_EXCEPTION = "[%s] Conflict";
    public static final String USER_INPUT_EXCEPTION = "[%s] invalid user input";
    public static final String APPOINTMENT_CONFLICT_EXCEPTION = "[1006] Appointments Conflicted";
    public static final String MANDATORY_FIELD_EXCEPTION = "[%s] Missing field";
    public static final String BAD_REQUEST_EXCEPTION = "[1400] bad xml request";
    public static final String SERVER_ERROR_EXCEPTION = "[%s] Server Error - ";
    public static final String OK = "[1200] OK";
    public static final String INDIVIDUAL_ERROR = "[%s] [%s]";
    public static final String _contentType = "text/xml; charset=UTF-8";
    public static final String NAMESPACE = "http://www.open-xchange.org";
    public static final String PREFIX = "ox";
    protected static final String _parsePropChilds = "parsePropChilds";
    public static final Namespace NS = Namespace.getNamespace((String)"ox", (String)"http://www.open-xchange.org");
    private static final String prop = "prop";
    private static final String davUri = "DAV:";
    private static final Namespace dav = Namespace.getNamespace((String)"D", (String)"DAV:");
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(XmlServlet.class));

    public void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        this.doPropPatch(req, resp);
    }

    @Override
    public void doPropPatch(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        block8: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"PROPPATCH");
            }
            KXmlParser parser = null;
            PendingInvocations pendingInvocations = new PendingInvocations(new LinkedList(), new LastModifiedCache());
            try {
                parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                parser.setInput((InputStream)req.getInputStream(), "UTF-8");
                resp.setStatus(207);
                resp.setContentType(_contentType);
                if (parser.getEventType() == 0) {
                    parser.next();
                    if (this.isTag((XmlPullParser)parser, "multistatus", davUri)) {
                        parser.nextTag();
                        parser.require(2, davUri, "propertyupdate");
                        this.parsePropertyUpdate(req, resp, (XmlPullParser)parser, pendingInvocations);
                        this.commit((OutputStream)resp.getOutputStream(), XmlServlet.getSession(req), pendingInvocations);
                        break block8;
                    }
                    if (this.isTag((XmlPullParser)parser, "propertyupdate", davUri)) {
                        this.parsePropertyUpdate(req, resp, (XmlPullParser)parser, pendingInvocations);
                        this.commit((OutputStream)resp.getOutputStream(), XmlServlet.getSession(req), pendingInvocations);
                        break block8;
                    }
                    this.doOXError(req, resp, 400, BAD_REQUEST_EXCEPTION, (XmlPullParser)parser);
                    return;
                }
                this.doOXError(req, resp, 400, BAD_REQUEST_EXCEPTION, (XmlPullParser)parser);
                return;
            }
            catch (IOException e) {
                LOG.error((Object)"doPropPatch", (Throwable)e);
                this.doOXError(req, resp, 500, e, (XmlPullParser)parser);
            }
            catch (XmlPullParserException e) {
                LOG.error((Object)"doPropPatch", (Throwable)e);
                this.doOXError(req, resp, 500, (Exception)((Object)e), (XmlPullParser)parser);
            }
            catch (OXException e) {
                LOG.error((Object)"doPropPatch", (Throwable)e);
                this.doOXError(req, resp, 500, (Exception)((Object)e), (XmlPullParser)parser);
            }
        }
    }

    @Override
    public void doPropFind(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"PROPFIND");
        }
        Document input_doc = null;
        ServletOutputStream os = null;
        Date lastsync = null;
        int folder_id = 0;
        int object_id = 0;
        boolean bModified = true;
        boolean bDeleted = false;
        boolean bList = false;
        try {
            Session sessionObj = XmlServlet.getSession(req);
            Context ctx = ContextStorage.getStorageContext(sessionObj.getContextId());
            input_doc = this.getJDOMDocument(req);
            os = resp.getOutputStream();
            resp.setStatus(207);
            resp.setContentType(_contentType);
            boolean hasObjectId = false;
            boolean hasObjectMode = false;
            if (input_doc != null) {
                Element eObjectId;
                Element el = input_doc.getRootElement();
                Element eProp = el.getChild(prop, dav);
                if (eProp == null) {
                    this.doError(req, resp, 400, "expected element: prop");
                    return;
                }
                Element eLastSync = eProp.getChild("lastsync", Namespace.getNamespace((String)PREFIX, (String)NAMESPACE));
                Element eObjectMode = eProp.getChild("objectmode", Namespace.getNamespace((String)PREFIX, (String)NAMESPACE));
                if (eObjectMode != null) {
                    hasObjectMode = true;
                }
                if ((eObjectId = eProp.getChild("object_id", Namespace.getNamespace((String)PREFIX, (String)NAMESPACE))) != null) {
                    hasObjectId = true;
                }
                if (hasObjectMode) {
                    try {
                        if (eLastSync != null) {
                            lastsync = new Date(Long.parseLong(eLastSync.getText()));
                        }
                    }
                    catch (NumberFormatException exc) {
                        System.out.println("invalid value in element lastsync");
                    }
                    Element eFolderId = eProp.getChild("folder_id", Namespace.getNamespace((String)PREFIX, (String)NAMESPACE));
                    if (eFolderId != null) {
                        try {
                            folder_id = Integer.parseInt(eFolderId.getText());
                        }
                        catch (NumberFormatException exc) {
                            throw WebdavExceptionCode.INVALID_VALUE.create(exc, "folder_id", eFolderId.getText());
                        }
                    }
                    if (eObjectMode == null) {
                        bModified = true;
                    } else {
                        String[] value;
                        bModified = false;
                        bDeleted = false;
                        bList = false;
                        for (String element : value = eObjectMode.getText().trim().toUpperCase().split(",")) {
                            if (element.trim().equals("MODIFIED") || element.trim().equals("NEW_AND_MODIFIED")) {
                                bModified = true;
                                continue;
                            }
                            if (element.trim().equals("DELETED")) {
                                bDeleted = true;
                                continue;
                            }
                            if (element.trim().equals("LIST")) {
                                bList = true;
                                continue;
                            }
                            throw WebdavExceptionCode.INVALID_VALUE.create("objectmode", element);
                        }
                    }
                } else if (hasObjectId) {
                    try {
                        object_id = Integer.parseInt(eObjectId.getText());
                    }
                    catch (NumberFormatException exc) {
                        throw WebdavExceptionCode.INVALID_VALUE.create(exc, "object_id", eObjectId.getText());
                    }
                    Element eFolderId = eProp.getChild("folder_id", Namespace.getNamespace((String)PREFIX, (String)NAMESPACE));
                    if (eFolderId != null) {
                        try {
                            folder_id = Integer.parseInt(eFolderId.getText());
                        }
                        catch (NumberFormatException exc) {
                            throw WebdavExceptionCode.INVALID_VALUE.create(exc, "folder_id", eFolderId.getText());
                        }
                    }
                } else {
                    this.doError(req, resp, 400, "expected element: object_id or lastsync");
                    return;
                }
            }
            os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n".getBytes());
            os.write(("<D:multistatus xmlns:D=\"DAV:\" version=\"" + Version.getInstance().getVersionString() + "\" buildname=\"" + "Open-Xchange" + "\">").getBytes());
            if (hasObjectMode) {
                if (lastsync == null) {
                    lastsync = new Date(0L);
                }
                this.startWriter(sessionObj, ctx, folder_id, bModified, bDeleted, bList, lastsync, (OutputStream)resp.getOutputStream());
            } else {
                this.startWriter(sessionObj, ctx, object_id, folder_id, (OutputStream)resp.getOutputStream());
            }
            os.write("</D:multistatus>".getBytes());
            os.flush();
        }
        catch (JDOMException exc) {
            LOG.error((Object)"doPropFind", (Throwable)exc);
            this.doError(req, resp, 400, "XML ERROR");
        }
        catch (OXException exc) {
            if (exc.isGeneric(OXException.Generic.NO_PERMISSION)) {
                this.doError(req, resp, 403, exc.getMessage());
            } else if (exc.isGeneric(OXException.Generic.CONFLICT)) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)exc.getMessage(), (Throwable)exc);
                }
                this.doError(req, resp, 409, "Conflict: " + exc.getMessage());
            } else if (OXExceptionConstants.CATEGORY_PERMISSION_DENIED.equals(exc.getCategory())) {
                this.doError(req, resp, 403, exc.getMessage());
            } else if (Category.CATEGORY_CONFLICT.equals(exc.getCategory())) {
                LOG.error((Object)"doPropFind", (Throwable)exc);
                this.doError(req, resp, 409, "Conflict: " + exc.getMessage());
            } else {
                LOG.error((Object)"doPropFind", (Throwable)exc);
                this.doError(req, resp, 500, "Server Error");
            }
        }
        catch (Exception exc) {
            LOG.error((Object)"doPropFind", (Throwable)exc);
            this.doError(req, resp, 500, "Server Error");
        }
    }

    public void doError(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        this.doError(req, resp, 500, "Server Error");
    }

    public void doError(HttpServletRequest req, HttpServletResponse resp, int code, String msg) throws ServletException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("STATUS: " + msg + ": (" + code + ')'));
            }
            resp.sendError(code, msg);
            resp.setContentType("text/html");
        }
        catch (Exception exc) {
            LOG.error((Object)"doError", (Throwable)exc);
        }
    }

    private void doOXError(HttpServletRequest req, HttpServletResponse resp, int httpErrorCode, String description, XmlPullParser parser) throws ServletException {
        DataObject dataObject = new DataObject(){

            @Override
            public int getObjectID() {
                return 0;
            }
        };
        try {
            String clientId = "not found";
            while (parser.getEventType() != 1) {
                if (this.isTag(parser, "client_id", PREFIX)) {
                    clientId = parser.nextText();
                    break;
                }
                parser.next();
            }
            ServletOutputStream os = resp.getOutputStream();
            os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n".getBytes());
            os.write(("<D:multistatus xmlns:D=\"DAV:\" version=\"" + Version.getInstance().getVersionString() + "\" buildname=\"" + "Open-Xchange" + "\">").getBytes());
            os.flush();
            this.writeResponse(dataObject, httpErrorCode, description, clientId, (OutputStream)resp.getOutputStream(), new XMLOutputter());
            os.write("</D:multistatus>".getBytes());
        }
        catch (IOException e) {
            LOG.error((Object)"doOXError", (Throwable)e);
            this.doError(req, resp, httpErrorCode, description);
        }
        catch (XmlPullParserException e) {
            LOG.error((Object)"doOXError", (Throwable)e);
            this.doError(req, resp, httpErrorCode, description);
        }
    }

    private void doOXError(HttpServletRequest req, HttpServletResponse resp, int httpErrorCode, Exception exception, XmlPullParser parser) throws ServletException {
        this.doOXError(req, resp, httpErrorCode, this.createResponseErrorMessage(exception), parser);
    }

    private String createResponseErrorMessage(Exception e) {
        String message;
        int descriptionCode;
        if (e instanceof OXException) {
            OXException o = (OXException)((Object)e);
            if (o.getPrefix().equals(EnumComponent.CONTACT.getAbbreviation()) && o.getCode() == ContactExceptionCodes.INVALID_EMAIL.getNumber()) {
                descriptionCode = 1500;
                message = o.getMessage();
            } else {
                descriptionCode = 1400;
                message = o.getMessage();
            }
        } else {
            descriptionCode = 1400;
            message = e.getMessage();
        }
        return String.format(INDIVIDUAL_ERROR, descriptionCode, message);
    }

    protected void parsePropertyUpdate(HttpServletRequest req, HttpServletResponse resp, XmlPullParser parser, PendingInvocations<I> pendingInvocations) throws XmlPullParserException, IOException, OXException {
        while (parser.getEventType() != 1) {
            if (this.isTag(parser, "set", davUri)) {
                this.openSet(req, resp, parser, pendingInvocations);
                continue;
            }
            parser.next();
        }
    }

    protected void openSet(HttpServletRequest req, HttpServletResponse resp, XmlPullParser parser, PendingInvocations<I> pendingInvocations) throws XmlPullParserException, IOException, OXException {
        this.openProp(req, resp, parser, pendingInvocations);
    }

    protected void openProp(HttpServletRequest req, HttpServletResponse resp, XmlPullParser parser, PendingInvocations<I> pendingInvocations) throws XmlPullParserException, IOException, OXException {
        parser.nextTag();
        parser.require(2, davUri, prop);
        this.parsePropChilds(req, resp, parser, pendingInvocations);
        this.closeProp(parser);
    }

    protected void closeProp(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (!this.isTag(parser, prop, davUri)) {
            boolean isProp = true;
            while (isProp) {
                if (this.endTag(parser, prop, davUri) || DataParser.isEnd(parser)) {
                    isProp = false;
                    break;
                }
                parser.next();
            }
        }
        this.closeSet(parser);
    }

    protected void closeSet(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.nextTag();
        parser.require(3, davUri, "set");
    }

    public boolean isTag(XmlPullParser parser, String name, String namespace) throws XmlPullParserException {
        return parser.getEventType() == 2 && (name == null || name.equals(parser.getName()));
    }

    public boolean endTag(XmlPullParser parser, String name, String namespace) throws XmlPullParserException {
        return parser.getEventType() == 3 && (name == null || name.equals(parser.getName()));
    }

    protected void writeResponse(DataObject dataobject, int status, String message, String client_id, OutputStream os, XMLOutputter xo) throws IOException {
        this.writeResponse(dataobject, status, message, client_id, os, xo, null);
    }

    protected void writeResponse(DataObject dataobject, int status, String message, String client_id, OutputStream os, XMLOutputter xo, Appointment[] conflicts) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(message + ':' + status));
        }
        Element e_response = new Element("response", dav);
        e_response.addNamespaceDeclaration(NS);
        Element e_href = new Element("href", dav);
        e_href.addContent(Integer.toString(dataobject.getObjectID()));
        e_response.addContent((Content)e_href);
        Element e_propstat = new Element("propstat", dav);
        Element e_prop = new Element(prop, dav);
        Element e_object_id = new Element("object_id", NS);
        e_object_id.addContent(Integer.toString(dataobject.getObjectID()));
        e_prop.addContent((Content)e_object_id);
        Date lastModified = dataobject.getLastModified();
        if (lastModified != null) {
            Element eLastModified = new Element("last_modified", NS);
            eLastModified.addContent(Long.toString(lastModified.getTime()));
            e_prop.addContent((Content)eLastModified);
        }
        if (dataobject instanceof CalendarObject) {
            Element e_recurrence_id = new Element("recurrence_id", NS);
            e_recurrence_id.addContent(Integer.toString(((CalendarObject)dataobject).getRecurrenceID()));
            e_prop.addContent((Content)e_recurrence_id);
        }
        if (client_id != null && client_id.length() > 0) {
            Element e_client_id = new Element("client_id", NS);
            e_client_id.addContent(DataWriter.correctCharacterData(client_id));
            e_prop.addContent((Content)e_client_id);
        }
        e_propstat.addContent((Content)e_prop);
        Element e_status = new Element("status", "D", davUri);
        e_status.addContent(Integer.toString(status));
        e_propstat.addContent((Content)e_status);
        Element e_descr = new Element("responsedescription", "D", davUri);
        e_descr.addContent(message);
        e_propstat.addContent((Content)e_descr);
        if (conflicts != null) {
            Element eConflictItems = new Element("conflictitems", Namespace.getNamespace((String)"D", (String)davUri));
            StringBuilder textBuilder = new StringBuilder(50);
            for (Appointment conflict : conflicts) {
                Element eConflictItem = new Element("conflictitem", Namespace.getNamespace((String)"D", (String)davUri));
                if (conflict.getTitle() == null) {
                    eConflictItem.setAttribute("subject", "", NS);
                } else {
                    eConflictItem.setAttribute("subject", conflict.getTitle(), NS);
                }
                eConflictItem.setText(textBuilder.append(conflict.getStartDate().getTime()).append(',').append(conflict.getEndDate().getTime()).append(',').append(conflict.getFullTime()).toString());
                textBuilder.setLength(0);
                eConflictItems.addContent((Content)eConflictItem);
            }
            e_propstat.addContent((Content)eConflictItems);
        }
        e_response.addContent((Content)e_propstat);
        xo.output(e_response, os);
        os.flush();
    }

    private final void commit(OutputStream os, Session session, PendingInvocations<I> pendingInvocations) throws IOException, OXException {
        os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n".getBytes());
        os.write(("<D:multistatus xmlns:D=\"DAV:\" version=\"" + Version.getInstance().getVersionString() + "\" buildname=\"" + "Open-Xchange" + "\">").getBytes());
        os.flush();
        this.performActions(os, session, pendingInvocations);
        os.write("</D:multistatus>".getBytes());
    }

    protected abstract void performActions(OutputStream var1, Session var2, PendingInvocations<I> var3) throws IOException, OXException;

    protected abstract void parsePropChilds(HttpServletRequest var1, HttpServletResponse var2, XmlPullParser var3, PendingInvocations<I> var4) throws XmlPullParserException, IOException, OXException;

    protected abstract void startWriter(Session var1, Context var2, int var3, int var4, OutputStream var5) throws Exception;

    protected abstract void startWriter(Session var1, Context var2, int var3, boolean var4, boolean var5, Date var6, OutputStream var7) throws Exception;

    protected abstract void startWriter(Session var1, Context var2, int var3, boolean var4, boolean var5, boolean var6, Date var7, OutputStream var8) throws Exception;

    protected String getErrorMessage(OXException exc, String message) {
        return this.getErrorMessage(message, exc.getErrorCode());
    }

    protected String getErrorMessage(OXException exc, String message, boolean withExceptionMessage) {
        String err = this.getErrorMessage(message, exc.getErrorCode());
        if (!withExceptionMessage) {
            return err;
        }
        String excMsg = exc.getMessage();
        return new StringBuilder(err.length() + excMsg.length() + 2).append(err).append(": ").append(excMsg).toString();
    }

    protected String getErrorMessage(String message, String errorCode) {
        return String.format(message, errorCode);
    }
}

