/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.openexchange.api2.FolderSQLInterface;
import com.openexchange.api2.RdbFolderSQLInterface;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.login.Interface;
import com.openexchange.monitoring.MonitoringInfo;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.webdav.LastModifiedCache;
import com.openexchange.webdav.PendingInvocations;
import com.openexchange.webdav.QueuedAction;
import com.openexchange.webdav.WebdavExceptionCode;
import com.openexchange.webdav.xml.FolderParser;
import com.openexchange.webdav.xml.FolderWriter;
import com.openexchange.webdav.xml.XmlServlet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.jdom2.output.XMLOutputter;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class folders
extends XmlServlet<FolderSQLInterface> {
    private static final long serialVersionUID = 40888896545602450L;
    private static final String _invalidMethodError = "invalid method!";
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(folders.class));

    @Override
    protected Interface getInterface() {
        return Interface.WEBDAV_XML;
    }

    @Override
    protected boolean isServletDisabled() {
        return true;
    }

    @Override
    protected void parsePropChilds(HttpServletRequest req, HttpServletResponse resp, XmlPullParser parser, PendingInvocations<FolderSQLInterface> pendingInvocations) throws XmlPullParserException, IOException, OXException {
        Session session = folders.getSession(req);
        if (this.isTag(parser, "prop", "DAV:")) {
            parser.nextTag();
            FolderObject folderobject = new FolderObject();
            FolderParser folderparser = new FolderParser(session);
            folderparser.parse(parser, folderobject);
            int method = folderparser.getMethod();
            Date lastModified = folderobject.getLastModified();
            folderobject.removeLastModified();
            int inFolder = folderparser.getFolder();
            switch (method) {
                case 1: {
                    if (folderobject.containsObjectID()) {
                        int object_id = folderobject.getObjectID();
                        Context ctx = ContextStorage.getInstance().getContext(session.getContextId());
                        if (new OXFolderAccess(ctx).isDefaultFolder(object_id)) {
                            folderobject.removeFolderName();
                        }
                    } else {
                        folderobject.setParentFolderID(inFolder);
                    }
                    pendingInvocations.add(new QueuedFolder(folderobject, folderparser.getClientID(), method, lastModified));
                    break;
                }
                case 2: {
                    pendingInvocations.add(new QueuedFolder(folderobject, folderparser.getClientID(), method, lastModified));
                    break;
                }
                case 4: {
                    pendingInvocations.add(new QueuedFolder(folderobject, folderparser.getClientID(), method, lastModified));
                    break;
                }
                default: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)_invalidMethodError);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            parser.next();
        }
    }

    @Override
    protected void performActions(OutputStream os, Session session, PendingInvocations<FolderSQLInterface> pendingInvocations) throws IOException, OXException {
        RdbFolderSQLInterface foldersql = new RdbFolderSQLInterface(ServerSessionAdapter.valueOf(session));
        while (!pendingInvocations.isEmpty()) {
            QueuedFolder qfld = (QueuedFolder)pendingInvocations.poll();
            if (null == qfld) continue;
            qfld.setLastModifiedCache(pendingInvocations.getLastModifiedCache());
            qfld.actionPerformed(foldersql, os, session.getUserId());
        }
    }

    @Override
    protected void startWriter(Session sessionObj, Context ctx, int objectId, int folderId, OutputStream os) throws Exception {
        new FolderWriter(sessionObj, ctx).startWriter(objectId, os);
    }

    @Override
    protected void startWriter(Session sessionObj, Context ctx, int folderId, boolean modified, boolean deleted, Date lastsync, OutputStream os) throws Exception {
        this.startWriter(sessionObj, ctx, folderId, modified, deleted, false, lastsync, os);
    }

    @Override
    protected void startWriter(Session sessionObj, Context ctx, int folderId, boolean modified, boolean deleted, boolean bList, Date lastsync, OutputStream os) throws Exception {
        new FolderWriter(sessionObj, ctx).startWriter(modified, deleted, bList, lastsync, os);
    }

    @Override
    protected boolean hasModulePermission(Session sessionObj, Context ctx) {
        return UserConfigurationStorage.getInstance().getUserConfigurationSafe(sessionObj.getUserId(), ctx).hasWebDAVXML();
    }

    @Override
    protected void decrementRequests() {
        MonitoringInfo.decrementNumberOfConnections((int)2);
    }

    @Override
    protected void incrementRequests() {
        MonitoringInfo.incrementNumberOfConnections((int)2);
    }

    private final class QueuedFolder
    implements QueuedAction<FolderSQLInterface> {
        private final FolderObject folderObject;
        private final String clientId;
        private final int action;
        private final Date lastModified;
        private LastModifiedCache lastModifiedCache;

        public QueuedFolder(FolderObject folderObject, String clientId, int action, Date lastModified) {
            this.folderObject = folderObject;
            this.clientId = clientId;
            this.action = action;
            this.lastModified = lastModified;
            this.lastModifiedCache = new LastModifiedCache();
        }

        @Override
        public void actionPerformed(FolderSQLInterface foldersSQL, OutputStream os, int user) throws IOException {
            XMLOutputter xo = new XMLOutputter();
            try {
                switch (this.action) {
                    case 1: {
                        if (this.folderObject.getModule() == 4) {
                            folders.this.writeResponse(this.folderObject, 409, "[%s] invalid user input", this.clientId, os, xo);
                            return;
                        }
                        Date currentLastModified = this.lastModifiedCache.getLastModified(this.folderObject.getObjectID(), this.lastModified);
                        this.lastModifiedCache.update(this.folderObject.getObjectID(), 0, this.lastModified);
                        foldersSQL.saveFolderObject(this.folderObject, currentLastModified);
                        this.lastModifiedCache.update(this.folderObject.getObjectID(), 0, this.folderObject.getLastModified());
                        break;
                    }
                    case 2: {
                        if (this.lastModified == null) {
                            throw WebdavExceptionCode.MISSING_FIELD.create("last_modified");
                        }
                        foldersSQL.deleteFolderObject(this.folderObject, this.lastModified);
                        break;
                    }
                    case 4: {
                        if (this.lastModified == null) {
                            throw WebdavExceptionCode.MISSING_FIELD.create("last_modified");
                        }
                        foldersSQL.clearFolder(this.folderObject, this.lastModified);
                        break;
                    }
                    default: {
                        throw WebdavExceptionCode.INVALID_ACTION.create(this.action);
                    }
                }
                folders.this.writeResponse(this.folderObject, 200, "[1200] OK", this.clientId, os, xo);
            }
            catch (OXException exc) {
                exc.log(LOG);
                if (exc.isMandatory()) {
                    LOG.debug((Object)"parsePropChilds", (Throwable)exc);
                    folders.this.writeResponse(this.folderObject, 409, folders.this.getErrorMessage(exc, "[%s] Missing field"), this.clientId, os, xo);
                } else if (exc.isNoPermission()) {
                    LOG.debug((Object)"parsePropChilds", (Throwable)exc);
                    folders.this.writeResponse(this.folderObject, 403, folders.this.getErrorMessage(exc, "[%s] No permission"), this.clientId, os, xo);
                } else if (exc.isConflict()) {
                    LOG.debug((Object)"parsePropChilds", (Throwable)exc);
                    folders.this.writeResponse(this.folderObject, 409, folders.this.getErrorMessage(exc, "[%s] Conflict"), this.clientId, os, xo);
                } else if (exc.isNotFound()) {
                    LOG.debug((Object)"parsePropChilds", (Throwable)exc);
                    folders.this.writeResponse(this.folderObject, 404, "[1001] Object not found", this.clientId, os, xo);
                } else if (exc.getCategory() == Category.CATEGORY_TRUNCATED) {
                    LOG.debug((Object)"parsePropChilds", (Throwable)exc);
                    folders.this.writeResponse(this.folderObject, 409, folders.this.getErrorMessage(exc, "[%s] invalid user input"), this.clientId, os, xo);
                } else {
                    LOG.error((Object)"parsePropChilds", (Throwable)exc);
                    folders.this.writeResponse(this.folderObject, 500, folders.this.getErrorMessage(exc, "[%s] Server Error - ") + exc.toString(), this.clientId, os, xo);
                }
            }
            catch (Exception exc) {
                LOG.error((Object)"parsePropChilds", (Throwable)exc);
                folders.this.writeResponse(this.folderObject, 500, folders.this.getErrorMessage("[%s] Server Error - ", "undefinied error") + exc.toString(), this.clientId, os, xo);
            }
        }

        public void setLastModifiedCache(LastModifiedCache lastModifiedCache) {
            this.lastModifiedCache = lastModifiedCache;
        }
    }
}

