/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import java.io.IOException;

public class WebdavExistsAction
extends AbstractAction {
    private boolean tolerateLockNull = false;
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(WebdavExistsAction.class));
    private static final String NOT_FOUND = "There is nothing here, sorry.";

    @Override
    public void perform(WebdavRequest req, WebdavResponse res) throws WebdavProtocolException {
        if (!req.getResource().exists()) {
            this.notFound(req, res);
        }
        if (req.getResource().isLockNull() && !this.tolerateLockNull) {
            this.notFound(req, res);
        }
        this.yield(req, res);
    }

    private void notFound(WebdavRequest req, WebdavResponse res) throws WebdavProtocolException {
        try {
            res.sendString(NOT_FOUND);
        }
        catch (IOException e) {
            LOG.debug((Object)"Client gone?", (Throwable)e);
        }
        throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 404);
    }

    public void setTolerateLockNull(boolean b) {
        this.tolerateLockNull = b;
    }
}

