/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2445;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.valuedefinitions.rfc2445.DateTimeValueDefinition;
import com.openexchange.tools.versit.values.DateTimeValue;
import java.io.IOException;

public class UTCDateTimeValueDefinition
extends DateTimeValueDefinition {
    public static final ValueDefinition Default = new UTCDateTimeValueDefinition();

    @Override
    public Object createValue(StringScanner s, Property property) throws IOException {
        DateTimeValue retval = (DateTimeValue)super.createValue(s, property);
        if (!retval.isUTC) {
            throw new VersitException(s, "UTC time expected");
        }
        return retval;
    }

    @Override
    public String writeValue(Object value) {
        DateTimeValue date = (DateTimeValue)value;
        date.isUTC = true;
        return this.writeDate(date) + 'T' + this.writeTime(date);
    }
}

