/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit;

import com.openexchange.java.StringAllocator;
import com.openexchange.tools.versit.Scanner;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringScanner
extends Scanner {
    private final String Text;
    private String UpcaseText;
    private int pos;
    private final Scanner scanner;

    public StringScanner(Scanner s, String text) {
        this.scanner = s;
        this.Line = s.getLine();
        this.Column = s.getColumn();
        this.Text = text;
        this.peek = this.readImpl();
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    @Override
    protected int readImpl() {
        if (this.pos < this.Text.length()) {
            ++this.Column;
            return this.Text.charAt(this.pos++);
        }
        return -1;
    }

    public boolean match(String text) {
        if (this.peek == -1) {
            return text.length() == 0;
        }
        boolean retval = this.Text.startsWith(text, this.pos - 1);
        if (retval) {
            this.pos += text.length() - 1;
            this.peek = this.readImpl();
        }
        return retval;
    }

    public boolean imatch(String text) {
        boolean retval;
        if (this.peek == -1) {
            return text.length() == 0;
        }
        if (this.UpcaseText == null) {
            this.UpcaseText = this.Text.toUpperCase(Locale.ENGLISH);
        }
        if (retval = this.UpcaseText.startsWith(text.toUpperCase(Locale.ENGLISH), this.pos - 1)) {
            this.pos += text.length() - 1;
            this.peek = this.readImpl();
        }
        return retval;
    }

    public String regex(Pattern pattern) {
        if (this.peek == -1) {
            return null;
        }
        String rest = this.Text.substring(this.pos - 1, this.Text.length());
        Matcher m = pattern.matcher(rest);
        if (!m.lookingAt()) {
            return null;
        }
        String retval = this.Text.substring(this.pos - 1, this.pos - 1 + m.end());
        this.pos += m.end() - 1;
        this.peek = this.readImpl();
        return retval;
    }

    public String getRest() {
        if (this.peek < 0) {
            return "";
        }
        int start = this.pos - 1;
        this.pos = this.Text.length();
        this.peek = -1;
        return this.unescape(this.Text.substring(start));
    }

    private String unescape(String substring) {
        boolean escape = false;
        int length = substring.length();
        StringAllocator b = new StringAllocator(length);
        block3: for (int i = 0; i < length; ++i) {
            char c = substring.charAt(i);
            switch (c) {
                case '\\': {
                    if (escape) {
                        b.append('\\');
                        escape = false;
                        continue block3;
                    }
                    escape = true;
                    continue block3;
                }
                default: {
                    b.append(c);
                    escape = false;
                }
            }
        }
        return b.toString();
    }

    public int length() {
        return this.Text.length();
    }
}

