/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.update;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ForeignKeyOld {
    private String sourceTable;
    private String targetTable;
    private String sourceColumn;
    private String targetColumn;
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ForeignKeyOld> getForeignKeys(Connection con, String sourceTable) throws SQLException {
        ResultSet rs = null;
        ArrayList<ForeignKeyOld> list = new ArrayList<ForeignKeyOld>();
        try {
            DatabaseMetaData dbMetaData = con.getMetaData();
            rs = dbMetaData.getImportedKeys(null, null, sourceTable);
            while (rs.next()) {
                ForeignKeyOld key = new ForeignKeyOld();
                String sourceColumn = rs.getString("FKCOLUMN_NAME");
                String targetTable = rs.getString("PKTABLE_NAME");
                String targetColumn = rs.getString("PKCOLUMN_NAME");
                String name = rs.getString("FK_NAME");
                key.setSourceTable(sourceTable);
                key.setSourceColumn(sourceColumn);
                key.setTargetTable(targetTable);
                key.setTargetColumn(targetColumn);
                key.setName(name);
                list.add(key);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return list;
    }

    public ForeignKeyOld() {
    }

    public ForeignKeyOld(String sourceTable, String sourceColumn, String targetTable, String targetColumn) {
        this.sourceTable = sourceTable;
        this.targetTable = targetTable;
        this.sourceColumn = sourceColumn;
        this.targetColumn = targetColumn;
    }

    private void setTargetColumn(String targetColumn) {
        this.targetColumn = targetColumn;
    }

    private void setSourceColumn(String sourceColumn) {
        this.sourceColumn = sourceColumn;
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public String getSourceColumn() {
        return this.sourceColumn;
    }

    public String getTargetColumn() {
        return this.targetColumn;
    }

    public void setSourceTable(String sourceTable) {
        this.sourceTable = sourceTable;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void loadName(Connection con) throws SQLException {
        List<ForeignKeyOld> keys = ForeignKeyOld.getForeignKeys(con, this.sourceTable);
        for (ForeignKeyOld key : keys) {
            if (!key.equals(this)) continue;
            this.name = key.getName();
            return;
        }
        throw new SQLException("Foreign key not in database: " + this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ForeignKeyOld)) {
            return false;
        }
        ForeignKeyOld that = (ForeignKeyOld)o;
        if (this.sourceColumn != null ? !this.sourceColumn.equals(that.sourceColumn) : that.sourceColumn != null) {
            return false;
        }
        if (this.sourceTable != null ? !this.sourceTable.equals(that.sourceTable) : that.sourceTable != null) {
            return false;
        }
        if (this.targetColumn != null ? !this.targetColumn.equals(that.targetColumn) : that.targetColumn != null) {
            return false;
        }
        return !(this.targetTable != null ? !this.targetTable.equals(that.targetTable) : that.targetTable != null);
    }

    public int hashCode() {
        int result = this.sourceTable != null ? this.sourceTable.hashCode() : 0;
        result = 31 * result + (this.targetTable != null ? this.targetTable.hashCode() : 0);
        result = 31 * result + (this.sourceColumn != null ? this.sourceColumn.hashCode() : 0);
        result = 31 * result + (this.targetColumn != null ? this.targetColumn.hashCode() : 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(Connection con) throws SQLException {
        if (this.name == null) {
            this.loadName(con);
        }
        Statement stmt = null;
        try {
            stmt = con.prepareStatement("ALTER TABLE " + this.sourceTable + " DROP FOREIGN KEY " + this.name);
            stmt.executeUpdate();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public String toString() {
        String myName = this.name;
        if (myName == null) {
            myName = "unnamed";
        }
        return "FK: (" + this.name + ") " + this.sourceTable + "." + this.sourceColumn + " -> " + this.targetTable + "." + this.targetColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Connection con) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.prepareStatement("ALTER TABLE " + this.sourceTable + " ADD FOREIGN KEY (`" + this.sourceColumn + "`) REFERENCES `" + this.targetTable + "` (`" + this.targetColumn + "`)");
            stmt.executeUpdate();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public void createIfNotExists(Connection con) throws SQLException {
        List<ForeignKeyOld> keys = ForeignKeyOld.getForeignKeys(con, this.sourceTable);
        if (!keys.contains(this)) {
            this.create(con);
        }
    }
}

