/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.osgi.framework.Bundle;

public final class BundleProxyClassLoader
extends ClassLoader {
    private final Bundle bundle;
    private final ClassLoader parent;

    public BundleProxyClassLoader(Bundle bundle) {
        if (null == bundle) {
            throw new IllegalArgumentException("bundle");
        }
        this.bundle = bundle;
        this.parent = null;
    }

    public BundleProxyClassLoader(Bundle bundle, ClassLoader parent) {
        super(parent);
        if (null == bundle) {
            throw new IllegalArgumentException("bundle");
        }
        this.parent = parent;
        this.bundle = bundle;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        return this.bundle.loadClass(name);
    }

    @Override
    public URL findResource(String name) {
        return this.bundle.getResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return this.bundle.getResources(name);
    }

    @Override
    public URL getResource(String name) {
        return this.parent == null ? this.findResource(name) : super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.bundle.getResources(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        Class<?> clazz2 = clazz = this.parent == null ? this.findClass(name) : super.loadClass(name, false);
        if (resolve) {
            super.resolveClass(clazz);
        }
        return clazz;
    }
}

