/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.resource.Resource;
import com.openexchange.resource.ResourceExceptionCode;
import com.openexchange.resource.internal.ResourceTools;
import com.openexchange.resource.storage.ResourceStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

public final class ResourceUpdate {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ResourceUpdate.class));
    private final User user;
    private final Context ctx;
    private final Resource resource;
    private final ResourceStorage storage;
    private final Date clientLastModified;
    private transient Resource orig;

    ResourceUpdate(User user, Context ctx, Resource resource, Date clientLastModified) {
        this.user = user;
        this.ctx = ctx;
        this.resource = resource;
        this.clientLastModified = clientLastModified;
        this.storage = ResourceStorage.getInstance();
    }

    private Resource getOrig() throws OXException {
        if (null == this.orig) {
            this.orig = this.storage.getResource(this.resource.getIdentifier(), this.ctx);
        }
        return this.orig;
    }

    void perform() throws OXException {
        this.allow();
        this.check();
        this.update();
        this.propagate();
    }

    private void allow() throws OXException {
        if (!UserConfigurationStorage.getInstance().getUserConfiguration(this.user.getId(), this.ctx).isEditResource()) {
            throw ResourceExceptionCode.PERMISSION.create(this.ctx.getContextId());
        }
    }

    private void check() throws OXException {
        Resource[] resources;
        if (null == this.resource) {
            throw ResourceExceptionCode.NULL.create();
        }
        if (!this.resource.isIdentifierSet() || -1 == this.resource.getIdentifier()) {
            throw ResourceExceptionCode.MANDATORY_FIELD.create();
        }
        this.getOrig();
        if (this.clientLastModified != null && this.clientLastModified.getTime() < this.getOrig().getLastModified().getTime()) {
            throw ResourceExceptionCode.CONCURRENT_MODIFICATION.create();
        }
        if (this.resource.isSimpleNameSet()) {
            if (ResourceUpdate.isEmpty(this.resource.getSimpleName())) {
                throw ResourceExceptionCode.MANDATORY_FIELD.create();
            }
            if (!ResourceTools.validateResourceIdentifier(this.resource.getSimpleName())) {
                throw ResourceExceptionCode.INVALID_RESOURCE_IDENTIFIER.create(this.resource.getSimpleName());
            }
            resources = this.storage.searchResources(this.resource.getSimpleName(), this.ctx);
            if (resources.length > 1) {
                throw ResourceExceptionCode.RESOURCE_CONFLICT.create(this.resource.getSimpleName());
            }
            if (resources.length == 1 && resources[0].getIdentifier() != this.resource.getIdentifier()) {
                throw ResourceExceptionCode.RESOURCE_CONFLICT.create(this.resource.getSimpleName());
            }
        }
        if (this.resource.isMailSet()) {
            if (ResourceUpdate.isEmpty(this.resource.getMail())) {
                throw ResourceExceptionCode.MANDATORY_FIELD.create();
            }
            if (!ResourceTools.validateResourceEmail(this.resource.getMail())) {
                throw ResourceExceptionCode.INVALID_RESOURCE_MAIL.create(this.resource.getMail());
            }
            resources = this.storage.searchResourcesByMail(this.resource.getMail(), this.ctx);
            if (resources.length > 1) {
                throw ResourceExceptionCode.RESOURCE_CONFLICT_MAIL.create(this.resource.getMail());
            }
            if (resources.length == 1 && resources[0].getIdentifier() != this.resource.getIdentifier()) {
                throw ResourceExceptionCode.RESOURCE_CONFLICT_MAIL.create(this.resource.getMail());
            }
        }
    }

    private void update() throws OXException {
        Connection con = DBPool.pickupWriteable(this.ctx);
        try {
            con.setAutoCommit(false);
            this.update(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw ResourceExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            try {
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                LOG.error((Object)"Problem setting autocommit to true.", (Throwable)e);
            }
            DBPool.closeWriterSilent(this.ctx, con);
        }
    }

    private void propagate() {
    }

    void update(Connection con) throws OXException {
        this.resource.fill(this.getOrig());
        this.storage.updateResource(this.ctx, con, this.resource);
    }

    private static boolean isEmpty(String s) {
        char[] chars;
        if (null == s || s.length() == 0) {
            return true;
        }
        for (char c : chars = s.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }
}

