/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteRegistry;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.resource.Resource;
import com.openexchange.resource.ResourceExceptionCode;
import com.openexchange.resource.storage.ResourceStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

public final class ResourceDelete {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ResourceDelete.class));
    private final User user;
    private final Context ctx;
    private final Resource resource;
    private final ResourceStorage storage;
    private final Date clientLastModified;
    private transient Resource orig;

    ResourceDelete(User user, Context ctx, Resource resource, Date clientLastModified) {
        this.user = user;
        this.ctx = ctx;
        this.resource = resource;
        this.clientLastModified = clientLastModified;
        this.storage = ResourceStorage.getInstance();
    }

    private Resource getOrig() throws OXException {
        if (null == this.orig) {
            this.orig = this.storage.getResource(this.resource.getIdentifier(), this.ctx);
        }
        return this.orig;
    }

    void perform() throws OXException {
        this.allow();
        this.check();
        this.delete();
        this.propagate();
    }

    private void allow() throws OXException {
        if (!UserConfigurationStorage.getInstance().getUserConfiguration(this.user.getId(), this.ctx).isEditResource()) {
            throw ResourceExceptionCode.PERMISSION.create(this.ctx.getContextId());
        }
    }

    private void check() throws OXException {
        if (null == this.resource) {
            throw ResourceExceptionCode.NULL.create();
        }
        if (!this.resource.isIdentifierSet() || -1 == this.resource.getIdentifier()) {
            throw ResourceExceptionCode.MANDATORY_FIELD.create();
        }
        this.getOrig();
        if (this.clientLastModified != null && this.clientLastModified.getTime() < this.getOrig().getLastModified().getTime()) {
            throw ResourceExceptionCode.CONCURRENT_MODIFICATION.create();
        }
    }

    private void delete() throws OXException {
        Connection con = DBPool.pickupWriteable(this.ctx);
        try {
            con.setAutoCommit(false);
            this.propagateDelete(con);
            this.delete(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw ResourceExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            try {
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                LOG.error((Object)"Problem setting autocommit to true.", (Throwable)e);
            }
            DBPool.closeWriterSilent(this.ctx, con);
        }
    }

    private void propagateDelete(Connection con) throws OXException {
        DeleteEvent event = new DeleteEvent((Object)this.getOrig(), this.resource.getIdentifier(), 3, this.ctx);
        DeleteRegistry.getInstance().fireDeleteEvent(event, con, con);
    }

    private void propagate() {
    }

    void delete(Connection con) throws OXException {
        this.storage.deleteResource(this.ctx, con, this.resource);
        Resource orig = this.getOrig();
        this.resource.setAvailable(orig.isAvailable());
        this.resource.setDescription(orig.getDescription());
        this.resource.setDisplayName(orig.getDisplayName());
        this.resource.setIdentifier(orig.getIdentifier());
        this.resource.setMail(orig.getMail());
        this.resource.setSimpleName(orig.getSimpleName());
        this.resource.setLastModified(System.currentTimeMillis());
        this.storage.insertResource(this.ctx, con, this.resource, ResourceStorage.StorageType.DELETED);
    }
}

