/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.pooling;

import com.openexchange.pooling.PooledData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class PoolImplData<T> {
    private final List<PooledData<T>> idle = new ArrayList<PooledData<T>>();
    private final Map<T, PooledData<T>> active = new HashMap<T, PooledData<T>>();
    private final Map<Thread, PooledData<T>> activeByThread = new HashMap<Thread, PooledData<T>>();
    private int creating = 0;

    PoolImplData() {
    }

    PooledData<T> popIdle() {
        PooledData<T> retval;
        int pos = this.idle.size();
        if (0 == pos) {
            retval = null;
        } else {
            retval = this.idle.remove(pos - 1);
            this.active.put(retval.getPooled(), retval);
        }
        return retval;
    }

    PooledData<T> pushIdle(T pooled) {
        PooledData<T> retval = this.active.remove(pooled);
        if (null != retval) {
            this.idle.add(retval);
        }
        return retval;
    }

    void addActive(PooledData<T> newActive) {
        this.active.put(newActive.getPooled(), newActive);
    }

    PooledData<T> getActive(T pooled) {
        return this.active.get(pooled);
    }

    Iterator<PooledData<T>> listActive() {
        return this.active.values().iterator();
    }

    boolean removeActive(PooledData<T> toRemove) {
        return toRemove.equals(this.active.remove(toRemove.getPooled()));
    }

    void addCreating() {
        ++this.creating;
    }

    void removeCreating() {
        --this.creating;
    }

    int getCreating() {
        return this.creating;
    }

    int numActive() {
        return this.active.size() + this.creating;
    }

    boolean isActiveEmpty() {
        return this.active.isEmpty() && this.creating == 0;
    }

    void addIdle(PooledData<T> newIdle) {
        this.idle.add(newIdle);
    }

    PooledData<T> getIdle(int index) {
        return this.idle.get(index);
    }

    void removeIdle(int index) {
        this.idle.remove(index);
    }

    int numIdle() {
        return this.idle.size();
    }

    boolean isIdleEmpty() {
        return this.idle.isEmpty();
    }

    void addByThread(PooledData<T> toCheck) {
        this.activeByThread.put(toCheck.getThread(), toCheck);
    }

    PooledData<T> getByThread(Thread thread) {
        return this.activeByThread.get(thread);
    }

    void removeByThread(PooledData<T> toCheck) {
        this.activeByThread.remove(toCheck.getThread());
    }
}

