/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum MailAccountExceptionCodes implements OXExceptionCode
{
    UNEXPECTED_ERROR("Unexpected error: %1$s.", Category.CATEGORY_ERROR, 1),
    NOT_FOUND("Cannot find mail account with identifier %1$s for user %2$s in context %3$s.", Category.CATEGORY_ERROR, 2),
    CONFLICT("Found two mail accounts with same identifier %1$s for user %2$s in context %3$s.", Category.CATEGORY_ERROR, 3),
    SQL_ERROR("A SQL error occurred: %1$s.", Category.CATEGORY_ERROR, 4),
    UNKNOWN_HOST_ERROR("A host could not be resolved: %1$s.", Category.CATEGORY_ERROR, 5),
    NO_DEFAULT_DELETE("Denied deletion of default mail account of user %1$s in context %2$s.", Category.CATEGORY_PERMISSION_DENIED, 6),
    NO_DEFAULT_UPDATE("Denied update of default mail account of user %1$s in context %2$s.", Category.CATEGORY_PERMISSION_DENIED, 7),
    NO_DUPLICATE_DEFAULT("No duplicate default account allowed.", Category.CATEGORY_ERROR, 8),
    PASSWORD_ENCRYPTION_FAILED("Password encryption failed for login %1$s on server %2$s (user=%3$s, context=%4$s).", Category.CATEGORY_ERROR, 9),
    PASSWORD_DECRYPTION_FAILED("Password decryption failed for login %1$s on server %2$s (user=%3$s, context=%4$s).", Category.CATEGORY_ERROR, 10),
    DUPLICATE_UNIFIED_INBOX_ACCOUNT("The Unified Mail account already exists for user %1$s in context %2$s.", Category.CATEGORY_ERROR, 11),
    CREATION_FAILED("Mail account creation failed.", Category.CATEGORY_ERROR, 12),
    VALIDATION_FAILED("Mail account validation failed.", Category.CATEGORY_ERROR, 13),
    NOT_ENABLED("Multiple mail accounts not enabled for user %1$s in context %2$s.", Category.CATEGORY_PERMISSION_DENIED, 14),
    CONFLICT_ADDR("Found two mail accounts with same E-Mail address %1$s for user %2$s in context %3$s.", Category.CATEGORY_USER_INPUT, 15),
    INVALID_NAME("Invalid mail account name: %1$s", Category.CATEGORY_USER_INPUT, 16),
    DUPLICATE_MAIL_ACCOUNT("Duplicate mail account for user %1$s in context %2$s.", Category.CATEGORY_USER_INPUT, 17),
    DUPLICATE_TRANSPORT_ACCOUNT("Duplicate transport account for user %1$s in context %2$s.", Category.CATEGORY_USER_INPUT, 17),
    URI_PARSE_FAILED("Unable to parse mail server URI \"%1$s\".", Category.CATEGORY_ERROR, 18),
    INVALID_HOST_NAME("Invalid host name: %1$s", Category.CATEGORY_USER_INPUT, 19);

    private static final String PREFIX = "ACC";
    private final String message;
    private final Category category;
    private final int number;

    public static boolean hasPrefix(OXException e) {
        if (null == e) {
            return false;
        }
        return PREFIX.equals(e.getPrefix());
    }

    private MailAccountExceptionCodes(String message, Category category, int number) {
        this.message = message;
        this.category = category;
        this.number = number;
    }

    public String getPrefix() {
        return PREFIX;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.number;
    }

    public String getHelp() {
        return null;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

