/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.MessagingException;

public final class HeaderTerm
extends SearchTerm<String[]> {
    private static final long serialVersionUID = -167353933722555256L;
    private final String[] hdr;

    public HeaderTerm(String headerName, String headerValue) {
        this.hdr = new String[]{headerName, headerValue};
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String[] getPattern() {
        return this.hdr;
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.HEADERS);
    }

    @Override
    public boolean matches(MailMessage mailMessage) {
        String val = mailMessage.getHeader(this.hdr[0], ", ");
        if (val == null) {
            return this.hdr[1] == null;
        }
        if (this.containsWildcard()) {
            return HeaderTerm.toRegex(this.hdr[1]).matcher(val).find();
        }
        return val.toLowerCase(Locale.ENGLISH).contains(this.hdr[1].toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        String[] val;
        try {
            val = msg.getHeader(this.hdr[0]);
        }
        catch (MessagingException e) {
            Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(HeaderTerm.class)).warn((Object)"Error during search.", (Throwable)e);
            return false;
        }
        if ((val == null || val.length == 0) && this.hdr[1] == null) {
            return true;
        }
        if (this.containsWildcard()) {
            Pattern p = HeaderTerm.toRegex(this.hdr[1]);
            boolean found = false;
            for (int i = 0; i < val.length && !found; ++i) {
                found = p.matcher(val[i]).find();
            }
            return found;
        }
        boolean found = false;
        for (int i = 0; i < val.length && !found; ++i) {
            found = val[i].toLowerCase(Locale.ENGLISH).contains(this.hdr[1].toLowerCase(Locale.ENGLISH));
        }
        return found;
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        return new javax.mail.search.HeaderTerm(this.hdr[0], this.hdr[1]);
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return new javax.mail.search.HeaderTerm(this.hdr[0], HeaderTerm.getNonWildcardPart(this.hdr[1]));
    }

    @Override
    public boolean isAscii() {
        return HeaderTerm.isAscii(this.hdr[1]);
    }

    @Override
    public boolean containsWildcard() {
        return null == this.hdr || null == this.hdr[1] ? false : this.hdr[1].indexOf(42) >= 0 || this.hdr[1].indexOf(63) >= 0;
    }
}

