/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.converters;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailFields;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.ExtendedMimeMessage;
import com.openexchange.mail.mime.FullnameFolder;
import com.openexchange.mail.mime.HeaderCollection;
import com.openexchange.mail.mime.ManagedMimeMessage;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.PlainTextAddress;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.DataHandlerWrapper;
import com.openexchange.mail.mime.converters.HeaderContentHandler;
import com.openexchange.mail.mime.converters.HeaderOutputStream;
import com.openexchange.mail.mime.dataobjects.MimeMailMessage;
import com.openexchange.mail.mime.dataobjects.MimeMailPart;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.pop3.POP3Folder;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.UIDFolder;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.apache.commons.logging.Log;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.MimeConfig;

public final class MimeMessageConverter {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MimeMessageConverter.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final EnumSet<MailField> ENUM_SET_FULL = EnumSet.complementOf(EnumSet.of(MailField.BODY, MailField.FULL, MailField.ACCOUNT_NAME));
    private static final String STR_EMPTY = "";
    public static final int BEHAVIOR_CLONE = 1;
    public static final int BEHAVIOR_STREAM2FILE = 2;
    private static final String X_ORIGINAL_HEADERS = "x-original-headers";
    private static final EnumMap<MailField, MailMessageFieldFiller> FILLER_MAP_EXT = new EnumMap(MailField.class);
    private static final EnumMap<MailField, ExistenceChecker> CHECKER_MAP;
    private static final EnumMap<MailField, MailMessageFieldFiller> FILLER_MAP;
    private static final String MULTI_PRIMTYPE = "multipart/";
    private static final String MULTI_SUBTYPE_MIXED = "MIXED";
    private static final String ENC_BASE64 = "base64";
    private static final String[] EMPTY_STRS;
    private static final int DEFAULT_MESSAGE_SIZE = 8192;
    private static volatile Boolean enableMime4j;
    private static final Pattern PATTERN_PARSE_HEADER;

    private MimeMessageConverter() {
    }

    public static Part convertMailPart(MailPart mailPart) throws OXException {
        try {
            if (mailPart instanceof MailMessage) {
                return MimeMessageConverter.convertMailMessage((MailMessage)mailPart);
            }
            int size = (int)mailPart.getSize();
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(size <= 0 ? 8192 : size);
            mailPart.writeTo((OutputStream)out);
            return new MimeBodyPart((InputStream)new UnsynchronizedByteArrayInputStream(out.toByteArray()));
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
    }

    public static Message[] convertMailMessages(MailMessage[] mails) throws OXException {
        return MimeMessageConverter.convertMailMessages(mails, true);
    }

    public static Message[] convertMailMessages(MailMessage[] mails, boolean clone) throws OXException {
        if (null == mails) {
            return null;
        }
        Message[] retval = new Message[mails.length];
        for (int i = 0; i < retval.length; ++i) {
            if (null == mails[i]) continue;
            retval[i] = MimeMessageConverter.convertMailMessage(mails[i], clone);
        }
        return retval;
    }

    public static Message[] convertMailMessages(MailMessage[] mails, int behavior) throws OXException {
        if (null == mails) {
            return null;
        }
        Message[] retval = new Message[mails.length];
        for (int i = 0; i < retval.length; ++i) {
            if (null == mails[i]) continue;
            retval[i] = MimeMessageConverter.convertMailMessage(mails[i], behavior);
        }
        return retval;
    }

    public static Message convertMailMessage(MailMessage mail) throws OXException {
        return MimeMessageConverter.convertMailMessage(mail, true);
    }

    public static Message convertMailMessage(MailMessage mail, boolean clone) throws OXException {
        return MimeMessageConverter.convertMailMessage(mail, clone ? 1 : 0);
    }

    public static Message convertMailMessage(MailMessage mail, int behavior) throws OXException {
        if (mail instanceof ComposedMailMessage) {
            return MimeMessageConverter.convertComposedMailMessage((ComposedMailMessage)mail);
        }
        try {
            ManagedFileManagement fileManagement;
            MimeMessage mimeMessage;
            boolean stream2file;
            int size = (int)mail.getSize();
            boolean clone = (behavior & 1) > 0;
            boolean bl = stream2file = (behavior & 2) > 0;
            if (!clone && mail instanceof MimeMailMessage) {
                mimeMessage = ((MimeMailMessage)mail).getMimeMessage();
            } else if (!stream2file || null == (fileManagement = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class))) {
                UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(size <= 0 ? 8192 : size);
                mail.writeTo((OutputStream)out);
                mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)new UnsynchronizedByteArrayInputStream(out.toByteArray()));
                mimeMessage.removeHeader(X_ORIGINAL_HEADERS);
            } else {
                File file = MimeMessageConverter.checkForFile(mail);
                if (null == file) {
                    FileOutputStream fos = null;
                    try {
                        File newTempFile = fileManagement.newTempFile();
                        fos = new FileOutputStream(newTempFile);
                        mail.writeTo(fos);
                        fos.flush();
                        fos.close();
                        fos = null;
                        file = newTempFile;
                    }
                    catch (IOException e) {
                        try {
                            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                            }
                            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
                        }
                        catch (Throwable throwable) {
                            Streams.close(fos);
                            throw throwable;
                        }
                    }
                    Streams.close((Closeable)fos);
                }
                try {
                    mimeMessage = new ManagedMimeMessage(MimeDefaultSession.getDefaultSession(), file);
                    mimeMessage.removeHeader(X_ORIGINAL_HEADERS);
                }
                catch (IOException e) {
                    if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                        throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                    }
                    throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
                }
            }
            if (mail.containsFlags()) {
                MimeMessageConverter.parseMimeFlags(mail.getFlags(), (Message)mimeMessage);
            }
            Flags flags = null;
            if (mail.containsColorLabel()) {
                flags = new Flags();
                flags.add(MailMessage.getColorLabelStringValue(mail.getColorLabel()));
            }
            if (mail.containsUserFlags()) {
                String[] userFlags;
                if (null == flags) {
                    flags = new Flags();
                }
                for (String userFlag : userFlags = mail.getUserFlags()) {
                    flags.add(userFlag);
                }
            }
            if (null != flags) {
                mimeMessage.setFlags(flags, true);
            }
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
    }

    private static File checkForFile(MailMessage mail) {
        MimeMessage mimeMessage;
        if (mail instanceof MimeMailMessage && (mimeMessage = ((MimeMailMessage)mail).getMimeMessage()) instanceof ManagedMimeMessage) {
            return ((ManagedMimeMessage)mimeMessage).getFile();
        }
        return null;
    }

    public static Message convertComposedMailMessage(ComposedMailMessage composedMail) throws OXException {
        try {
            MimeMessage mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession());
            MimeMessageFiller filler = new MimeMessageFiller(composedMail.getSession(), composedMail.getContext());
            filler.setAccountId(composedMail.getAccountId());
            composedMail.setFiller(filler);
            filler.setMessageHeaders(composedMail, mimeMessage);
            filler.setCommonHeaders(mimeMessage);
            filler.fillMailBody(composedMail, mimeMessage, ComposeType.NEW);
            MimeMessageConverter.saveChanges(mimeMessage);
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static MailMessage fillComposedMailMessage(ComposedMailMessage composedMail) throws OXException {
        try {
            MimeMessage mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession());
            MimeMessageFiller filler = new MimeMessageFiller(composedMail.getSession(), composedMail.getContext());
            filler.setAccountId(composedMail.getAccountId());
            composedMail.setFiller(filler);
            filler.setMessageHeaders(composedMail, mimeMessage);
            filler.setCommonHeaders(mimeMessage);
            filler.fillMailBody(composedMail, mimeMessage, ComposeType.NEW);
            MimeMessageConverter.saveChanges(mimeMessage);
            return MimeMessageConverter.convertMessage(mimeMessage);
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static void saveChanges(MimeMessage mimeMessage, String hostName) throws OXException {
        try {
            MimeMessageConverter.saveChanges(mimeMessage);
            if (null != hostName) {
                String name = "Message-ID";
                String messageId = mimeMessage.getHeader("Message-ID", null);
                if (null != messageId) {
                    int pos = messageId.indexOf(64);
                    if (pos > 0) {
                        StringBuilder mid = new StringBuilder(messageId.substring(0, pos + 1)).append(hostName);
                        if (messageId.charAt(0) == '<') {
                            mid.append('>');
                        }
                        mimeMessage.setHeader("Message-ID", mid.toString());
                    } else {
                        mimeMessage.setHeader("Message-ID", messageId + hostName);
                    }
                }
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public static void saveChanges(MimeMessage mimeMessage) throws OXException {
        if (null == mimeMessage) {
            return;
        }
        try {
            try {
                mimeMessage.saveChanges();
            }
            catch (ParseException e) {
                MimeMessageConverter.sanitizeContentTypeHeaders((Part)mimeMessage, new ContentType());
                mimeMessage.saveChanges();
            }
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
    }

    private static void sanitizeContentTypeHeaders(Part part, ContentType sanitizer) throws OXException {
        DataHandler dh;
        try {
            dh = part.getDataHandler();
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        if (dh == null) {
            return;
        }
        try {
            Object o;
            String type = dh.getContentType();
            sanitizer.setContentType(type);
            try {
                new javax.mail.internet.ContentType(type);
            }
            catch (ParseException e) {
                String cts = sanitizer.toString(true);
                try {
                    new javax.mail.internet.ContentType(cts);
                }
                catch (ParseException pe) {
                    throw MailExceptionCode.INVALID_CONTENT_TYPE.create(e, type);
                }
                part.setDataHandler((DataHandler)new DataHandlerWrapper(dh, cts));
                part.setHeader("Content-Type", cts);
            }
            if (sanitizer.startsWith(MULTI_PRIMTYPE) && (o = dh.getContent()) instanceof MimeMultipart) {
                MimeMultipart mm = (MimeMultipart)o;
                int count = mm.getCount();
                for (int i = 0; i < count; ++i) {
                    MimeMessageConverter.sanitizeContentTypeHeaders((Part)mm.getBodyPart(i), sanitizer);
                }
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static void parseMimeFlags(int flags, Message msg) throws MessagingException {
        Flags flagsObj = new Flags();
        if ((flags & 1) > 0) {
            flagsObj.add(Flags.Flag.ANSWERED);
        }
        if ((flags & 2) > 0) {
            flagsObj.add(Flags.Flag.DELETED);
        }
        if ((flags & 4) > 0) {
            flagsObj.add(Flags.Flag.DRAFT);
        }
        if ((flags & 8) > 0) {
            flagsObj.add(Flags.Flag.FLAGGED);
        }
        if ((flags & 0x10) > 0) {
            flagsObj.add(Flags.Flag.RECENT);
        }
        if ((flags & 0x20) > 0) {
            flagsObj.add(Flags.Flag.SEEN);
        }
        if ((flags & 0x40) > 0) {
            flagsObj.add(Flags.Flag.USER);
        }
        if ((flags & 0x100) > 0) {
            flagsObj.add("$Forwarded");
        }
        if ((flags & 0x200) > 0) {
            flagsObj.add("$MDNSent");
        }
        msg.setFlags(flagsObj, true);
    }

    public static MailMessage[] convertMessages(Message[] msgs, MailField[] fields) throws OXException {
        return MimeMessageConverter.convertMessages(msgs, fields, null, false);
    }

    public static MailMessage[] convertMessages(Message[] msgs, MailField[] fields, String[] headerNames, boolean includeBody) throws OXException {
        try {
            ArrayList<MailMessageFieldFiller> tmp = new ArrayList<MailMessageFieldFiller>(Arrays.asList(MimeMessageConverter.createFieldFillers(fields)));
            if (null != headerNames) {
                for (String headerName : headerNames) {
                    tmp.add(new HeaderFieldFiller(headerName));
                }
            }
            MailMessageFieldFiller[] fillers = tmp.toArray(new MailMessageFieldFiller[tmp.size()]);
            MailMessage[] mails = new MimeMailMessage[msgs.length];
            for (int i = 0; i < mails.length; ++i) {
                if (null == msgs[i]) continue;
                mails[i] = includeBody ? new MimeMailMessage((MimeMessage)msgs[i]) : new MimeMailMessage();
                MimeMessageConverter.fillMessage(fillers, mails[i], msgs[i]);
            }
            return mails;
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
    }

    public static MailMessage[] convertMessages(Message[] msgs, Folder folder, MailField[] fields, boolean includeBody) throws OXException {
        try {
            MailMessageFieldFiller[] fillers = MimeMessageConverter.createFieldFillers(folder, fields);
            MailMessage[] mails = new MimeMailMessage[msgs.length];
            for (int i = 0; i < mails.length; ++i) {
                if (null == msgs[i]) continue;
                mails[i] = includeBody ? new MimeMailMessage((MimeMessage)msgs[i]) : new MimeMailMessage();
                MimeMessageConverter.fillMessage(fillers, mails[i], msgs[i]);
            }
            return mails;
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
    }

    private static void fillMessage(MailMessageFieldFiller[] fillers, MailMessage mailMessage, Message msg) throws OXException, MessagingException {
        for (MailMessageFieldFiller filler : fillers) {
            if (null == filler) continue;
            filler.fillField(mailMessage, msg);
        }
    }

    private static MailMessageFieldFiller[] createFieldFillers(MailField[] fields) throws OXException {
        List<MailField> list = Arrays.asList(fields);
        EnumSet<MailField> fieldSet = list.isEmpty() ? EnumSet.noneOf(MailField.class) : EnumSet.copyOf(list);
        MailField[] arr = fieldSet.contains((Object)MailField.FULL) ? ENUM_SET_FULL.toArray(new MailField[ENUM_SET_FULL.size()]) : fields;
        MailMessageFieldFiller[] fillers = new MailMessageFieldFiller[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            MailField field = arr[i];
            MailMessageFieldFiller filler = FILLER_MAP_EXT.get((Object)field);
            if (filler == null) {
                if (MailField.BODY.equals((Object)field) || MailField.FULL.equals((Object)field) || MailField.ACCOUNT_NAME.equals((Object)field)) {
                    if (DEBUG) {
                        LOG.debug((Object)("Ignoring mail field " + (Object)((Object)field)));
                    }
                    fillers[i] = null;
                    continue;
                }
                throw MailExceptionCode.INVALID_FIELD.create(field.toString());
            }
            fillers[i] = filler;
        }
        return fillers;
    }

    public static void checkFieldExistence(MailMessage[] mails, MailField[] fields) {
        if (null == mails) {
            return;
        }
        for (MailField field : fields) {
            ExistenceChecker checker = CHECKER_MAP.get((Object)field);
            if (null == checker) continue;
            checker.check(mails);
        }
    }

    private static MailMessageFieldFiller[] createFieldFillers(Folder folder, MailField[] fields) throws OXException {
        List<MailField> list = Arrays.asList(fields);
        EnumSet<MailField> fieldSet = list.isEmpty() ? EnumSet.noneOf(MailField.class) : EnumSet.copyOf(list);
        MailField[] arr = fieldSet.contains((Object)MailField.FULL) ? ENUM_SET_FULL.toArray(new MailField[ENUM_SET_FULL.size()]) : fields;
        MailMessageFieldFiller[] fillers = new MailMessageFieldFiller[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            MailField field = arr[i];
            MailMessageFieldFiller filler = FILLER_MAP.get((Object)field);
            if (filler == null) {
                if (MailField.ID.equals((Object)field)) {
                    fillers[i] = new ExtendedMailMessageFieldFiller(folder){

                        @Override
                        public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                            if (this.folder instanceof UIDFolder) {
                                mailMessage.setMailId(Long.toString(((UIDFolder)this.folder).getUID(msg)));
                            } else if (this.folder instanceof FullnameFolder) {
                                mailMessage.setMailId(((FullnameFolder)this.folder).getUID(msg));
                            } else if (this.folder instanceof POP3Folder) {
                                mailMessage.setMailId(((POP3Folder)this.folder).getUID(msg));
                            }
                        }
                    };
                    continue;
                }
                if (MailField.FOLDER_ID.equals((Object)field)) {
                    fillers[i] = new ExtendedMailMessageFieldFiller(folder){

                        @Override
                        public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                            mailMessage.setFolder(this.folder.getFullName());
                        }
                    };
                    continue;
                }
                if (MailField.BODY.equals((Object)field) || MailField.FULL.equals((Object)field) || MailField.ACCOUNT_NAME.equals((Object)field)) {
                    if (DEBUG) {
                        LOG.debug((Object)("Ignoring mail field " + (Object)((Object)field)));
                    }
                    fillers[i] = null;
                    continue;
                }
                throw MailExceptionCode.INVALID_FIELD.create(field.toString());
            }
            fillers[i] = filler;
        }
        return fillers;
    }

    public static MailMessage newMailMessage() {
        return new MimeMailMessage();
    }

    public static MailMessage convertMessage(byte[] asciiBytes) throws OXException {
        try {
            return MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)new UnsynchronizedByteArrayInputStream(asciiBytes)));
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public static MailMessage convertMessage(MimeMessage msg) throws OXException {
        return MimeMessageConverter.convertMessage(msg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MailMessage convertMessage(MimeMessage msg, boolean considerFolder) throws OXException {
        MimeMailMessage mail = new MimeMailMessage(msg);
        try {
            Folder f;
            MimeMessageConverter.parseFlags(msg.getFlags(), mail);
            if (!mail.containsColorLabel()) {
                mail.setColorLabel(0);
            }
            if (considerFolder && (f = msg.getFolder()) != null) {
                boolean openFolder;
                mail.setFolder(f.getFullName());
                boolean bl = openFolder = !f.isOpen();
                if (openFolder) {
                    f.open(1);
                }
                try {
                    if (f instanceof UIDFolder) {
                        mail.setMailId(Long.toString(((UIDFolder)f).getUID((Message)msg)));
                    } else if (f instanceof FullnameFolder) {
                        mail.setMailId(((FullnameFolder)f).getUID((Message)msg));
                    } else if (f instanceof POP3Folder) {
                        mail.setMailId(((POP3Folder)f).getUID((Message)msg));
                    }
                }
                finally {
                    if (openFolder) {
                        f.close(false);
                    }
                }
                mail.setUnreadMessages(f.getUnreadMessageCount());
            }
            MimeMessageConverter.setHeaders((Part)msg, mail);
            mail.addFrom(MimeMessageConverter.getAddressHeader("From", mail));
            mail.addTo(MimeMessageConverter.getAddressHeader("To", mail));
            mail.addCc(MimeMessageConverter.getAddressHeader("Cc", mail));
            mail.addBcc(MimeMessageConverter.getAddressHeader("Bcc", mail));
            Object tmp = mail.getHeader("Content-Type");
            if (tmp != null && ((String[])tmp).length > 0) {
                mail.setContentType(tmp[0]);
            } else {
                mail.setContentType("text/plain; charset=us-ascii");
            }
            ContentType ct = mail.getContentType();
            Object content = msg.getContent();
            try {
                mail.setHasAttachment(ct.startsWith(MULTI_PRIMTYPE) && (MULTI_SUBTYPE_MIXED.equalsIgnoreCase(ct.getSubType()) || MimeMessageUtility.hasAttachments((Multipart)content, ct.getSubType())));
            }
            catch (ClassCastException e) {
                LOG.warn((Object)new StringAllocator(256).append("Message's Content-Type indicates to be multipart/* but its content is not an instance of javax.mail.Multipart but ").append(content.getClass().getName()).append(".\nIn case if IMAP it is due to a wrong BODYSTRUCTURE returned by IMAP server.\nGoing to mark message to have (file) attachments if Content-Type matches multipart/mixed.").toString());
                mail.setHasAttachment(ct.startsWith("multipart/mixed"));
            }
            catch (MessagingException e) {
                LOG.warn((Object)new StringAllocator(256).append("Parsing message's multipart/* content to check for file attachments caused a messaging error: ").append(e.getMessage()).append(".\nGoing to mark message to have (file) attachments if Content-Type matches multipart/mixed.").toString());
                mail.setHasAttachment(ct.startsWith("multipart/mixed"));
            }
            tmp = mail.getHeader("Content-ID");
            if (tmp != null && ((String[])tmp).length > 0) {
                mail.setContentId(tmp[0]);
            } else {
                mail.setContentId(null);
            }
            tmp = mail.getHeader("Content-Disposition", null);
            if (tmp != null && ((String)tmp).length() > 0) {
                mail.setContentDisposition((String)tmp);
            } else {
                mail.setContentDisposition((String)null);
            }
            String dispNot = mail.getHeader("Disposition-Notification-To", null);
            if (dispNot == null) {
                mail.setDispositionNotification(null);
            } else {
                InternetAddress[] addresses = MimeMessageConverter.getAddressHeader(dispNot);
                mail.setDispositionNotification(null == addresses || 0 == addresses.length ? null : addresses[0]);
            }
            String msgrefStr = mail.getHeader("X-OXMsgref", null);
            if (msgrefStr == null) {
                mail.setMsgref(null);
            } else {
                mail.setMsgref(new MailPath(msgrefStr));
                mail.removeHeader("X-OXMsgref");
                try {
                    msg.removeHeader("X-OXMsgref");
                }
                catch (Exception e) {
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            mail.setFileName(MimeMessageUtility.getFileName(mail));
            String importance = mail.getFirstHeader("Importance");
            if (null != importance) {
                MimeMessageConverter.parseImportance(importance, mail);
            } else {
                MimeMessageConverter.parsePriority(mail.getFirstHeader("X-Priority"), mail);
            }
            Date receivedDate = msg.getReceivedDate();
            if (receivedDate == null) {
                mail.setReceivedDate(null);
            } else {
                mail.setReceivedDate(receivedDate);
            }
            mail.setSentDate(MimeMessageConverter.getSentDate(mail));
            try {
                mail.setSize(msg.getSize());
            }
            catch (Exception e) {
                LOG.debug((Object)"Message's size could not be obtained.", (Throwable)e);
                mail.setSize(-1L);
            }
            mail.setSubject(MimeMessageConverter.getSubject(mail));
            mail.setThreadLevel(0);
            return mail;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static MailMessage convertMessage(byte[] asciiBytes, String uid, String fullname, char separator, MailField[] fields) throws OXException {
        try {
            return MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)new UnsynchronizedByteArrayInputStream(asciiBytes)), uid, fullname, separator, fields);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public static MailMessage convertMessage(MimeMessage msg, String uid, String fullname, char separator, MailField[] fields) throws OXException {
        MailFields set = new MailFields(fields);
        if (set.contains(MailField.FULL)) {
            MailMessage mail = MimeMessageConverter.convertMessage(msg);
            mail.setMailId(uid);
            mail.setFolder(fullname);
            return mail;
        }
        try {
            MailMessageFieldFiller[] fillers = MimeMessageConverter.createFieldFillers(new FullnameFolder(fullname, separator, uid), fields);
            MimeMailMessage mail = set.contains(MailField.BODY) ? new MimeMailMessage(msg) : new MimeMailMessage();
            MimeMessageConverter.fillMessage(fillers, mail, (Message)msg);
            return mail;
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
    }

    public static MailPart convertPart(byte[] asciiBytes) throws OXException {
        try {
            return MimeMessageConverter.convertPart((Part)new MimeBodyPart((InputStream)new UnsynchronizedByteArrayInputStream(asciiBytes)));
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public static MailPart convertPart(Part part) throws OXException {
        return MimeMessageConverter.convertPart(part, true);
    }

    public static MailPart convertPart(Part part, boolean enforeSize) throws OXException {
        try {
            int size;
            String[] msgrefStr;
            String[] tmp;
            MimeMailPart mailPart = new MimeMailPart(part);
            MimeMessageConverter.setHeaders(part, mailPart);
            String[] contentTypeHdr = mailPart.getHeader("Content-Type");
            if (null != contentTypeHdr && contentTypeHdr.length > 0) {
                mailPart.setContentType(MimeMessageUtility.unfold(contentTypeHdr[0]));
            }
            if ((tmp = mailPart.getHeader("Content-ID")) != null && tmp.length > 0) {
                mailPart.setContentId(tmp[0]);
            }
            if ((tmp = mailPart.getHeader("Content-Disposition")) != null && tmp.length > 0) {
                mailPart.setContentDisposition(tmp[0]);
            }
            if ((msgrefStr = mailPart.getHeader("X-OXMsgref")) != null && msgrefStr.length > 0) {
                mailPart.setMsgref(new MailPath(msgrefStr[0]));
                mailPart.removeHeader("X-OXMsgref");
                try {
                    part.removeHeader("X-OXMsgref");
                }
                catch (Exception e) {
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                mailPart.setMsgref(null);
            }
            mailPart.setFileName(MimeMessageUtility.getFileName(mailPart));
            try {
                size = part.getSize();
            }
            catch (Exception e) {
                size = -1;
            }
            if (size == -1 && enforeSize) {
                String tansferEnc = mailPart.getHeader("Content-Transfer-Encoding", null);
                try {
                    size = MimeMessageConverter.estimateSize(part.getInputStream(), tansferEnc);
                }
                catch (IOException e) {
                    try {
                        if (part instanceof MimeBodyPart) {
                            size = MimeMessageConverter.estimateSize(((MimeBodyPart)part).getRawInputStream(), tansferEnc);
                        } else if (part instanceof MimeMessage) {
                            size = MimeMessageConverter.estimateSize(((MimeMessage)part).getRawInputStream(), tansferEnc);
                        } else {
                            LOG.warn((Object)new StringAllocator(256).append(part.getClass().getCanonicalName()).append("'s size cannot be determined").toString(), (Throwable)e);
                        }
                    }
                    catch (IOException e1) {
                        LOG.warn((Object)new StringAllocator(256).append(part.getClass().getCanonicalName()).append("'s size cannot be determined").toString(), (Throwable)e1);
                    }
                    catch (MessagingException e1) {
                        LOG.warn((Object)new StringAllocator(256).append(part.getClass().getCanonicalName()).append("'s size cannot be determined").toString(), (Throwable)e1);
                    }
                }
            }
            mailPart.setSize(size);
            return mailPart;
        }
        catch (MessagingException e) {
            throw MailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
    }

    public static Flags convertMailFlags(int flags) {
        Flags flagsObj = new Flags();
        if ((flags & 1) == 1) {
            flagsObj.add(Flags.Flag.ANSWERED);
        }
        if ((flags & 2) == 2) {
            flagsObj.add(Flags.Flag.DELETED);
        }
        if ((flags & 4) == 4) {
            flagsObj.add(Flags.Flag.DRAFT);
        }
        if ((flags & 8) == 8) {
            flagsObj.add(Flags.Flag.FLAGGED);
        }
        if ((flags & 0x10) == 16) {
            flagsObj.add(Flags.Flag.RECENT);
        }
        if ((flags & 0x20) == 32) {
            flagsObj.add(Flags.Flag.SEEN);
        }
        if ((flags & 0x40) == 64) {
            flagsObj.add(Flags.Flag.USER);
        }
        return flagsObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int estimateSize(InputStream in, String tansferEnc) throws IOException {
        try {
            if (ENC_BASE64.equalsIgnoreCase(tansferEnc)) {
                int n = (int)((double)in.available() * 0.65);
                return n;
            }
            int n = in.available();
            return n;
        }
        finally {
            Streams.close((Closeable)in);
        }
    }

    public static void parseFlags(Flags flags, MailMessage mailMessage) throws OXException {
        String[] userFlags;
        int retval = 0;
        if (flags.contains(Flags.Flag.ANSWERED)) {
            retval |= 1;
        }
        if (flags.contains(Flags.Flag.DELETED)) {
            retval |= 2;
        }
        if (flags.contains(Flags.Flag.DRAFT)) {
            retval |= 4;
        }
        if (flags.contains(Flags.Flag.FLAGGED)) {
            retval |= 8;
        }
        if (flags.contains(Flags.Flag.RECENT)) {
            retval |= 0x10;
        }
        if (flags.contains(Flags.Flag.SEEN)) {
            retval |= 0x20;
        }
        if (flags.contains(Flags.Flag.USER)) {
            retval |= 0x40;
        }
        if ((userFlags = flags.getUserFlags()) != null) {
            mailMessage.addUserFlags(EMPTY_STRS);
            for (String userFlag : userFlags) {
                if (MailMessage.isColorLabel(userFlag)) {
                    mailMessage.setColorLabel(MailMessage.getColorLabelIntValue(userFlag));
                    continue;
                }
                if ("$Forwarded".equalsIgnoreCase(userFlag)) {
                    retval |= 0x100;
                    continue;
                }
                if ("$MDNSent".equalsIgnoreCase(userFlag)) {
                    retval |= 0x200;
                    continue;
                }
                mailMessage.addUserFlag(userFlag);
            }
        }
        mailMessage.setFlags(retval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean useMime4j() {
        Boolean tmp = enableMime4j;
        if (null != tmp) return tmp;
        Class<MimeMessageConverter> clazz = MimeMessageConverter.class;
        synchronized (MimeMessageConverter.class) {
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            enableMime4j = tmp = Boolean.valueOf(null == service ? false : service.getBoolProperty("com.openexchange.mail.mime.enableMime4j", false));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private static void setHeaders(Part part, MailPart mailPart) {
        HeaderCollection headers;
        block20: {
            headers = null;
            try {
                headers = new HeaderCollection(128);
                if (MimeMessageConverter.useMime4j() && part instanceof IMAPMessage) {
                    HeaderContentHandler handler = new HeaderContentHandler(headers);
                    MimeConfig config = new MimeConfig();
                    config.setMaxLineLen(-1);
                    config.setMaxHeaderLen(-1);
                    config.setMaxHeaderCount(-1);
                    MimeStreamParser parser = new MimeStreamParser(config);
                    parser.setContentHandler((ContentHandler)handler);
                    try {
                        HeaderOutputStream out = new HeaderOutputStream();
                        part.writeTo((OutputStream)out);
                        UnsynchronizedByteArrayInputStream in = new UnsynchronizedByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                        out = null;
                        parser.parse((InputStream)in);
                        break block20;
                    }
                    catch (IOException e1) {
                        LOG.warn((Object)"Unable to parse headers. Assuming no headers...", (Throwable)e1);
                        headers = new HeaderCollection(0);
                        break block20;
                    }
                    catch (MimeException e1) {
                        if (!((Object)((Object)HeaderContentHandler.END_HEADER_EXCEPTION)).equals((Object)e1)) {
                            throw new MessagingException(e1.getMessage(), (Exception)((Object)e1));
                        }
                        break block20;
                    }
                }
                Enumeration e = part.getAllHeaders();
                while (e.hasMoreElements()) {
                    Header h = (Header)e.nextElement();
                    String value = h.getValue();
                    if (value == null || MimeMessageConverter.isEmpty(value)) {
                        headers.addHeader(h.getName(), STR_EMPTY);
                        continue;
                    }
                    headers.addHeader(h.getName(), MimeMessageUtility.unfold(value));
                }
            }
            catch (MessagingException e) {
                if (DEBUG) {
                    LOG.debug((Object)"JavaMail API failed to load part's headers. Using own routine.", (Throwable)e);
                }
                UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(8192);
                try {
                    part.writeTo((OutputStream)out);
                    headers = MimeMessageConverter.loadHeaders(new String(out.toByteArray(), Charsets.ISO_8859_1));
                }
                catch (IOException e2) {
                    LOG.warn((Object)"Unable to parse headers. Assuming no headers...", (Throwable)e2);
                    headers = new HeaderCollection(0);
                }
                catch (MessagingException e2) {
                    LOG.warn((Object)"Unable to parse headers Assuming no headers...", (Throwable)e2);
                    headers = new HeaderCollection(0);
                }
                catch (RuntimeException e2) {
                    LOG.warn((Object)"Unable to parse headers Assuming no headers...", (Throwable)e2);
                    headers = new HeaderCollection(0);
                }
            }
            catch (RuntimeException e) {
                if (DEBUG) {
                    LOG.debug((Object)"JavaMail API failed to load part's headers. Using own routine.", (Throwable)e);
                }
                UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(8192);
                try {
                    part.writeTo((OutputStream)out);
                    headers = MimeMessageConverter.loadHeaders(new String(out.toByteArray(), Charsets.ISO_8859_1));
                }
                catch (IOException e2) {
                    LOG.warn((Object)"Unable to parse headers Assuming no headers...", (Throwable)e2);
                    headers = new HeaderCollection(0);
                }
                catch (MessagingException e2) {
                    LOG.warn((Object)"Unable to parse headers Assuming no headers...", (Throwable)e2);
                    headers = new HeaderCollection(0);
                }
                catch (RuntimeException e2) {
                    LOG.warn((Object)"Unable to parse headers Assuming no headers...", (Throwable)e2);
                    headers = new HeaderCollection(0);
                }
            }
        }
        mailPart.addHeaders(headers);
    }

    public static HeaderCollection loadHeaders(InputStream inputStream) throws IOException {
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(8192);
        byte[] bbuf = new byte[8192];
        int read = -1;
        while ((read = inputStream.read(bbuf, 0, bbuf.length)) > 0) {
            out.write(bbuf, 0, read);
        }
        return MimeMessageConverter.loadHeaders(out.toByteArray());
    }

    public static HeaderCollection loadHeaders(byte[] bytes) {
        return MimeMessageConverter.loadHeaders(new String(bytes, Charsets.ISO_8859_1));
    }

    public static HeaderCollection loadHeaders(String messageSrc) {
        int i;
        int len = messageSrc.length();
        block0: for (i = 0; i < len; ++i) {
            char c = messageSrc.charAt(i);
            int prevPos = i;
            int count = 0;
            while (c == '\r' || c == '\n') {
                if (c == '\n' && ++count >= 2) {
                    i = prevPos;
                    break block0;
                }
                if (++i >= len) {
                    i = prevPos;
                    break block0;
                }
                c = messageSrc.charAt(i);
            }
        }
        Matcher m = PATTERN_PARSE_HEADER.matcher(MimeMessageUtility.unfold(messageSrc.substring(0, i)));
        HeaderCollection headers = new HeaderCollection();
        while (m.find()) {
            String value = m.group(2);
            if (value == null || MimeMessageConverter.isEmpty(value)) {
                headers.addHeader(m.group(1), STR_EMPTY);
                continue;
            }
            headers.addHeader(m.group(1), value);
        }
        return headers;
    }

    private static boolean isEmpty(String value) {
        int length = value.length();
        boolean empty = true;
        for (int i = 0; empty && i < length; ++i) {
            char c = value.charAt(i);
            empty = c == ' ' || c == '\t';
        }
        return empty;
    }

    public static String getSubject(Message message) throws MessagingException {
        String subject = MimeMessageConverter.getStringHeader("Subject", message, '\u0000');
        return null == subject ? STR_EMPTY : subject;
    }

    public static String getSubject(MailMessage message) {
        String subject = MimeMessageConverter.getStringHeader("Subject", message, '\u0000');
        return null == subject ? STR_EMPTY : subject;
    }

    public static String getStringHeader(String name, Message message) throws MessagingException {
        return MimeMessageConverter.getStringHeader(name, message, '\u0000');
    }

    public static String getStringHeader(String name, MailMessage message) {
        return MimeMessageConverter.getStringHeader(name, message, '\u0000');
    }

    public static String getStringHeader(String name, Message message, char delimiter) throws MessagingException {
        String values;
        String[] valueArr = message.getHeader(name);
        if (null == valueArr || valueArr.length == 0) {
            return null;
        }
        if ('\u0000' != delimiter && valueArr.length > 1) {
            StringAllocator sb = new StringAllocator(valueArr[0]);
            for (int i = 1; i < valueArr.length; ++i) {
                sb.append(delimiter).append(valueArr[i]);
            }
            values = sb.toString();
        } else {
            values = valueArr[0];
        }
        return MimeMessageUtility.decodeMultiEncodedHeader(values);
    }

    public static String getStringHeader(String name, MailMessage message, char delimiter) {
        String values;
        String[] valueArr = message.getHeader(name);
        if (null == valueArr || valueArr.length == 0) {
            return null;
        }
        if ('\u0000' != delimiter && valueArr.length > 1) {
            StringAllocator sb = new StringAllocator(valueArr[0]);
            for (int i = 1; i < valueArr.length; ++i) {
                sb.append(delimiter).append(valueArr[i]);
            }
            values = sb.toString();
        } else {
            values = valueArr[0];
        }
        return MimeMessageUtility.decodeMultiEncodedHeader(values);
    }

    public static InternetAddress[] getAddressHeader(String name, Message message) throws MessagingException {
        String addresses;
        String[] addressArray = message.getHeader(name);
        if (null == addressArray || addressArray.length == 0) {
            return null;
        }
        if (addressArray.length > 1) {
            StringAllocator sb = new StringAllocator(addressArray[0]);
            for (int i = 1; i < addressArray.length; ++i) {
                sb.append(',').append(addressArray[i]);
            }
            addresses = sb.toString();
        } else {
            addresses = addressArray[0];
        }
        try {
            return QuotedInternetAddress.parseHeader(addresses, true);
        }
        catch (AddressException e) {
            return MimeMessageConverter.getAddressHeaderNonStrict(addresses, addressArray);
        }
    }

    public static InternetAddress[] getAddressHeader(String name, MailMessage message) {
        String addresses;
        String[] addressArray = message.getHeader(name);
        if (null == addressArray || addressArray.length == 0) {
            return null;
        }
        if (addressArray.length > 1) {
            StringAllocator sb = new StringAllocator(addressArray[0]);
            for (int i = 1; i < addressArray.length; ++i) {
                sb.append(',').append(addressArray[i]);
            }
            addresses = sb.toString();
        } else {
            addresses = addressArray[0];
        }
        try {
            return QuotedInternetAddress.parseHeader(addresses, true);
        }
        catch (AddressException e) {
            return MimeMessageConverter.getAddressHeaderNonStrict(addresses, addressArray);
        }
    }

    private static InternetAddress[] getAddressHeaderNonStrict(String addressStrings, String[] addressArray) {
        try {
            InternetAddress[] addresses = QuotedInternetAddress.parseHeader(addressStrings, false);
            ArrayList<InternetAddress> addressList = new ArrayList<InternetAddress>(addresses.length);
            for (InternetAddress internetAddress : addresses) {
                try {
                    addressList.add(new QuotedInternetAddress(internetAddress.toString()));
                }
                catch (AddressException e) {
                    addressList.add(internetAddress);
                }
            }
            return addressList.toArray(new InternetAddress[addressList.size()]);
        }
        catch (AddressException e) {
            if (DEBUG) {
                LOG.debug((Object)new StringAllocator(128).append("Internet addresses could not be properly parsed: \"").append(e.getMessage()).append("\". Using plain addresses' string representation instead.").toString(), (Throwable)e);
            }
            return MimeMessageConverter.getAddressesOnParseError(addressArray);
        }
    }

    public static InternetAddress[] getAddressHeader(String addresses) {
        try {
            return QuotedInternetAddress.parseHeader(addresses, true);
        }
        catch (AddressException e) {
            if (DEBUG) {
                LOG.debug((Object)new StringAllocator(128).append("Internet addresses could not be properly parsed: \"").append(e.getMessage()).append("\". Using plain addresses' string representation instead.").toString(), (Throwable)e);
            }
            return new InternetAddress[]{new PlainTextAddress(addresses)};
        }
    }

    private static InternetAddress[] getAddressesOnParseError(String[] addrs) {
        InternetAddress[] retval = new InternetAddress[addrs.length];
        for (int i = 0; i < addrs.length; ++i) {
            retval[i] = new PlainTextAddress(addrs[i]);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getSentDate(MailPart part) {
        String s = part.getHeader("Date", null);
        if (s != null) {
            try {
                MailDateFormat mailDateFormat;
                MailDateFormat mailDateFormat2 = mailDateFormat = MimeMessageUtility.getDefaultMailDateFormat();
                synchronized (mailDateFormat2) {
                    return mailDateFormat.parse(s);
                }
            }
            catch (java.text.ParseException pex) {
                return null;
            }
        }
        return null;
    }

    public static void parsePriority(String priorityStr, MailMessage mailMessage) {
        mailMessage.setPriority(MimeMessageConverter.parsePriority(priorityStr));
    }

    public static void parseImportance(String importance, MailMessage mailMessage) {
        mailMessage.setPriority(MimeMessageConverter.parseImportance(importance));
    }

    public static int parsePriority(String priorityStr) {
        int priority = 3;
        if (null != priorityStr) {
            String[] tmp = priorityStr.split(" +");
            try {
                priority = Integer.parseInt(tmp[0]);
            }
            catch (NumberFormatException nfe) {
                if (DEBUG) {
                    LOG.debug((Object)("Assuming priority NORMAL due to strange X-Priority header: " + priorityStr));
                }
                priority = 3;
            }
        }
        return priority;
    }

    public static int parseImportance(String importance) {
        int priority = 3;
        if (null != importance) {
            String imp = importance.trim();
            if ("Low".equalsIgnoreCase(imp)) {
                priority = 5;
            } else if ("Medium".equalsIgnoreCase(imp) || "Normal".equalsIgnoreCase(imp)) {
                priority = 3;
            } else if ("High".equalsIgnoreCase(imp)) {
                priority = 1;
            } else {
                if (DEBUG) {
                    LOG.debug((Object)("Assuming priority NORMAL due to strange Importance header: " + importance));
                }
                priority = 3;
            }
        }
        return priority;
    }

    static {
        final Log logger = LOG;
        CHECKER_MAP = new EnumMap(MailField.class);
        final InternetAddress empty = null;
        CHECKER_MAP.put(MailField.FROM, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsFrom()) continue;
                    mailMessage.addFrom(empty);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsFrom()) continue;
                    mailMessage.addFrom(empty);
                }
            }
        });
        CHECKER_MAP.put(MailField.TO, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsTo()) continue;
                    mailMessage.addTo(empty);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsTo()) continue;
                    mailMessage.addTo(empty);
                }
            }
        });
        CHECKER_MAP.put(MailField.CC, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsCc()) continue;
                    mailMessage.addCc(empty);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsCc()) continue;
                    mailMessage.addCc(empty);
                }
            }
        });
        CHECKER_MAP.put(MailField.BCC, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsBcc()) continue;
                    mailMessage.addBcc(empty);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsBcc()) continue;
                    mailMessage.addBcc(empty);
                }
            }
        });
        CHECKER_MAP.put(MailField.SUBJECT, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsSubject()) continue;
                    mailMessage.setSubject(null);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsSubject()) continue;
                    mailMessage.setSubject(null);
                }
            }
        });
        CHECKER_MAP.put(MailField.SENT_DATE, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsSentDate()) continue;
                    mailMessage.setSentDate(null);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsSentDate()) continue;
                    mailMessage.setSentDate(null);
                }
            }
        });
        CHECKER_MAP.put(MailField.DISPOSITION_NOTIFICATION_TO, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsDispositionNotification()) continue;
                    mailMessage.setDispositionNotification(null);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsDispositionNotification()) continue;
                    mailMessage.setDispositionNotification(null);
                }
            }
        });
        CHECKER_MAP.put(MailField.PRIORITY, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsPriority()) continue;
                    mailMessage.setPriority(3);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsPriority()) continue;
                    mailMessage.setPriority(3);
                }
            }
        });
        CHECKER_MAP.put(MailField.THREAD_LEVEL, new ExistenceChecker(){

            @Override
            public void check(MailMessage ... mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsThreadLevel()) continue;
                    mailMessage.setThreadLevel(0);
                }
            }

            @Override
            public void check(Collection<MailMessage> mailMessages) {
                for (MailMessage mailMessage : mailMessages) {
                    if (null == mailMessage || mailMessage.containsThreadLevel()) continue;
                    mailMessage.setThreadLevel(0);
                }
            }
        });
        FILLER_MAP_EXT.put(MailField.HEADERS, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                String[] references;
                String[] inReplyTo;
                InternetAddress[] replyTo;
                StringBuilder sb;
                ExtendedMimeMessage extMimeMessage;
                block14: {
                    extMimeMessage = (ExtendedMimeMessage)msg;
                    mailMessage.addFrom(MimeMessageConverter.getAddressHeader("From", (Message)extMimeMessage));
                    mailMessage.addTo(MimeMessageConverter.getAddressHeader("To", (Message)extMimeMessage));
                    mailMessage.addCc(MimeMessageConverter.getAddressHeader("Cc", (Message)extMimeMessage));
                    mailMessage.addBcc(MimeMessageConverter.getAddressHeader("Bcc", (Message)extMimeMessage));
                    String dispNot = extMimeMessage.getHeader("Disposition-Notification-To", null);
                    if (dispNot == null) {
                        mailMessage.setDispositionNotification(null);
                    } else {
                        InternetAddress[] addresses = MimeMessageConverter.getAddressHeader(dispNot);
                        mailMessage.setDispositionNotification(null == addresses || 0 == addresses.length ? null : addresses[0]);
                    }
                    sb = new StringBuilder(128);
                    replyTo = null;
                    try {
                        replyTo = (InternetAddress[])extMimeMessage.getReplyTo();
                    }
                    catch (AddressException e) {
                        String addrStr = extMimeMessage.getHeader("Reply-To", null);
                        if (null == addrStr) break block14;
                        replyTo = new InternetAddress[]{new PlainTextAddress(addrStr)};
                    }
                }
                if (null != replyTo) {
                    sb.append(replyTo[0].toString());
                    for (int j = 1; j < replyTo.length; ++j) {
                        sb.append(", ").append(replyTo[j].toString());
                    }
                    mailMessage.addHeader("Reply-To", sb.toString());
                    sb.setLength(0);
                }
                mailMessage.setSubject(MimeMessageConverter.getSubject(msg));
                mailMessage.setSentDate(extMimeMessage.getSentDate());
                mailMessage.setPriority(extMimeMessage.getPriority());
                String messageId = extMimeMessage.getHeader("Message-ID", null);
                if (null != messageId) {
                    mailMessage.addHeader("Message-ID", messageId);
                }
                if (null != (inReplyTo = extMimeMessage.getHeader("In-Reply-To"))) {
                    sb.append(inReplyTo[0]);
                    for (int j = 1; j < inReplyTo.length; ++j) {
                        sb.append(", ").append(inReplyTo[j]);
                    }
                    mailMessage.addHeader("Reply-To", sb.toString());
                    sb.setLength(0);
                }
                if (null != (references = extMimeMessage.getHeader("References"))) {
                    sb.append(references[0]);
                    for (int j = 1; j < references.length; ++j) {
                        sb.append(", ").append(references[j]);
                    }
                    mailMessage.addHeader("References", sb.toString());
                    sb.setLength(0);
                }
                Enumeration e = msg.getNonMatchingHeaders(ALREADY_INSERTED_HEADERS);
                while (e.hasMoreElements()) {
                    Header h = (Header)e.nextElement();
                    try {
                        mailMessage.addHeader(h.getName(), h.getValue());
                    }
                    catch (Exception exc) {
                        logger.warn((Object)exc.getMessage(), (Throwable)exc);
                    }
                }
            }
        });
        FILLER_MAP_EXT.put(MailField.ID, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setMailId(Long.toString(((ExtendedMimeMessage)msg).getUid()));
            }
        });
        FILLER_MAP_EXT.put(MailField.FOLDER_ID, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setFolder(((ExtendedMimeMessage)msg).getFullname());
            }
        });
        FILLER_MAP_EXT.put(MailField.CONTENT_TYPE, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws OXException, MessagingException {
                try {
                    mailMessage.setContentType(((ExtendedMimeMessage)msg).getContentType());
                }
                catch (OXException e) {
                    LOG1.error((Object)e.getMessage(), (Throwable)e);
                }
                mailMessage.setHasAttachment(((ExtendedMimeMessage)msg).hasAttachment());
            }
        });
        FILLER_MAP_EXT.put(MailField.FROM, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addFrom(MimeMessageConverter.getAddressHeader("From", msg));
            }
        });
        FILLER_MAP_EXT.put(MailField.TO, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addTo(MimeMessageConverter.getAddressHeader("To", msg));
            }
        });
        FILLER_MAP_EXT.put(MailField.CC, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addCc(MimeMessageConverter.getAddressHeader("Cc", msg));
            }
        });
        FILLER_MAP_EXT.put(MailField.BCC, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addBcc(MimeMessageConverter.getAddressHeader("Bcc", msg));
            }
        });
        FILLER_MAP_EXT.put(MailField.SUBJECT, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setSubject(MimeMessageConverter.getSubject(msg));
            }
        });
        FILLER_MAP_EXT.put(MailField.SIZE, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setSize(((ExtendedMimeMessage)msg).getSize());
            }
        });
        FILLER_MAP_EXT.put(MailField.SENT_DATE, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setSentDate(((ExtendedMimeMessage)msg).getSentDate());
            }
        });
        FILLER_MAP_EXT.put(MailField.RECEIVED_DATE, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setReceivedDate(((ExtendedMimeMessage)msg).getReceivedDate());
            }
        });
        FILLER_MAP_EXT.put(MailField.FLAGS, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException, OXException {
                MimeMessageConverter.parseFlags(((ExtendedMimeMessage)msg).getFlags(), mailMessage);
            }
        });
        FILLER_MAP_EXT.put(MailField.THREAD_LEVEL, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setThreadLevel(((ExtendedMimeMessage)msg).getThreadLevel());
            }
        });
        FILLER_MAP_EXT.put(MailField.DISPOSITION_NOTIFICATION_TO, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                String[] val = ((ExtendedMimeMessage)msg).getHeader("Disposition-Notification-To");
                if (val != null && val.length > 0) {
                    String dispNot = val[0];
                    if (dispNot == null) {
                        mailMessage.setDispositionNotification(null);
                    } else {
                        InternetAddress[] addresses = MimeMessageConverter.getAddressHeader(dispNot);
                        mailMessage.setDispositionNotification(null == addresses || 0 == addresses.length ? null : addresses[0]);
                    }
                } else {
                    mailMessage.setDispositionNotification(null);
                }
            }
        });
        FILLER_MAP_EXT.put(MailField.PRIORITY, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                String[] val = ((ExtendedMimeMessage)msg).getHeader("Importance");
                if (val != null && val.length > 0) {
                    MimeMessageConverter.parseImportance(val[0], mailMessage);
                } else {
                    val = ((ExtendedMimeMessage)msg).getHeader("X-Priority");
                    if (val != null && val.length > 0) {
                        MimeMessageConverter.parsePriority(val[0], mailMessage);
                    } else {
                        mailMessage.setPriority(3);
                    }
                }
            }
        });
        FILLER_MAP_EXT.put(MailField.COLOR_LABEL, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException, OXException {
                MimeMessageConverter.parseFlags(((ExtendedMimeMessage)msg).getFlags(), mailMessage);
                if (!mailMessage.containsColorLabel()) {
                    mailMessage.setColorLabel(0);
                }
            }
        });
        FILLER_MAP = new EnumMap(MailField.class);
        logger = LOG;
        FILLER_MAP.put(MailField.HEADERS, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                String[] references;
                String[] inReplyTo;
                String[] messageId;
                InternetAddress[] replyTo;
                StringBuilder sb;
                block20: {
                    mailMessage.addFrom(MimeMessageConverter.getAddressHeader("From", msg));
                    mailMessage.addTo(MimeMessageConverter.getAddressHeader("To", msg));
                    mailMessage.addCc(MimeMessageConverter.getAddressHeader("Cc", msg));
                    mailMessage.addBcc(MimeMessageConverter.getAddressHeader("Bcc", msg));
                    String[] addrStr = msg.getHeader("Disposition-Notification-To");
                    if (null != addrStr && addrStr.length > 0) {
                        String dispNot = addrStr[0];
                        if (dispNot == null) {
                            mailMessage.setDispositionNotification(null);
                        } else {
                            InternetAddress[] addresses = MimeMessageConverter.getAddressHeader(dispNot);
                            mailMessage.setDispositionNotification(null == addresses || 0 == addresses.length ? null : addresses[0]);
                        }
                    } else {
                        mailMessage.setDispositionNotification(null);
                    }
                    sb = new StringBuilder(128);
                    replyTo = null;
                    try {
                        replyTo = (InternetAddress[])msg.getReplyTo();
                    }
                    catch (AddressException e) {
                        String[] addrStr2 = msg.getHeader("Reply-To");
                        if (null == addrStr2) break block20;
                        replyTo = new InternetAddress[]{new PlainTextAddress(addrStr2[0])};
                    }
                }
                if (null != replyTo) {
                    sb.append(replyTo[0].toString());
                    for (int j = 1; j < replyTo.length; ++j) {
                        sb.append(", ").append(replyTo[j].toString());
                    }
                    mailMessage.addHeader("Reply-To", sb.toString());
                    sb.setLength(0);
                }
                mailMessage.setSubject(MimeMessageConverter.getSubject(msg));
                mailMessage.setSentDate(msg.getSentDate());
                String[] importance = msg.getHeader("Importance");
                if (null != importance) {
                    MimeMessageConverter.parseImportance(importance[0], mailMessage);
                }
                if (!mailMessage.containsPriority()) {
                    String[] xPriority = msg.getHeader("X-Priority");
                    if (null == xPriority) {
                        mailMessage.setPriority(3);
                    } else {
                        MimeMessageConverter.parsePriority(xPriority[0], mailMessage);
                    }
                }
                if (null != (messageId = msg.getHeader("Message-ID"))) {
                    mailMessage.addHeader("Message-ID", messageId[0]);
                }
                if (null != (inReplyTo = msg.getHeader("In-Reply-To"))) {
                    sb.append(inReplyTo[0]);
                    for (int j = 1; j < inReplyTo.length; ++j) {
                        sb.append(", ").append(inReplyTo[j]);
                    }
                    mailMessage.addHeader("Reply-To", sb.toString());
                    sb.setLength(0);
                }
                if (null != (references = msg.getHeader("References"))) {
                    sb.append(references[0]);
                    for (int j = 1; j < references.length; ++j) {
                        sb.append(", ").append(references[j]);
                    }
                    mailMessage.addHeader("References", sb.toString());
                    sb.setLength(0);
                }
                Enumeration e = msg.getNonMatchingHeaders(ALREADY_INSERTED_HEADERS);
                while (e.hasMoreElements()) {
                    Header h = (Header)e.nextElement();
                    try {
                        mailMessage.addHeader(h.getName(), h.getValue());
                    }
                    catch (Exception exc) {
                        logger.warn((Object)exc.getMessage(), (Throwable)exc);
                    }
                }
            }
        });
        FILLER_MAP.put(MailField.CONTENT_TYPE, new MailMessageFieldFiller(){
            private final String multipart = "multipart";
            private final String mixed = "mixed";

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException, OXException {
                ContentType ct = null;
                try {
                    String[] tmp = msg.getHeader("Content-Type");
                    ct = tmp != null && tmp.length > 0 ? new ContentType(tmp[0]) : new ContentType("text/plain; charset=us-ascii");
                }
                catch (OXException e) {
                    LOG1.error((Object)("Invalid content type: " + msg.getContentType()), (Throwable)e);
                    try {
                        ct = new ContentType("text/plain; charset=us-ascii");
                    }
                    catch (OXException e1) {
                        LOG1.error((Object)e1.getMessage(), (Throwable)e1);
                        return;
                    }
                }
                mailMessage.setContentType(ct);
                if (msg instanceof ExtendedMimeMessage) {
                    mailMessage.setHasAttachment(((ExtendedMimeMessage)msg).hasAttachment());
                } else {
                    try {
                        mailMessage.setHasAttachment(ct.startsWith("multipart") && ("mixed".equalsIgnoreCase(ct.getSubType()) || MimeMessageUtility.hasAttachments((Multipart)msg.getContent(), ct.getSubType())));
                    }
                    catch (ClassCastException e) {
                        LOG1.warn((Object)new StringAllocator(256).append("Message's Content-Type indicates to be multipart/* but its content is not an instance of javax.mail.Multipart but ").append(e.getMessage()).append(".\nIn case if IMAP it is due to a wrong BODYSTRUCTURE returned by IMAP server.\nGoing to mark message to have (file) attachments if Content-Type matches multipart/mixed.").toString());
                        mailMessage.setHasAttachment(ct.startsWith("multipart/mixed"));
                    }
                    catch (MessagingException e) {
                        LOG1.warn((Object)new StringAllocator(256).append("Parsing message's multipart/* content to check for file attachments caused a messaging error: ").append(e.getMessage()).append(".\nGoing to mark message to have (file) attachments if Content-Type matches multipart/mixed.").toString());
                        mailMessage.setHasAttachment(ct.startsWith("multipart/mixed"));
                    }
                    catch (IOException e) {
                        if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                            throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                        }
                        throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
                    }
                }
            }
        });
        FILLER_MAP.put(MailField.FROM, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addFrom(MimeMessageConverter.getAddressHeader("From", msg));
            }
        });
        FILLER_MAP.put(MailField.TO, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addTo(MimeMessageConverter.getAddressHeader("To", msg));
            }
        });
        FILLER_MAP.put(MailField.CC, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addCc(MimeMessageConverter.getAddressHeader("Cc", msg));
            }
        });
        FILLER_MAP.put(MailField.BCC, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.addBcc(MimeMessageConverter.getAddressHeader("Bcc", msg));
            }
        });
        FILLER_MAP.put(MailField.SUBJECT, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setSubject(MimeMessageConverter.getSubject(msg));
            }
        });
        FILLER_MAP.put(MailField.SIZE, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setSize(msg.getSize());
            }
        });
        FILLER_MAP.put(MailField.SENT_DATE, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setSentDate(msg.getSentDate());
            }
        });
        FILLER_MAP.put(MailField.RECEIVED_DATE, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setReceivedDate(msg.getReceivedDate());
            }
        });
        FILLER_MAP.put(MailField.FLAGS, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException, OXException {
                MimeMessageConverter.parseFlags(msg.getFlags(), mailMessage);
            }
        });
        FILLER_MAP.put(MailField.THREAD_LEVEL, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                mailMessage.setThreadLevel(0);
            }
        });
        FILLER_MAP.put(MailField.DISPOSITION_NOTIFICATION_TO, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                String[] val = msg.getHeader("Disposition-Notification-To");
                if (val != null && val.length > 0) {
                    String dispNot = val[0];
                    if (dispNot == null) {
                        mailMessage.setDispositionNotification(null);
                    } else {
                        InternetAddress[] addresses = MimeMessageConverter.getAddressHeader(dispNot);
                        mailMessage.setDispositionNotification(null == addresses || 0 == addresses.length ? null : addresses[0]);
                    }
                } else {
                    mailMessage.setDispositionNotification(null);
                }
            }
        });
        FILLER_MAP.put(MailField.PRIORITY, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException {
                String[] val = ((ExtendedMimeMessage)msg).getHeader("Importance");
                if (val != null && val.length > 0) {
                    MimeMessageConverter.parseImportance(val[0], mailMessage);
                } else {
                    val = ((ExtendedMimeMessage)msg).getHeader("X-Priority");
                    if (val != null && val.length > 0) {
                        MimeMessageConverter.parsePriority(val[0], mailMessage);
                    } else {
                        mailMessage.setPriority(3);
                    }
                }
            }
        });
        FILLER_MAP.put(MailField.COLOR_LABEL, new MailMessageFieldFiller(){

            @Override
            public void fillField(MailMessage mailMessage, Message msg) throws MessagingException, OXException {
                MimeMessageConverter.parseFlags(msg.getFlags(), mailMessage);
                if (!mailMessage.containsColorLabel()) {
                    mailMessage.setColorLabel(0);
                }
            }
        });
        EMPTY_STRS = new String[0];
        PATTERN_PARSE_HEADER = Pattern.compile("(\\S+):\\p{Blank}?(.*)(?:(?:\r?\n)|(?:$))");
    }

    private static abstract class ExtendedMailMessageFieldFiller
    implements MailMessageFieldFiller {
        final Folder folder;

        public ExtendedMailMessageFieldFiller(Folder folder) {
            this.folder = folder;
        }
    }

    private static final class HeaderFieldFiller
    implements MailMessageFieldFiller {
        private final String headerName;

        HeaderFieldFiller(String headerName) {
            this.headerName = headerName;
        }

        @Override
        public void fillField(MailMessage mailMessage, Message msg) throws MessagingException, OXException {
            String[] header = msg.getHeader(this.headerName);
            if (null == header || 0 == header.length) {
                return;
            }
            for (String value : header) {
                mailMessage.addHeader(this.headerName, MimeMessageUtility.checkNonAscii(value));
            }
        }
    }

    private static interface MailMessageFieldFiller {
        public static final String[] NON_MATCHING_HEADERS = new String[]{"From", "To", "Cc", "Bcc", "Disposition-Notification-To", "Reply-To", "Subject", "Date", "Importance", "X-Priority", "Message-ID", "In-Reply-To", "References", "X-OX-VCard-Attached", "X-OX-Notification"};
        public static final String[] ALREADY_INSERTED_HEADERS = new String[]{"Message-ID", "Reply-To", "References"};
        public static final Log LOG1 = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailMessageFieldFiller.class));

        public void fillField(MailMessage var1, Message var2) throws MessagingException, OXException;
    }

    private static interface ExistenceChecker {
        public void check(MailMessage ... var1);

        public void check(Collection<MailMessage> var1);
    }
}

