/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.ajax.requesthandler.ETagAwareAJAXActionService;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.parse.FileMetadataParserService;
import com.openexchange.html.HtmlService;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.GET, name="get", description="Get a mail.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="The folder identifier."), @Parameter(name="id", description="Object ID of the mail which contains the attachment."), @Parameter(name="attachment", description="ID of the requested attachment OR"), @Parameter(name="cid", description="Value of header 'Content-ID' of the requested attachment"), @Parameter(name="save", description="1 overwrites the defined mimetype for this attachment to force the download dialog, otherwise 0."), @Parameter(name="filter", optional=true, description="1 to apply HTML white-list filter rules if and only if requested attachment is of MIME type text/htm* AND parameter save is set to 0.")}, responseDescription="The raw byte data of the document. The response type for the HTTP Request is set accordingly to the defined mimetype for this attachment, except the parameter save is set to 1.")
@DispatcherNotes(allowPublicSession=true)
public final class GetAttachmentAction
extends AbstractMailAction
implements ETagAwareAJAXActionService {
    public GetAttachmentAction(ServiceLookup services) {
        super(services);
    }

    @Override
    public boolean checkETag(String clientETag, AJAXRequestData request, ServerSession session) throws OXException {
        return clientETag != null && clientETag.length() != 0;
    }

    @Override
    public void setETag(String eTag, long expires, AJAXRequestResult result) throws OXException {
        result.setExpires(expires);
        result.setHeader("ETag", eTag);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        JSONObject bodyObject = (JSONObject)req.getRequest().getData();
        if (null == bodyObject) {
            return this.performGET(req);
        }
        return this.performPUT(req, bodyObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AJAXRequestResult performGET(MailRequest req) throws OXException {
        try {
            InputStream attachmentInputStream;
            MailPart mailPart;
            String folderPath = req.checkParameter("folder");
            String uid = req.checkParameter("id");
            String sequenceId = req.getParameter("attachment");
            String imageContentId = req.getParameter("cid");
            String saveParam = req.getParameter("save");
            boolean saveToDisk = saveParam == null || saveParam.length() == 0 ? false : Integer.parseInt(saveParam) > 0;
            String filterParam = req.getParameter("filter");
            boolean filter = Boolean.parseBoolean(filterParam) || "1".equals(filterParam);
            MailServletInterface mailInterface = this.getMailInterface(req);
            if (sequenceId == null && imageContentId == null) {
                throw MailExceptionCode.MISSING_PARAM.create(new StringAllocator().append("attachment").append(" | ").append("cid").toString());
            }
            if (imageContentId == null) {
                mailPart = mailInterface.getMessageAttachment(folderPath, uid, sequenceId, !saveToDisk);
                if (mailPart == null) {
                    throw MailExceptionCode.NO_ATTACHMENT_FOUND.create(sequenceId);
                }
                if (filter && !saveToDisk && mailPart.getContentType().isMimeType("text/htm*")) {
                    ContentType contentType = mailPart.getContentType();
                    String cs = contentType.containsCharsetParameter() ? contentType.getCharsetParameter() : MailProperties.getInstance().getDefaultMimeCharset();
                    String htmlContent = MessageUtility.readMailPart(mailPart, cs);
                    HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                    attachmentInputStream = new UnsynchronizedByteArrayInputStream(GetAttachmentAction.sanitizeHtml(htmlContent, htmlService).getBytes(Charsets.forName((String)cs)));
                } else {
                    attachmentInputStream = mailPart.getInputStream();
                }
            } else {
                mailPart = mailInterface.getMessageImage(folderPath, uid, imageContentId);
                if (mailPart == null) {
                    throw MailExceptionCode.NO_ATTACHMENT_FOUND.create(sequenceId);
                }
                attachmentInputStream = mailPart.getInputStream();
            }
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
            try {
                int len;
                int buflen = 65535;
                byte[] buffer = new byte[65535];
                while ((len = attachmentInputStream.read(buffer, 0, 65535)) > 0) {
                    out.write(buffer, 0, len);
                }
                out.flush();
            }
            finally {
                Streams.close((Closeable)attachmentInputStream);
            }
            req.getRequest().setFormat("file");
            ByteArrayFileHolder fileHolder = new ByteArrayFileHolder(out.toByteArray());
            out = null;
            fileHolder.setName(mailPart.getFileName());
            fileHolder.setContentType(saveToDisk ? "application/octet-stream" : mailPart.getContentType().toString());
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            this.setETag(UUID.randomUUID().toString(), 1572480000000L, result);
            return result;
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private AJAXRequestResult performPUT(MailRequest req, JSONObject bodyObject) throws OXException {
        try {
            ServerSession session = req.getSession();
            String folderPath = req.checkParameter("folder");
            String uid = req.checkParameter("id");
            String sequenceId = req.checkParameter("attachment");
            String destFolderIdentifier = req.checkParameter("dest_folder");
            MailServletInterface mailInterface = this.getMailInterface(req);
            ServerServiceRegistry serviceRegistry = ServerServiceRegistry.getInstance();
            IDBasedFileAccess fileAccess = serviceRegistry.getService(IDBasedFileAccessFactory.class).createAccess((Session)session);
            boolean performRollback = false;
            try {
                if (!session.getUserConfiguration().hasInfostore()) {
                    throw MailExceptionCode.NO_MAIL_ACCESS.create();
                }
                MailPart mailPart = mailInterface.getMessageAttachment(folderPath, uid, sequenceId, false);
                if (mailPart == null) {
                    throw MailExceptionCode.NO_ATTACHMENT_FOUND.create(sequenceId);
                }
                String destFolderID = destFolderIdentifier;
                FileMetadataParserService parser = serviceRegistry.getService(FileMetadataParserService.class, true);
                JSONObject jsonFileObject = bodyObject;
                File file = parser.parse(jsonFileObject);
                List fields = parser.getFields(jsonFileObject);
                EnumSet set = EnumSet.copyOf(fields);
                String fileName = mailPart.getFileName();
                if (GetAttachmentAction.isEmpty(fileName)) {
                    fileName = "part_" + sequenceId + ".dat";
                }
                if (!set.contains(File.Field.FILENAME) || GetAttachmentAction.isEmpty(file.getFileName())) {
                    file.setFileName(fileName);
                }
                file.setFileMIMEType(mailPart.getContentType().toString());
                file.setFileSize(0L);
                if (!set.contains(File.Field.TITLE) || GetAttachmentAction.isEmpty(file.getTitle())) {
                    file.setTitle(fileName);
                }
                file.setFolderId(destFolderID);
                fileAccess.startTransaction();
                performRollback = true;
                fileAccess.saveDocument(file, mailPart.getInputStream(), System.currentTimeMillis(), fields);
                fileAccess.commit();
            }
            catch (Exception e) {
                if (performRollback) {
                    fileAccess.rollback();
                }
                throw e;
            }
            finally {
                if (fileAccess != null) {
                    fileAccess.finish();
                }
            }
            return new AJAXRequestResult((Object)new JSONArray(), "json");
        }
        catch (OXException e) {
            throw e;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (Exception e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private static String sanitizeHtml(String htmlContent, HtmlService htmlService) {
        return htmlService.sanitize(htmlContent, null, false, null, null);
    }
}

