/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.conversion;

import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.conversion.MailPartDataSource;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.session.Session;
import java.io.InputStream;

public final class VCardMailPartDataSource
extends MailPartDataSource {
    public <D> Data<D> getData(Class<? extends D> type, DataArguments dataArguments, Session session) throws OXException {
        if (!InputStream.class.equals(type)) {
            throw DataExceptionCodes.TYPE_NOT_SUPPORTED.create(new Object[]{type.getName()});
        }
        FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(dataArguments.get(ARGS[0]));
        String fullname = arg.getFullname();
        String mailId = dataArguments.get(ARGS[1]);
        String sequenceId = dataArguments.get(ARGS[2]);
        MailPart mailPart = this.getMailPart(arg.getAccountId(), fullname, mailId, sequenceId, session);
        ContentType contentType = mailPart.getContentType();
        if (contentType == null) {
            throw DataExceptionCodes.ERROR.create(new Object[]{"Missing header 'Content-Type' in requested mail part"});
        }
        if (!contentType.isMimeType("text/*card") && !contentType.startsWith("text/directory")) {
            throw DataExceptionCodes.ERROR.create(new Object[]{"Requested mail part is not a VCard: " + contentType.getBaseType()});
        }
        DataProperties properties = new DataProperties();
        properties.put("com.openexchange.conversion.content-type", contentType.getBaseType());
        String charset = contentType.getCharsetParameter();
        if (charset == null) {
            properties.put("com.openexchange.conversion.charset", MailProperties.getInstance().getDefaultMimeCharset());
        } else {
            properties.put("com.openexchange.conversion.charset", charset);
        }
        properties.put("com.openexchange.conversion.size", String.valueOf(mailPart.getSize()));
        properties.put("com.openexchange.conversion.name", mailPart.getFileName());
        return new SimpleData((Object)mailPart.getInputStream(), properties);
    }
}

