/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class DoubleKeyMap<K1, K2, V extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 4691428774420782654L;
    private volatile transient Map<K1, Map<K2, V>> map = new ConcurrentHashMap<K1, Map<K2, V>>();
    private final Class<V> clazz;

    public DoubleKeyMap(Class<V> clazz) {
        this.clazz = clazz;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.flush();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = new ConcurrentHashMap<K1, Map<K2, V>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K1, Map<K2, V>> getMap() {
        Map<K1, Map<K2, Map<K2, V>>> m = this.map;
        if (null == m) {
            DoubleKeyMap doubleKeyMap = this;
            synchronized (doubleKeyMap) {
                m = this.map;
                if (null == m) {
                    m = new ConcurrentHashMap<K1, Map<K2, V>>();
                    this.map = m;
                }
            }
        }
        return m;
    }

    public boolean containsKey(K1 k1) {
        Map<K1, Map<K2, V>> m = this.map;
        if (null == m) {
            return false;
        }
        return m.containsKey(k1);
    }

    public boolean containsKeyPair(K1 k1, K2 k2) {
        Map<K1, Map<K2, V>> m = this.map;
        if (null == m) {
            return false;
        }
        Map<K2, V> innerMap = m.get(k1);
        if (null == innerMap) {
            return false;
        }
        return innerMap.containsKey(k2);
    }

    public V[] getValues(K1 k1) {
        Map<K1, Map<K2, V>> m = this.map;
        if (null == m) {
            return null;
        }
        Map<K2, V> innerMap = m.get(k1);
        if (innerMap == null) {
            return null;
        }
        Serializable[] newInstance = (Serializable[])Array.newInstance(this.clazz, innerMap.size());
        return innerMap.values().toArray(newInstance);
    }

    public V[] getValues(K1 k1, K2[] keys) {
        Map<K1, Map<K2, V>> m = this.map;
        if (null == m) {
            return null;
        }
        Map<K2, V> innerMap = m.get(k1);
        if (innerMap == null) {
            return null;
        }
        ArrayList<V> tmp = new ArrayList<V>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            tmp.add(innerMap.get(keys[i]));
        }
        Serializable[] newInstance = (Serializable[])Array.newInstance(this.clazz, tmp.size());
        return tmp.toArray(newInstance);
    }

    public V getValue(K1 k1, K2 k2) {
        Map<K1, Map<K2, V>> m = this.map;
        if (null == m) {
            return null;
        }
        Map<K2, V> innerMap = m.get(k1);
        if (null == innerMap) {
            return null;
        }
        return (V)((Serializable)innerMap.get(k2));
    }

    public void putValues(K1 k1, K2[] keys, V[] values) {
        if (k1 == null || keys == null || values == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        Map<K1, Map<K2, Map<K2, V>>> m = this.getMap();
        Map<K2, V> innerMap = m.get(k1);
        if (innerMap == null) {
            innerMap = new ConcurrentHashMap<K2, V>(values.length);
            m.put(k1, innerMap);
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            innerMap.put(keys[i], values[i]);
        }
    }

    public V putValue(K1 k1, K2 k2, V value) {
        if (k1 == null || k2 == null || value == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        Map<K1, Map<K2, Map<K2, V>>> m = this.getMap();
        Map<K2, V> innerMap = m.get(k1);
        if (innerMap == null) {
            innerMap = new ConcurrentHashMap<K2, V>();
            m.put(k1, innerMap);
        }
        return (V)((Serializable)innerMap.put(k2, value));
    }

    public void removeValues(K1 k1) {
        Map<K1, Map<K2, V>> m = this.map;
        if (null == m) {
            return;
        }
        m.remove(k1);
    }

    public void removeValues(K1 k1, K2[] keys) {
        Map<K1, Map<K2, V>> m = this.map;
        if (null == m) {
            return;
        }
        Map<K2, V> innerMap = m.get(k1);
        if (null == innerMap) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            innerMap.remove(keys[i]);
        }
        if (innerMap.isEmpty()) {
            m.remove(k1);
        }
    }

    public V removeValue(K1 k1, K2 k2) {
        Map<K1, Map<K2, V>> m = this.map;
        if (null == m) {
            return null;
        }
        Map<K2, V> innerMap = m.get(k1);
        if (null == innerMap) {
            return null;
        }
        Serializable retval = (Serializable)innerMap.remove(k2);
        if (retval != null && innerMap.isEmpty()) {
            m.remove(k1);
        }
        return (V)retval;
    }

    public boolean isEmpty(K1 k1) {
        Map<K1, Map<K2, V>> m = this.map;
        if (null == m) {
            return false;
        }
        Map<K2, V> innerMap = m.get(k1);
        if (null == innerMap) {
            return true;
        }
        if (innerMap.isEmpty()) {
            m.remove(k1);
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        Map<K1, Map<K2, V>> m = this.map;
        if (null == m) {
            return true;
        }
        return m.isEmpty();
    }

    public void clear() {
        Map<K1, Map<K2, V>> m = this.map;
        if (null != m) {
            m.clear();
        }
    }
}

