/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.json;

import com.openexchange.tools.stack.ArrayStack;
import com.openexchange.tools.stack.Stack;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.json.JSONWriter;

public final class OXJSONWriter
extends JSONWriter {
    private static final int MODE_INIT = 0;
    private static final int MODE_ARR = 1;
    private static final int MODE_OBJ = 2;
    private static final int MODE_KEY = 3;
    private static final int MODE_DONE = 4;
    private int mode = 0;
    private JSONValue jsonValue;
    private int jsonObjectType;
    private final Stack<StackObject> stackObjs = new ArrayStack<StackObject>(StackObject.class);
    private String key;

    public OXJSONWriter() {
        super(null);
    }

    public OXJSONWriter(JSONObject jsonObject) throws JSONException {
        super(null);
        this.jsonValue = jsonObject;
        this.jsonObjectType = 2;
        this.mode = 2;
        this.pushObject(jsonObject);
    }

    public OXJSONWriter(JSONArray jsonArray) throws JSONException {
        super(null);
        this.jsonValue = jsonArray;
        this.jsonObjectType = 1;
        this.pushArray(jsonArray);
    }

    public JSONWriter array() throws JSONException {
        if (this.mode != 0 && this.mode != 2 && this.mode != 1) {
            throw new JSONException("Misplaced array. Current mode: " + this.mode2string());
        }
        JSONArray ja = new JSONArray();
        if (this.mode == 0) {
            this.jsonValue = ja;
            this.jsonObjectType = 1;
        }
        this.pushArray(ja);
        return this;
    }

    public JSONWriter endArray() throws JSONException {
        if (this.mode != 1) {
            throw new JSONException("Misplaced endArray. Current mode: " + this.mode2string());
        }
        this.pop();
        return this;
    }

    public JSONWriter object() throws JSONException {
        if (this.mode != 0 && this.mode != 2 && this.mode != 1) {
            throw new JSONException("Misplaced object. Current mode: " + this.mode2string());
        }
        JSONObject jo = new JSONObject();
        if (this.mode == 0) {
            this.jsonValue = jo;
            this.jsonObjectType = 2;
            this.mode = 2;
        }
        this.pushObject(jo);
        return this;
    }

    public JSONWriter endObject() throws JSONException {
        if (this.mode != 3) {
            throw new JSONException("Misplaced endObject. Current mode: " + this.mode2string());
        }
        this.pop();
        return this;
    }

    public JSONWriter key(String key) throws JSONException {
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (this.mode != 3) {
            throw new JSONException("Misplaced key. Current mode: " + this.mode2string());
        }
        this.key = key;
        this.mode = 2;
        return this;
    }

    public JSONWriter value(boolean b) throws JSONException {
        return this.append(b);
    }

    public JSONWriter value(double d) throws JSONException {
        return this.value((Object)d);
    }

    public JSONWriter value(long l) throws JSONException {
        return this.append(l);
    }

    public JSONWriter value(Object o) throws JSONException {
        return this.append(o);
    }

    public boolean isComplete() {
        return this.mode == 4;
    }

    public boolean isJSONArray() {
        return this.jsonObjectType == 1;
    }

    public boolean isJSONObject() {
        return this.jsonObjectType == 2;
    }

    public JSONValue getObject() {
        return this.jsonValue;
    }

    public boolean isEmpty() {
        return this.mode == 0;
    }

    public boolean isExpectingValue() {
        return this.mode == 2 || this.mode == 1;
    }

    public boolean isExpectingKey() {
        return this.mode == 3;
    }

    public void reset() {
        this.mode = 0;
        this.stackObjs.clear();
        this.jsonValue = null;
        this.jsonObjectType = 0;
        this.key = null;
    }

    public String toString() {
        return this.jsonValue == null ? "[empty]" : this.jsonValue.toString();
    }

    private JSONWriter append(Object value) throws JSONException {
        if (this.mode != 2 && this.mode != 1) {
            throw new JSONException("Value out of sequence. Current mode: " + this.mode2string());
        }
        StackObject so = this.stackObjs.top();
        if (1 == so.type) {
            ((JSONArray)so.jsonValue).put(value);
        } else if (2 == so.type) {
            ((JSONObject)so.jsonValue).put(this.key, value);
            this.key = null;
        }
        if (this.mode == 2) {
            this.mode = 3;
        }
        return this;
    }

    private void pushArray(JSONArray ja) throws JSONException {
        if (!this.stackObjs.isEmpty()) {
            StackObject stackObject = this.stackObjs.top();
            if (1 == stackObject.type) {
                ((JSONArray)stackObject.jsonValue).put((Object)ja);
            } else if (2 == stackObject.type) {
                ((JSONObject)stackObject.jsonValue).put(this.key, (Object)ja);
                this.key = null;
            }
        }
        this.stackObjs.push(new StackObject(1, (JSONValue)ja));
        this.mode = 1;
    }

    private void pop() {
        if (null == this.stackObjs.topAndPop() || this.stackObjs.isEmpty()) {
            this.mode = 4;
            return;
        }
        if (1 == this.stackObjs.top().type) {
            this.mode = 1;
        } else if (2 == this.stackObjs.top().type) {
            this.mode = 3;
        }
    }

    private void pushObject(JSONObject jo) throws JSONException {
        if (!this.stackObjs.isEmpty()) {
            StackObject stackObject = this.stackObjs.top();
            if (1 == stackObject.type) {
                ((JSONArray)stackObject.jsonValue).put((Object)jo);
            } else if (2 == stackObject.type) {
                ((JSONObject)stackObject.jsonValue).put(this.key, (Object)jo);
                this.key = null;
            }
        }
        this.stackObjs.push(new StackObject(2, (JSONValue)jo));
        this.mode = 3;
    }

    private String mode2string() {
        switch (this.mode) {
            case 0: {
                return "INIT";
            }
            case 1: {
                return "ARRAY";
            }
            case 2: {
                return "OBJECT";
            }
            case 3: {
                return "KEY";
            }
            case 4: {
                return "DONE";
            }
        }
        return "UNKNOWN";
    }

    private static final class StackObject {
        public final int type;
        public final JSONValue jsonValue;

        public StackObject(int type, JSONValue jsonValue) {
            this.type = type;
            this.jsonValue = jsonValue;
        }
    }
}

