/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;

public enum UserConfigurationExceptionCodes {
    SQL_ERROR("A SQL error occurred: %1$s", Category.CATEGORY_ERROR, 1),
    DBPOOL_ERROR("A DBPooling error occurred", Category.CATEGORY_ERROR, 2),
    NOT_FOUND("Configuration for user %1$s could not be found in context %2$d", Category.CATEGORY_ERROR, 3),
    MISSING_SETTING("Missing property %1$s in system.properties.", Category.CATEGORY_CONFIGURATION, 4),
    CLASS_NOT_FOUND("Class %1$s can not be found.", Category.CATEGORY_CONFIGURATION, 5),
    INSTANTIATION_FAILED("Instantiating the class failed.", Category.CATEGORY_ERROR, 6),
    CACHE_INITIALIZATION_FAILED("Cache initialization failed. Region: %1$s", Category.CATEGORY_ERROR, 7),
    CACHE_PUT_ERROR("User configuration could not be put into cache: %1$s", Category.CATEGORY_ERROR, 8),
    CACHE_CLEAR_ERROR("User configuration cache could not be cleared: %1$s", Category.CATEGORY_ERROR, 9),
    CACHE_REMOVE_ERROR("User configuration could not be removed from cache: %1$s", Category.CATEGORY_ERROR, 9),
    MAIL_SETTING_NOT_FOUND("Mail settings for user %1$s could not be found in context %2$d", Category.CATEGORY_ERROR, 10);

    private final String message;
    private final int detailNumber;
    private final Category category;
    private static final String PREFIX = "USS";

    private UserConfigurationExceptionCodes(String message, Category category, int detailNumber) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
    }

    public OXException create() {
        return this.create(new Object[0]);
    }

    public OXException create(Object ... logArguments) {
        return this.create(null, logArguments);
    }

    public OXException create(Throwable cause, Object ... logArguments) {
        return new OXException(this.detailNumber, "A severe error occurred.", cause, new Object[0]).setPrefix(PREFIX).addCategory(this.category).setLogMessage(this.message, logArguments);
    }
}

