/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationCodes;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.map.hash.TIntIntHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;

public class RdbUserConfigurationStorage
extends UserConfigurationStorage {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(RdbUserConfigurationStorage.class);
    private static final AtomicBoolean initExtendedPermissions = new AtomicBoolean(true);
    private static final String SQL_SELECT = "SELECT user FROM user_configuration WHERE cid = ? AND user = ?";
    private static final String INSERT_USER_CONFIGURATION = "INSERT INTO user_configuration (cid, user, permissions) VALUES (?, ?, ?)";
    private static final String UPDATE_USER_CONFIGURATION = "UPDATE user_configuration SET permissions = ? WHERE cid = ? AND user = ?";
    private static final String LOAD_USER_CONFIGURATION = "SELECT permissions FROM user_configuration WHERE cid = ? AND user = ?";
    private static final String LOAD_SOME_USER_CONFIGURATIONS = "SELECT user,permissions FROM user_configuration WHERE cid=? AND user IN (";
    private static final String COUNT_USERS_BY_PERMISSION = "SELECT COUNT(permissions) FROM user_configuration WHERE cid = ? AND permissions = ?";
    private static final int LIMIT = 1000;
    private static final String DELETE_USER_CONFIGURATION = "DELETE FROM user_configuration WHERE cid = ? AND user = ?";

    public static void setInitExtendedPermissions(boolean initExtendedPermissions) {
        RdbUserConfigurationStorage.initExtendedPermissions.set(initExtendedPermissions);
    }

    @Override
    protected void startInternal() {
    }

    @Override
    protected void stopInternal() {
    }

    @Override
    public UserConfiguration getUserConfiguration(int userId, int[] groups, Context ctx, boolean initExtendedPermissions) throws OXException {
        try {
            return RdbUserConfigurationStorage.loadUserConfiguration(userId, groups, ctx, initExtendedPermissions, null);
        }
        catch (SQLException e) {
            throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public UserConfiguration[] getUserConfiguration(Context ctx, User[] users) throws OXException {
        try {
            return RdbUserConfigurationStorage.loadUserConfiguration(ctx, null, users);
        }
        catch (SQLException e) {
            throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void clearStorage() {
    }

    @Override
    public void removeUserConfiguration(int userId, Context ctx) {
    }

    @Override
    public void saveUserConfiguration(int permissionBits, int userId, Context ctx) throws OXException {
        RdbUserConfigurationStorage.saveUserConfiguration0(permissionBits, userId, ctx);
    }

    public static void saveUserConfiguration(UserConfiguration userConfig, boolean insert, Connection writeCon) throws SQLException, OXException {
        RdbUserConfigurationStorage.saveUserConfiguration(userConfig.getPermissionBits(), userConfig.getUserId(), insert, userConfig.getContext(), writeCon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveUserConfiguration0(int permissionBits, int userId, Context ctx) throws OXException {
        boolean insert = false;
        try {
            Connection readCon = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                readCon = DBPool.pickup(ctx);
                stmt = readCon.prepareStatement(SQL_SELECT);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, userId);
                rs = stmt.executeQuery();
                insert = !rs.next();
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
                throw throwable;
            }
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            RdbUserConfigurationStorage.saveUserConfiguration(permissionBits, userId, insert, ctx, null);
        }
        catch (SQLException e) {
            throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveUserConfiguration(int permissionBits, int userId, boolean insert, Context ctx, Connection writeConArg) throws SQLException, OXException {
        Connection writeCon = writeConArg;
        boolean closeConnection = false;
        PreparedStatement stmt = null;
        try {
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeConnection = true;
            }
            if (insert) {
                stmt = writeCon.prepareStatement(INSERT_USER_CONFIGURATION);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, userId);
                stmt.setInt(3, permissionBits);
            } else {
                stmt = writeCon.prepareStatement(UPDATE_USER_CONFIGURATION);
                stmt.setInt(1, permissionBits);
                stmt.setInt(2, ctx.getContextId());
                stmt.setInt(3, userId);
            }
            stmt.executeUpdate();
            if (!insert) {
                try {
                    UserConfigurationStorage.getInstance().removeUserConfiguration(userId, ctx);
                }
                catch (OXException e) {
                    LOG.warn((Object)"User Configuration could not be removed from cache", (Throwable)e);
                }
            }
            DBUtils.closeResources(null, (Statement)stmt, closeConnection ? writeCon : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeConnection ? writeCon : null, false, ctx);
            throw throwable;
        }
    }

    public static UserConfiguration loadUserConfiguration(int userId, Context ctx) throws SQLException, OXException {
        return RdbUserConfigurationStorage.loadUserConfiguration(userId, null, ctx, true, null);
    }

    public static UserConfiguration loadUserConfiguration(int userId, int[] groups, Context ctx) throws SQLException, OXException {
        return RdbUserConfigurationStorage.loadUserConfiguration(userId, groups, ctx, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserConfiguration adminLoadUserConfiguration(int userId, int[] groups, int cid, Connection readConArg) throws SQLException, OXException {
        UserConfiguration userConfiguration;
        ContextImpl ctx = new ContextImpl(cid);
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            UserConfiguration uc;
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            stmt = readCon.prepareStatement(LOAD_USER_CONFIGURATION);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            UserConfiguration userConfiguration2 = uc = rs.next() ? new UserConfiguration(rs.getInt(1), userId, groups, ctx) : new UserConfiguration(0, userId, groups, ctx);
            if (initExtendedPermissions.get()) {
                uc.setExtendedPermissions(uc.calcExtendedPermissions());
            }
            userConfiguration = uc;
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return userConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int adminCountUsersByPermission(int cid, UserConfiguration userconf, Connection readConArg) throws SQLException, OXException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeReadCon;
        Connection readCon;
        ContextImpl ctx;
        block4: {
            int n;
            ctx = new ContextImpl(cid);
            readCon = readConArg;
            closeReadCon = false;
            stmt = null;
            rs = null;
            try {
                if (readCon == null) {
                    readCon = DBPool.pickup(ctx);
                    closeReadCon = true;
                }
                stmt = readCon.prepareStatement(COUNT_USERS_BY_PERMISSION);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, userconf.getPermissionBits());
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                n = rs.getInt(1);
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
                throw throwable;
            }
            return n;
        }
        int n = -1;
        DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserConfiguration loadUserConfiguration(int userId, int[] groupsArg, Context ctx, boolean calcPerms, Connection readConArg) throws SQLException, OXException {
        UserConfiguration userConfiguration;
        int[] groups = groupsArg == null ? UserStorage.getInstance().getUser(userId, ctx).getGroups() : groupsArg;
        Connection readCon = readConArg;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(LOAD_USER_CONFIGURATION);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw UserConfigurationCodes.NOT_FOUND.create(userId, ctx.getContextId());
            }
            UserConfiguration userConfiguration2 = new UserConfiguration(rs.getInt(1), userId, groups, ctx);
            if (calcPerms && initExtendedPermissions.get()) {
                userConfiguration2.setExtendedPermissions(userConfiguration2.calcExtendedPermissions());
            }
            userConfiguration = userConfiguration2;
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return userConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserConfiguration[] loadUserConfiguration(Context ctx, Connection conArg, User[] users) throws OXException, SQLException {
        boolean closeCon;
        Connection con;
        int length = users.length;
        if (0 == length) {
            return new UserConfiguration[0];
        }
        if (null == conArg) {
            con = DBPool.pickup(ctx);
            closeCon = true;
        } else {
            con = conArg;
            closeCon = false;
        }
        PreparedStatement stmt = null;
        ResultSet result = null;
        UserConfiguration[] retval = new UserConfiguration[length];
        try {
            User user;
            int index;
            TIntIntHashMap userMap;
            if (length <= 1000) {
                StringBuilder sb = new StringBuilder(512);
                sb.append("SELECT u.user, u.permissions FROM user_configuration AS u");
                if (1 == length) {
                    sb.append(" WHERE u.user = ? AND u.cid = ?");
                } else {
                    sb.append(" INNER JOIN (");
                    sb.append("SELECT ? AS user");
                    for (int i = 1; i < length; ++i) {
                        sb.append(" UNION ALL SELECT ?");
                    }
                    sb.append(") AS x ON u.user = x.user WHERE u.cid = ?");
                }
                stmt = con.prepareStatement(sb.toString());
                int pos = 1;
                userMap = new TIntIntHashMap(length, 1.0f);
                for (index = 0; index < length; ++index) {
                    user = users[index];
                    stmt.setInt(pos++, user.getId());
                    userMap.put(user.getId(), index);
                }
                stmt.setInt(pos++, ctx.getContextId());
            } else {
                stmt = con.prepareStatement("SELECT u.user, u.permissions FROM user_configuration AS u WHERE u.cid = ?");
                userMap = new TIntIntHashMap(length, 1.0f);
                for (int index2 = 0; index2 < length; ++index2) {
                    userMap.put(users[index2].getId(), index2);
                }
                stmt.setInt(1, ctx.getContextId());
            }
            result = stmt.executeQuery();
            boolean initExtPerms = initExtendedPermissions.get();
            while (result.next()) {
                int userId = result.getInt(1);
                if (!userMap.containsKey(userId)) continue;
                index = userMap.get(userId);
                user = users[index];
                UserConfiguration userConfiguration = new UserConfiguration(result.getInt(2), user.getId(), user.getGroups(), ctx);
                if (initExtPerms) {
                    userConfiguration.setExtendedPermissions(userConfiguration.calcExtendedPermissions());
                }
                retval[index] = userConfiguration;
            }
            DBUtils.closeResources(result, (Statement)stmt, closeCon ? con : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(result, (Statement)stmt, closeCon ? con : null, true, ctx);
            throw throwable;
        }
        return retval;
    }

    public static void deleteUserConfiguration(int userId, Context ctx) throws SQLException, OXException {
        RdbUserConfigurationStorage.deleteUserConfiguration(userId, null, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteUserConfiguration(int userId, Connection writeConArg, Context ctx) throws SQLException, OXException {
        Connection writeCon = writeConArg;
        boolean closeWriteCon = false;
        PreparedStatement stmt = null;
        try {
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            stmt = writeCon.prepareStatement(DELETE_USER_CONFIGURATION);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, userId);
            stmt.executeUpdate();
            try {
                UserConfigurationStorage.getInstance().removeUserConfiguration(userId, ctx);
            }
            catch (OXException e) {
                LOG.warn((Object)"User Configuration could not be removed from cache", (Throwable)e);
            }
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
            throw throwable;
        }
    }
}

